// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.Tag
import aws.sdk.kotlin.services.memorydb.model.TagResourceResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class TagResourceOperationDeserializer: HttpDeserialize<TagResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TagResourceResponse {
        if (!response.status.isSuccess()) {
            throwTagResourceError(context, response)
        }
        val builder = TagResourceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTagResourceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwTagResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ACLNotFoundFault" -> AclNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterNotFoundFault" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidARNFault" -> InvalidArnFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterStateFault" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "ParameterGroupNotFoundFault" -> ParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotNotFoundFault" -> SnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SubnetGroupNotFoundFault" -> SubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedResponse)
        "UserNotFoundFault" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTagResourceOperationBody(builder: TagResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TAGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TAGLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TAGLIST_DESCRIPTOR.index -> builder.tagList =
                    deserializer.deserializeList(TAGLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
