// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.migrationhub.model.*
import aws.sdk.kotlin.services.migrationhub.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Migration Hub"
public const val ServiceApiVersion: String = "2017-05-31"
public const val SdkVersion: String = "0.17.2-beta"

internal class DefaultMigrationHubClient(override val config: MigrationHubClient.Config) : MigrationHubClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:
     * + Migration tools can call the `AssociateCreatedArtifact` operation to indicate which AWS artifact is associated with a migration task.
     * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
     * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.
     */
    override suspend fun associateCreatedArtifact(input: AssociateCreatedArtifactRequest): AssociateCreatedArtifactResponse {
        val op = SdkHttpOperation.build<AssociateCreatedArtifactRequest, AssociateCreatedArtifactResponse> {
            serializer = AssociateCreatedArtifactOperationSerializer()
            deserializer = AssociateCreatedArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateCreatedArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a discovered resource ID from Application Discovery Service with a migration task.
     */
    override suspend fun associateDiscoveredResource(input: AssociateDiscoveredResourceRequest): AssociateDiscoveredResourceResponse {
        val op = SdkHttpOperation.build<AssociateDiscoveredResourceRequest, AssociateDiscoveredResourceResponse> {
            serializer = AssociateDiscoveredResourceOperationSerializer()
            deserializer = AssociateDiscoveredResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDiscoveredResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.
     */
    override suspend fun createProgressUpdateStream(input: CreateProgressUpdateStreamRequest): CreateProgressUpdateStreamResponse {
        val op = SdkHttpOperation.build<CreateProgressUpdateStreamRequest, CreateProgressUpdateStreamResponse> {
            serializer = CreateProgressUpdateStreamOperationSerializer()
            deserializer = CreateProgressUpdateStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProgressUpdateStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:
     * + The only parameter needed for `DeleteProgressUpdateStream` is the stream name (same as a `CreateProgressUpdateStream` call).
     * + The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).
     * + If the stream takes time to be deleted, it might still show up on a `ListProgressUpdateStreams` call.
     * + `CreateProgressUpdateStream`, `ImportMigrationTask`, `NotifyMigrationTaskState`, and all Associate&#91;*&#93; APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.
     * + Once the stream and all of its resources are deleted, `CreateProgressUpdateStream` for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).
     */
    override suspend fun deleteProgressUpdateStream(input: DeleteProgressUpdateStreamRequest): DeleteProgressUpdateStreamResponse {
        val op = SdkHttpOperation.build<DeleteProgressUpdateStreamRequest, DeleteProgressUpdateStreamResponse> {
            serializer = DeleteProgressUpdateStreamOperationSerializer()
            deserializer = DeleteProgressUpdateStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProgressUpdateStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the migration status of an application.
     */
    override suspend fun describeApplicationState(input: DescribeApplicationStateRequest): DescribeApplicationStateResponse {
        val op = SdkHttpOperation.build<DescribeApplicationStateRequest, DescribeApplicationStateResponse> {
            serializer = DescribeApplicationStateOperationSerializer()
            deserializer = DescribeApplicationStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplicationState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of all attributes associated with a specific migration task.
     */
    override suspend fun describeMigrationTask(input: DescribeMigrationTaskRequest): DescribeMigrationTaskResponse {
        val op = SdkHttpOperation.build<DescribeMigrationTaskRequest, DescribeMigrationTaskResponse> {
            serializer = DescribeMigrationTaskOperationSerializer()
            deserializer = DescribeMigrationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMigrationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:
     * + A migration user can call the `DisassociateCreatedArtifacts` operation to disassociate a created AWS Artifact from a migration task.
     * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
     * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.
     */
    override suspend fun disassociateCreatedArtifact(input: DisassociateCreatedArtifactRequest): DisassociateCreatedArtifactResponse {
        val op = SdkHttpOperation.build<DisassociateCreatedArtifactRequest, DisassociateCreatedArtifactResponse> {
            serializer = DisassociateCreatedArtifactOperationSerializer()
            deserializer = DisassociateCreatedArtifactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateCreatedArtifact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociate an Application Discovery Service discovered resource from a migration task.
     */
    override suspend fun disassociateDiscoveredResource(input: DisassociateDiscoveredResourceRequest): DisassociateDiscoveredResourceResponse {
        val op = SdkHttpOperation.build<DisassociateDiscoveredResourceRequest, DisassociateDiscoveredResourceResponse> {
            serializer = DisassociateDiscoveredResourceOperationSerializer()
            deserializer = DisassociateDiscoveredResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateDiscoveredResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration tool.
     *
     * This API is a prerequisite to calling the `NotifyMigrationTaskState` API as the migration tool must first register the migration task with Migration Hub.
     */
    override suspend fun importMigrationTask(input: ImportMigrationTaskRequest): ImportMigrationTaskResponse {
        val op = SdkHttpOperation.build<ImportMigrationTaskRequest, ImportMigrationTaskResponse> {
            serializer = ImportMigrationTaskOperationSerializer()
            deserializer = ImportMigrationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportMigrationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the migration statuses for your applications. If you use the optional `ApplicationIds` parameter, only the migration statuses for those applications will be returned.
     */
    override suspend fun listApplicationStates(input: ListApplicationStatesRequest): ListApplicationStatesResponse {
        val op = SdkHttpOperation.build<ListApplicationStatesRequest, ListApplicationStatesResponse> {
            serializer = ListApplicationStatesOperationSerializer()
            deserializer = ListApplicationStatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplicationStates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:
     * + Gets the list of the created artifacts while migration is taking place.
     * + Shows the artifacts created by the migration tool that was associated by the `AssociateCreatedArtifact` API.
     * + Lists created artifacts in a paginated interface.
     */
    override suspend fun listCreatedArtifacts(input: ListCreatedArtifactsRequest): ListCreatedArtifactsResponse {
        val op = SdkHttpOperation.build<ListCreatedArtifactsRequest, ListCreatedArtifactsResponse> {
            serializer = ListCreatedArtifactsOperationSerializer()
            deserializer = ListCreatedArtifactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCreatedArtifacts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists discovered resources associated with the given `MigrationTask`.
     */
    override suspend fun listDiscoveredResources(input: ListDiscoveredResourcesRequest): ListDiscoveredResourcesResponse {
        val op = SdkHttpOperation.build<ListDiscoveredResourcesRequest, ListDiscoveredResourcesResponse> {
            serializer = ListDiscoveredResourcesOperationSerializer()
            deserializer = ListDiscoveredResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDiscoveredResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This API has the following traits:
     * + Can show a summary list of the most recent migration tasks.
     * + Can show a summary list of migration tasks associated with a given discovered resource.
     * + Lists migration tasks in a paginated interface.
     */
    override suspend fun listMigrationTasks(input: ListMigrationTasksRequest): ListMigrationTasksResponse {
        val op = SdkHttpOperation.build<ListMigrationTasksRequest, ListMigrationTasksResponse> {
            serializer = ListMigrationTasksOperationSerializer()
            deserializer = ListMigrationTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMigrationTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists progress update streams associated with the user account making this call.
     */
    override suspend fun listProgressUpdateStreams(input: ListProgressUpdateStreamsRequest): ListProgressUpdateStreamsResponse {
        val op = SdkHttpOperation.build<ListProgressUpdateStreamsRequest, ListProgressUpdateStreamsResponse> {
            serializer = ListProgressUpdateStreamsOperationSerializer()
            deserializer = ListProgressUpdateStreamsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProgressUpdateStreams"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the migration state of an application. For a given application identified by the value passed to `ApplicationId`, its status is set or updated by passing one of three values to `Status`: `NOT_STARTED | IN_PROGRESS | COMPLETED`.
     */
    override suspend fun notifyApplicationState(input: NotifyApplicationStateRequest): NotifyApplicationStateResponse {
        val op = SdkHttpOperation.build<NotifyApplicationStateRequest, NotifyApplicationStateResponse> {
            serializer = NotifyApplicationStateOperationSerializer()
            deserializer = NotifyApplicationStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "NotifyApplicationState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:
     * + Migration tools will call the `NotifyMigrationTaskState` API to share the latest progress and status.
     * + `MigrationTaskName` is used for addressing updates to the correct target.
     * + `ProgressUpdateStream` is used for access control and to provide a namespace for each migration tool.
     */
    override suspend fun notifyMigrationTaskState(input: NotifyMigrationTaskStateRequest): NotifyMigrationTaskStateResponse {
        val op = SdkHttpOperation.build<NotifyMigrationTaskStateRequest, NotifyMigrationTaskStateResponse> {
            serializer = NotifyMigrationTaskStateOperationSerializer()
            deserializer = NotifyMigrationTaskStateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "NotifyMigrationTaskState"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after `PutResourceAttributes` returns.
     *
     * + Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to *add* an IP address, it will then be required to call it with *both* the IP and MAC addresses to prevent overriding the MAC address.
     * + Note the instructions regarding the special use case of the `ResourceAttributeList`[](https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList) parameter when specifying any "VM" related value.
     * Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call `ListDiscoveredResources`.
     */
    override suspend fun putResourceAttributes(input: PutResourceAttributesRequest): PutResourceAttributesResponse {
        val op = SdkHttpOperation.build<PutResourceAttributesRequest, PutResourceAttributesResponse> {
            serializer = PutResourceAttributesOperationSerializer()
            deserializer = PutResourceAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutResourceAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSMigrationHub", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mgh"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "mgh")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
