// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub.model



/**
 * Attribute associated with a resource.
 *
 * Note the corresponding format required per type listed below:
 *
 * ## IPV4
 * `x.x.x.x`
 *
 * *where x is an integer in the range &#91;0,255&#93;*
 *
 * ## IPV6
 * `y : y : y : y : y : y : y : y`
 *
 * *where y is a hexadecimal between 0 and FFFF. &#91;0, FFFF&#93;*
 *
 * ## MAC_ADDRESS
 * `^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$`
 *
 * ## FQDN
 * `^[^<>{}\\\\/?,=\\p{Cntrl}]{1,256}$`
 */
public class ResourceAttribute private constructor(builder: Builder) {
    /**
     * Type of resource.
     */
    public val type: aws.sdk.kotlin.services.migrationhub.model.ResourceAttributeType? = builder.type
    /**
     * Value of the resource type.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhub.model.ResourceAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceAttribute(")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceAttribute

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhub.model.ResourceAttribute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Type of resource.
         */
        public var type: aws.sdk.kotlin.services.migrationhub.model.ResourceAttributeType? = null
        /**
         * Value of the resource type.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhub.model.ResourceAttribute) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhub.model.ResourceAttribute = ResourceAttribute(this)
    }
}
