// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.migrationhub.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.migrationhub.endpoints.EndpointProvider
import aws.sdk.kotlin.services.migrationhub.model.*
import aws.sdk.kotlin.services.migrationhub.model.AssociateCreatedArtifactRequest
import aws.sdk.kotlin.services.migrationhub.model.AssociateCreatedArtifactResponse
import aws.sdk.kotlin.services.migrationhub.model.AssociateDiscoveredResourceRequest
import aws.sdk.kotlin.services.migrationhub.model.AssociateDiscoveredResourceResponse
import aws.sdk.kotlin.services.migrationhub.model.CreateProgressUpdateStreamRequest
import aws.sdk.kotlin.services.migrationhub.model.CreateProgressUpdateStreamResponse
import aws.sdk.kotlin.services.migrationhub.model.DeleteProgressUpdateStreamRequest
import aws.sdk.kotlin.services.migrationhub.model.DeleteProgressUpdateStreamResponse
import aws.sdk.kotlin.services.migrationhub.model.DescribeApplicationStateRequest
import aws.sdk.kotlin.services.migrationhub.model.DescribeApplicationStateResponse
import aws.sdk.kotlin.services.migrationhub.model.DescribeMigrationTaskRequest
import aws.sdk.kotlin.services.migrationhub.model.DescribeMigrationTaskResponse
import aws.sdk.kotlin.services.migrationhub.model.DisassociateCreatedArtifactRequest
import aws.sdk.kotlin.services.migrationhub.model.DisassociateCreatedArtifactResponse
import aws.sdk.kotlin.services.migrationhub.model.DisassociateDiscoveredResourceRequest
import aws.sdk.kotlin.services.migrationhub.model.DisassociateDiscoveredResourceResponse
import aws.sdk.kotlin.services.migrationhub.model.ImportMigrationTaskRequest
import aws.sdk.kotlin.services.migrationhub.model.ImportMigrationTaskResponse
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsResponse
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksRequest
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksResponse
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsResponse
import aws.sdk.kotlin.services.migrationhub.model.NotifyApplicationStateRequest
import aws.sdk.kotlin.services.migrationhub.model.NotifyApplicationStateResponse
import aws.sdk.kotlin.services.migrationhub.model.NotifyMigrationTaskStateRequest
import aws.sdk.kotlin.services.migrationhub.model.NotifyMigrationTaskStateResponse
import aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesRequest
import aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * The AWS Migration Hub API methods help to obtain server and application migration status and integrate your resource-specific migration tool by providing a programmatic interface to Migration Hub.
 *
 * Remember that you must set your AWS Migration Hub home region before you call any of these APIs, or a `HomeRegionNotSetException` error will be returned. Also, you must make the API calls while in your home region.
 */
public interface MigrationHubClient : SdkClient {

    override val serviceName: String
        get() = "Migration Hub"
    /**
     * MigrationHubClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MigrationHubClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMigrationHubClient(config)
        }

        public operator fun invoke(config: Config): MigrationHubClient = DefaultMigrationHubClient(config)

        /**
         * Construct a [MigrationHubClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MigrationHubClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMigrationHubClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Migration Hub")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:
     * + Migration tools can call the `AssociateCreatedArtifact` operation to indicate which AWS artifact is associated with a migration task.
     * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
     * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.
     */
    public suspend fun associateCreatedArtifact(input: AssociateCreatedArtifactRequest): AssociateCreatedArtifactResponse

    /**
     * Associates a discovered resource ID from Application Discovery Service with a migration task.
     */
    public suspend fun associateDiscoveredResource(input: AssociateDiscoveredResourceRequest): AssociateDiscoveredResourceResponse

    /**
     * Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.
     */
    public suspend fun createProgressUpdateStream(input: CreateProgressUpdateStreamRequest): CreateProgressUpdateStreamResponse

    /**
     * Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:
     * + The only parameter needed for `DeleteProgressUpdateStream` is the stream name (same as a `CreateProgressUpdateStream` call).
     * + The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).
     * + If the stream takes time to be deleted, it might still show up on a `ListProgressUpdateStreams` call.
     * + `CreateProgressUpdateStream`, `ImportMigrationTask`, `NotifyMigrationTaskState`, and all Associate&#91;*&#93; APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.
     * + Once the stream and all of its resources are deleted, `CreateProgressUpdateStream` for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).
     */
    public suspend fun deleteProgressUpdateStream(input: DeleteProgressUpdateStreamRequest): DeleteProgressUpdateStreamResponse

    /**
     * Gets the migration status of an application.
     */
    public suspend fun describeApplicationState(input: DescribeApplicationStateRequest): DescribeApplicationStateResponse

    /**
     * Retrieves a list of all attributes associated with a specific migration task.
     */
    public suspend fun describeMigrationTask(input: DescribeMigrationTaskRequest): DescribeMigrationTaskResponse

    /**
     * Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:
     * + A migration user can call the `DisassociateCreatedArtifacts` operation to disassociate a created AWS Artifact from a migration task.
     * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
     * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.
     */
    public suspend fun disassociateCreatedArtifact(input: DisassociateCreatedArtifactRequest): DisassociateCreatedArtifactResponse

    /**
     * Disassociate an Application Discovery Service discovered resource from a migration task.
     */
    public suspend fun disassociateDiscoveredResource(input: DisassociateDiscoveredResourceRequest): DisassociateDiscoveredResourceResponse

    /**
     * Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration tool.
     *
     * This API is a prerequisite to calling the `NotifyMigrationTaskState` API as the migration tool must first register the migration task with Migration Hub.
     */
    public suspend fun importMigrationTask(input: ImportMigrationTaskRequest): ImportMigrationTaskResponse

    /**
     * Lists all the migration statuses for your applications. If you use the optional `ApplicationIds` parameter, only the migration statuses for those applications will be returned.
     */
    public suspend fun listApplicationStates(input: ListApplicationStatesRequest = ListApplicationStatesRequest {}): ListApplicationStatesResponse

    /**
     * Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:
     * + Gets the list of the created artifacts while migration is taking place.
     * + Shows the artifacts created by the migration tool that was associated by the `AssociateCreatedArtifact` API.
     * + Lists created artifacts in a paginated interface.
     */
    public suspend fun listCreatedArtifacts(input: ListCreatedArtifactsRequest): ListCreatedArtifactsResponse

    /**
     * Lists discovered resources associated with the given `MigrationTask`.
     */
    public suspend fun listDiscoveredResources(input: ListDiscoveredResourcesRequest): ListDiscoveredResourcesResponse

    /**
     * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This API has the following traits:
     * + Can show a summary list of the most recent migration tasks.
     * + Can show a summary list of migration tasks associated with a given discovered resource.
     * + Lists migration tasks in a paginated interface.
     */
    public suspend fun listMigrationTasks(input: ListMigrationTasksRequest = ListMigrationTasksRequest {}): ListMigrationTasksResponse

    /**
     * Lists progress update streams associated with the user account making this call.
     */
    public suspend fun listProgressUpdateStreams(input: ListProgressUpdateStreamsRequest = ListProgressUpdateStreamsRequest {}): ListProgressUpdateStreamsResponse

    /**
     * Sets the migration state of an application. For a given application identified by the value passed to `ApplicationId`, its status is set or updated by passing one of three values to `Status`: `NOT_STARTED | IN_PROGRESS | COMPLETED`.
     */
    public suspend fun notifyApplicationState(input: NotifyApplicationStateRequest): NotifyApplicationStateResponse

    /**
     * Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:
     * + Migration tools will call the `NotifyMigrationTaskState` API to share the latest progress and status.
     * + `MigrationTaskName` is used for addressing updates to the correct target.
     * + `ProgressUpdateStream` is used for access control and to provide a namespace for each migration tool.
     */
    public suspend fun notifyMigrationTaskState(input: NotifyMigrationTaskStateRequest): NotifyMigrationTaskStateResponse

    /**
     * Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after `PutResourceAttributes` returns.
     *
     * + Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to *add* an IP address, it will then be required to call it with *both* the IP and MAC addresses to prevent overriding the MAC address.
     * + Note the instructions regarding the special use case of the `ResourceAttributeList`[](https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList) parameter when specifying any "VM" related value.
     * Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call `ListDiscoveredResources`.
     */
    public suspend fun putResourceAttributes(input: PutResourceAttributesRequest): PutResourceAttributesResponse
}

/**
 * Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:
 * + Migration tools can call the `AssociateCreatedArtifact` operation to indicate which AWS artifact is associated with a migration task.
 * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
 * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.
 */
public suspend inline fun MigrationHubClient.associateCreatedArtifact(crossinline block: AssociateCreatedArtifactRequest.Builder.() -> Unit): AssociateCreatedArtifactResponse = associateCreatedArtifact(AssociateCreatedArtifactRequest.Builder().apply(block).build())

/**
 * Associates a discovered resource ID from Application Discovery Service with a migration task.
 */
public suspend inline fun MigrationHubClient.associateDiscoveredResource(crossinline block: AssociateDiscoveredResourceRequest.Builder.() -> Unit): AssociateDiscoveredResourceResponse = associateDiscoveredResource(AssociateDiscoveredResourceRequest.Builder().apply(block).build())

/**
 * Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.
 */
public suspend inline fun MigrationHubClient.createProgressUpdateStream(crossinline block: CreateProgressUpdateStreamRequest.Builder.() -> Unit): CreateProgressUpdateStreamResponse = createProgressUpdateStream(CreateProgressUpdateStreamRequest.Builder().apply(block).build())

/**
 * Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:
 * + The only parameter needed for `DeleteProgressUpdateStream` is the stream name (same as a `CreateProgressUpdateStream` call).
 * + The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).
 * + If the stream takes time to be deleted, it might still show up on a `ListProgressUpdateStreams` call.
 * + `CreateProgressUpdateStream`, `ImportMigrationTask`, `NotifyMigrationTaskState`, and all Associate&#91;*&#93; APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.
 * + Once the stream and all of its resources are deleted, `CreateProgressUpdateStream` for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).
 */
public suspend inline fun MigrationHubClient.deleteProgressUpdateStream(crossinline block: DeleteProgressUpdateStreamRequest.Builder.() -> Unit): DeleteProgressUpdateStreamResponse = deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest.Builder().apply(block).build())

/**
 * Gets the migration status of an application.
 */
public suspend inline fun MigrationHubClient.describeApplicationState(crossinline block: DescribeApplicationStateRequest.Builder.() -> Unit): DescribeApplicationStateResponse = describeApplicationState(DescribeApplicationStateRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all attributes associated with a specific migration task.
 */
public suspend inline fun MigrationHubClient.describeMigrationTask(crossinline block: DescribeMigrationTaskRequest.Builder.() -> Unit): DescribeMigrationTaskResponse = describeMigrationTask(DescribeMigrationTaskRequest.Builder().apply(block).build())

/**
 * Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:
 * + A migration user can call the `DisassociateCreatedArtifacts` operation to disassociate a created AWS Artifact from a migration task.
 * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
 * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.
 */
public suspend inline fun MigrationHubClient.disassociateCreatedArtifact(crossinline block: DisassociateCreatedArtifactRequest.Builder.() -> Unit): DisassociateCreatedArtifactResponse = disassociateCreatedArtifact(DisassociateCreatedArtifactRequest.Builder().apply(block).build())

/**
 * Disassociate an Application Discovery Service discovered resource from a migration task.
 */
public suspend inline fun MigrationHubClient.disassociateDiscoveredResource(crossinline block: DisassociateDiscoveredResourceRequest.Builder.() -> Unit): DisassociateDiscoveredResourceResponse = disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest.Builder().apply(block).build())

/**
 * Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration tool.
 *
 * This API is a prerequisite to calling the `NotifyMigrationTaskState` API as the migration tool must first register the migration task with Migration Hub.
 */
public suspend inline fun MigrationHubClient.importMigrationTask(crossinline block: ImportMigrationTaskRequest.Builder.() -> Unit): ImportMigrationTaskResponse = importMigrationTask(ImportMigrationTaskRequest.Builder().apply(block).build())

/**
 * Lists all the migration statuses for your applications. If you use the optional `ApplicationIds` parameter, only the migration statuses for those applications will be returned.
 */
public suspend inline fun MigrationHubClient.listApplicationStates(crossinline block: ListApplicationStatesRequest.Builder.() -> Unit): ListApplicationStatesResponse = listApplicationStates(ListApplicationStatesRequest.Builder().apply(block).build())

/**
 * Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:
 * + Gets the list of the created artifacts while migration is taking place.
 * + Shows the artifacts created by the migration tool that was associated by the `AssociateCreatedArtifact` API.
 * + Lists created artifacts in a paginated interface.
 */
public suspend inline fun MigrationHubClient.listCreatedArtifacts(crossinline block: ListCreatedArtifactsRequest.Builder.() -> Unit): ListCreatedArtifactsResponse = listCreatedArtifacts(ListCreatedArtifactsRequest.Builder().apply(block).build())

/**
 * Lists discovered resources associated with the given `MigrationTask`.
 */
public suspend inline fun MigrationHubClient.listDiscoveredResources(crossinline block: ListDiscoveredResourcesRequest.Builder.() -> Unit): ListDiscoveredResourcesResponse = listDiscoveredResources(ListDiscoveredResourcesRequest.Builder().apply(block).build())

/**
 * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This API has the following traits:
 * + Can show a summary list of the most recent migration tasks.
 * + Can show a summary list of migration tasks associated with a given discovered resource.
 * + Lists migration tasks in a paginated interface.
 */
public suspend inline fun MigrationHubClient.listMigrationTasks(crossinline block: ListMigrationTasksRequest.Builder.() -> Unit): ListMigrationTasksResponse = listMigrationTasks(ListMigrationTasksRequest.Builder().apply(block).build())

/**
 * Lists progress update streams associated with the user account making this call.
 */
public suspend inline fun MigrationHubClient.listProgressUpdateStreams(crossinline block: ListProgressUpdateStreamsRequest.Builder.() -> Unit): ListProgressUpdateStreamsResponse = listProgressUpdateStreams(ListProgressUpdateStreamsRequest.Builder().apply(block).build())

/**
 * Sets the migration state of an application. For a given application identified by the value passed to `ApplicationId`, its status is set or updated by passing one of three values to `Status`: `NOT_STARTED | IN_PROGRESS | COMPLETED`.
 */
public suspend inline fun MigrationHubClient.notifyApplicationState(crossinline block: NotifyApplicationStateRequest.Builder.() -> Unit): NotifyApplicationStateResponse = notifyApplicationState(NotifyApplicationStateRequest.Builder().apply(block).build())

/**
 * Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:
 * + Migration tools will call the `NotifyMigrationTaskState` API to share the latest progress and status.
 * + `MigrationTaskName` is used for addressing updates to the correct target.
 * + `ProgressUpdateStream` is used for access control and to provide a namespace for each migration tool.
 */
public suspend inline fun MigrationHubClient.notifyMigrationTaskState(crossinline block: NotifyMigrationTaskStateRequest.Builder.() -> Unit): NotifyMigrationTaskStateResponse = notifyMigrationTaskState(NotifyMigrationTaskStateRequest.Builder().apply(block).build())

/**
 * Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after `PutResourceAttributes` returns.
 *
 * + Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to *add* an IP address, it will then be required to call it with *both* the IP and MAC addresses to prevent overriding the MAC address.
 * + Note the instructions regarding the special use case of the `ResourceAttributeList`[](https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList) parameter when specifying any "VM" related value.
 * Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call `ListDiscoveredResources`.
 */
public suspend inline fun MigrationHubClient.putResourceAttributes(crossinline block: PutResourceAttributesRequest.Builder.() -> Unit): PutResourceAttributesResponse = putResourceAttributes(PutResourceAttributesRequest.Builder().apply(block).build())
