// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model



public class CreateServiceRequest private constructor(builder: Builder) {
    /**
     * The ID of the application which the service is created.
     */
    public val applicationIdentifier: kotlin.String? = requireNotNull(builder.applicationIdentifier) { "A non-null value must be provided for applicationIdentifier" }
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the service.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
     */
    public val endpointType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceEndpointType? = builder.endpointType
    /**
     * The ID of the environment in which the service is created.
     */
    public val environmentIdentifier: kotlin.String? = requireNotNull(builder.environmentIdentifier) { "A non-null value must be provided for environmentIdentifier" }
    /**
     * The configuration for the Lambda endpoint type.
     */
    public val lambdaEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointInput? = builder.lambdaEndpoint
    /**
     * The name of the service.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The configuration for the URL endpoint type.
     */
    public val urlEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointInput? = builder.urlEndpoint
    /**
     * The ID of the VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceRequest(")
        append("applicationIdentifier=$applicationIdentifier,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("endpointType=$endpointType,")
        append("environmentIdentifier=$environmentIdentifier,")
        append("lambdaEndpoint=$lambdaEndpoint,")
        append("name=$name,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("urlEndpoint=$urlEndpoint,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationIdentifier?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (environmentIdentifier?.hashCode() ?: 0)
        result = 31 * result + (lambdaEndpoint?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (urlEndpoint?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceRequest

        if (applicationIdentifier != other.applicationIdentifier) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (endpointType != other.endpointType) return false
        if (environmentIdentifier != other.environmentIdentifier) return false
        if (lambdaEndpoint != other.lambdaEndpoint) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (urlEndpoint != other.urlEndpoint) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the application which the service is created.
         */
        public var applicationIdentifier: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description of the service.
         */
        public var description: kotlin.String? = null
        /**
         * The type of endpoint to use for the service. The type can be a URL in a VPC or an Lambda function.
         */
        public var endpointType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceEndpointType? = null
        /**
         * The ID of the environment in which the service is created.
         */
        public var environmentIdentifier: kotlin.String? = null
        /**
         * The configuration for the Lambda endpoint type.
         */
        public var lambdaEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointInput? = null
        /**
         * The name of the service.
         */
        public var name: kotlin.String? = null
        /**
         * The tags to assign to the service. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..
         */
        public var tags: Map<String, String>? = null
        /**
         * The configuration for the URL endpoint type.
         */
        public var urlEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointInput? = null
        /**
         * The ID of the VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceRequest) : this() {
            this.applicationIdentifier = x.applicationIdentifier
            this.clientToken = x.clientToken
            this.description = x.description
            this.endpointType = x.endpointType
            this.environmentIdentifier = x.environmentIdentifier
            this.lambdaEndpoint = x.lambdaEndpoint
            this.name = x.name
            this.tags = x.tags
            this.urlEndpoint = x.urlEndpoint
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceRequest = CreateServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointInput] inside the given [block]
         */
        public fun lambdaEndpoint(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointInput.Builder.() -> kotlin.Unit) {
            this.lambdaEndpoint = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointInput] inside the given [block]
         */
        public fun urlEndpoint(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointInput.Builder.() -> kotlin.Unit) {
            this.urlEndpoint = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointInput.invoke(block)
        }
    }
}
