// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary information for environments as a response to `ListEnvironments`.
 */
public class EnvironmentSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A timestamp that indicates when the environment is created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * A description of the environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier of the environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * Any error associated with the environment resource.
     */
    public val error: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse? = builder.error
    /**
     * A timestamp that indicates when the environment was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The name of the environment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The network fabric type of the environment.
     */
    public val networkFabricType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.NetworkFabricType? = builder.networkFabricType
    /**
     * The Amazon Web Services account ID of the environment owner.
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId
    /**
     * The current state of the environment.
     */
    public val state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentState? = builder.state
    /**
     * The tags assigned to the environment.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ID of the transit gateway set up by the environment.
     */
    public val transitGatewayId: kotlin.String? = builder.transitGatewayId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentSummary(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("environmentId=$environmentId,")
        append("error=$error,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("networkFabricType=$networkFabricType,")
        append("ownerAccountId=$ownerAccountId,")
        append("state=$state,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("transitGatewayId=$transitGatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkFabricType?.hashCode() ?: 0)
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentSummary

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (environmentId != other.environmentId) return false
        if (error != other.error) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (networkFabricType != other.networkFabricType) return false
        if (ownerAccountId != other.ownerAccountId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayId != other.transitGatewayId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the environment.
         */
        public var arn: kotlin.String? = null
        /**
         * A timestamp that indicates when the environment is created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the environment.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier of the environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * Any error associated with the environment resource.
         */
        public var error: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse? = null
        /**
         * A timestamp that indicates when the environment was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the environment.
         */
        public var name: kotlin.String? = null
        /**
         * The network fabric type of the environment.
         */
        public var networkFabricType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.NetworkFabricType? = null
        /**
         * The Amazon Web Services account ID of the environment owner.
         */
        public var ownerAccountId: kotlin.String? = null
        /**
         * The current state of the environment.
         */
        public var state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentState? = null
        /**
         * The tags assigned to the environment.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ID of the transit gateway set up by the environment.
         */
        public var transitGatewayId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentSummary) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.environmentId = x.environmentId
            this.error = x.error
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.networkFabricType = x.networkFabricType
            this.ownerAccountId = x.ownerAccountId
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayId = x.transitGatewayId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentSummary = EnvironmentSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse] inside the given [block]
         */
        public fun error(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse.Builder.() -> kotlin.Unit) {
            this.error = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse.invoke(block)
        }
    }
}
