// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.transform

import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ProxyType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApplicationOperationSerializer: HttpSerialize<CreateApplicationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "environments",
                "${input.environmentIdentifier}".encodeLabel(),
                "applications",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateApplicationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateApplicationOperationBody(context: ExecutionContext, input: CreateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIGATEWAYPROXY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApiGatewayProxy"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PROXYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProxyType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIGATEWAYPROXY_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROXYTYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiGatewayProxy?.let { field(APIGATEWAYPROXY_DESCRIPTOR, it, ::serializeApiGatewayProxyInputDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.proxyType?.let { field(PROXYTYPE_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.vpcId?.let { field(VPCID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
