// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.transform

import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DefaultRouteInput
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteType
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRouteOperationSerializer: HttpSerialize<CreateRouteRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateRouteRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "environments",
                "${input.environmentIdentifier}".encodeLabel(),
                "applications",
                "${input.applicationIdentifier}".encodeLabel(),
                "routes",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateRouteOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateRouteOperationBody(context: ExecutionContext, input: CreateRouteRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val DEFAULTROUTE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultRoute"))
    val ROUTETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RouteType"))
    val SERVICEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceIdentifier"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val URIPATHROUTE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UriPathRoute"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DEFAULTROUTE_DESCRIPTOR)
        field(ROUTETYPE_DESCRIPTOR)
        field(SERVICEIDENTIFIER_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(URIPATHROUTE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.defaultRoute?.let { field(DEFAULTROUTE_DESCRIPTOR, it, ::serializeDefaultRouteInputDocument) }
        input.routeType?.let { field(ROUTETYPE_DESCRIPTOR, it.value) }
        input.serviceIdentifier?.let { field(SERVICEIDENTIFIER_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.uriPathRoute?.let { field(URIPATHROUTE_DESCRIPTOR, it, ::serializeUriPathRouteInputDocument) }
    }
    return serializer.toByteArray()
}
