// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.migrationhubrefactorspaces.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.*
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteRouteResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteServiceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteServiceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetApplicationResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetRouteResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetServiceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetServiceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListApplicationsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListApplicationsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListRoutesRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListRoutesResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListServicesRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListServicesResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.TagResourceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.TagResourceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UntagResourceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UntagResourceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UpdateRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UpdateRouteResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Web Services Migration Hub Refactor Spaces
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for Amazon Web Services Migration Hub Refactor Spaces (Refactor Spaces). The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](https://aws.amazon.com/tools/#SDKs).
 *
 * To share Refactor Spaces environments with other Amazon Web Services accounts or with Organizations and their OUs, use Resource Access Manager's `CreateResourceShare` API. See [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) in the *Amazon Web Services RAM API Reference*.
 */
public interface MigrationHubRefactorSpacesClient : SdkClient {

    override val serviceName: String
        get() = "Migration Hub Refactor Spaces"
    /**
     * MigrationHubRefactorSpacesClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MigrationHubRefactorSpacesClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMigrationHubRefactorSpacesClient(config)
        }

        public operator fun invoke(config: Config): MigrationHubRefactorSpacesClient = DefaultMigrationHubRefactorSpacesClient(config)

        /**
         * Construct a [MigrationHubRefactorSpacesClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MigrationHubRefactorSpacesClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMigrationHubRefactorSpacesClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces application. The account that owns the environment also owns the applications created inside the environment, regardless of the account that creates the application. Refactor Spaces provisions an Amazon API Gateway, API Gateway VPC link, and Network Load Balancer for the application proxy inside your account.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces environment. The caller owns the environment resource, and all Refactor Spaces applications, services, and routes created within the environment. They are referred to as the *environment owner*. The environment owner has cross-account visibility and control of Refactor Spaces resources that are added to the environment by other accounts that the environment is shared with. When creating an environment, Refactor Spaces provisions a transit gateway in your account.
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account owner of the service resource is always the environment owner, regardless of which account creates the route. Routes target a service in the application. If an application does not have any routes, then the first route must be created as a `DEFAULT``RouteType`.
     *
     * When created, the default route defaults to an active state so state is not a required input. However, like all other state values the state of the default route can be updated after creation, but only when all other routes are also inactive. Conversely, no route can be active without the default route also being active.
     *
     * When you create a route, Refactor Spaces configures the Amazon API Gateway to send traffic to the target service as follows:
     * + If the service has a URL endpoint, and the endpoint resolves to a private IP address, Refactor Spaces routes traffic using the API Gateway VPC link.
     * + If the service has a URL endpoint, and the endpoint resolves to a public IP address, Refactor Spaces routes traffic over the public internet.
     * + If the service has an Lambda function endpoint, then Refactor Spaces configures the Lambda function's resource policy to allow the application's API Gateway to invoke the function.
     *
     * A one-time health check is performed on the service when either the route is updated from inactive to active, or when it is created with an active state. If the health check fails, the route transitions the route state to `FAILED`, an error code of `SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE` is provided, and no traffic is sent to the service.
     *
     * For Lambda functions, the Lambda function state is checked. If the function is not active, the function configuration is updated so that Lambda resources are provisioned. If the Lambda state is `Failed`, then the route creation fails. For more information, see the [GetFunctionConfiguration's State response parameter](https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State) in the *Lambda Developer Guide*.
     *
     * For Lambda endpoints, a check is performed to determine that a Lambda function with the specified ARN exists. If it does not exist, the health check fails. For public URLs, a connection is opened to the public endpoint. If the URL is not reachable, the health check fails.
     *
     * For private URLS, a target group is created on the Elastic Load Balancing and the target group health check is run. The `HealthCheckProtocol`, `HealthCheckPort`, and `HealthCheckPath` are the same protocol, port, and path specified in the URL or health URL, if used. All other settings use the default values, as described in [Health checks for your target groups](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html). The health check is considered successful if at least one target within the target group transitions to a healthy state.
     *
     * Services can have HTTP or HTTPS URL endpoints. For HTTPS URLs, publicly-signed certificates are supported. Private Certificate Authorities (CAs) are permitted only if the CA's domain is also publicly resolvable.
     */
    public suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces service. The account owner of the service is always the environment owner, regardless of which account in the environment creates the service. Services have either a URL endpoint in a virtual private cloud (VPC), or a Lambda function endpoint.
     *
     * If an Amazon Web Services resource is launched in a service VPC, and you want it to be accessible to all of an environment’s services with VPCs and routes, apply the `RefactorSpacesSecurityGroup` to the resource. Alternatively, to add more cross-account constraints, apply your own security group.
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces application. Before you can delete an application, you must first delete any services or routes within the application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces environment. Before you can delete an environment, you must first delete any applications and services within the environment.
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes the resource policy set for the environment.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces route.
     */
    public suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces service.
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces environment.
     */
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * Gets the resource-based permission policy that is set for the given environment.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces route.
     */
    public suspend fun getRoute(input: GetRouteRequest): GetRouteResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces service.
     */
    public suspend fun getService(input: GetServiceRequest): GetServiceResponse

    /**
     * Lists all the Amazon Web Services Migration Hub Refactor Spaces applications within an environment.
     */
    public suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse

    /**
     * Lists all Amazon Web Services Migration Hub Refactor Spaces service virtual private clouds (VPCs) that are part of the environment.
     */
    public suspend fun listEnvironmentVpcs(input: ListEnvironmentVpcsRequest): ListEnvironmentVpcsResponse

    /**
     * Lists Amazon Web Services Migration Hub Refactor Spaces environments owned by a caller account or shared with the caller account.
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest {}): ListEnvironmentsResponse

    /**
     * Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within an application.
     */
    public suspend fun listRoutes(input: ListRoutesRequest): ListRoutesResponse

    /**
     * Lists all the Amazon Web Services Migration Hub Refactor Spaces services within an application.
     */
    public suspend fun listServices(input: ListServicesRequest): ListServicesResponse

    /**
     * Lists the tags of a resource. The caller account must be the same as the resource’s `OwnerAccountId`. Listing tags in other accounts is not supported.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Attaches a resource-based permission policy to the Amazon Web Services Migration Hub Refactor Spaces environment. The policy must contain the same actions and condition statements as the `arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment` permission in Resource Access Manager. The policy must not contain new lines or blank lines.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Removes the tags of a given resource. Tags are metadata which can be used to manage a resource. To tag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Tagging resources in other accounts is not supported.
     *
     * Amazon Web Services Migration Hub Refactor Spaces does not propagate tags to orchestrated resources, such as an environment’s transit gateway.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource. To untag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Untagging resources across accounts is not supported.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Amazon Web Services Migration Hub Refactor Spaces route.
     */
    public suspend fun updateRoute(input: UpdateRouteRequest): UpdateRouteResponse
}

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces application. The account that owns the environment also owns the applications created inside the environment, regardless of the account that creates the application. Refactor Spaces provisions an Amazon API Gateway, API Gateway VPC link, and Network Load Balancer for the application proxy inside your account.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces environment. The caller owns the environment resource, and all Refactor Spaces applications, services, and routes created within the environment. They are referred to as the *environment owner*. The environment owner has cross-account visibility and control of Refactor Spaces resources that are added to the environment by other accounts that the environment is shared with. When creating an environment, Refactor Spaces provisions a transit gateway in your account.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account owner of the service resource is always the environment owner, regardless of which account creates the route. Routes target a service in the application. If an application does not have any routes, then the first route must be created as a `DEFAULT``RouteType`.
 *
 * When created, the default route defaults to an active state so state is not a required input. However, like all other state values the state of the default route can be updated after creation, but only when all other routes are also inactive. Conversely, no route can be active without the default route also being active.
 *
 * When you create a route, Refactor Spaces configures the Amazon API Gateway to send traffic to the target service as follows:
 * + If the service has a URL endpoint, and the endpoint resolves to a private IP address, Refactor Spaces routes traffic using the API Gateway VPC link.
 * + If the service has a URL endpoint, and the endpoint resolves to a public IP address, Refactor Spaces routes traffic over the public internet.
 * + If the service has an Lambda function endpoint, then Refactor Spaces configures the Lambda function's resource policy to allow the application's API Gateway to invoke the function.
 *
 * A one-time health check is performed on the service when either the route is updated from inactive to active, or when it is created with an active state. If the health check fails, the route transitions the route state to `FAILED`, an error code of `SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE` is provided, and no traffic is sent to the service.
 *
 * For Lambda functions, the Lambda function state is checked. If the function is not active, the function configuration is updated so that Lambda resources are provisioned. If the Lambda state is `Failed`, then the route creation fails. For more information, see the [GetFunctionConfiguration's State response parameter](https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State) in the *Lambda Developer Guide*.
 *
 * For Lambda endpoints, a check is performed to determine that a Lambda function with the specified ARN exists. If it does not exist, the health check fails. For public URLs, a connection is opened to the public endpoint. If the URL is not reachable, the health check fails.
 *
 * For private URLS, a target group is created on the Elastic Load Balancing and the target group health check is run. The `HealthCheckProtocol`, `HealthCheckPort`, and `HealthCheckPath` are the same protocol, port, and path specified in the URL or health URL, if used. All other settings use the default values, as described in [Health checks for your target groups](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html). The health check is considered successful if at least one target within the target group transitions to a healthy state.
 *
 * Services can have HTTP or HTTPS URL endpoints. For HTTPS URLs, publicly-signed certificates are supported. Private Certificate Authorities (CAs) are permitted only if the CA's domain is also publicly resolvable.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createRoute(crossinline block: CreateRouteRequest.Builder.() -> Unit): CreateRouteResponse = createRoute(CreateRouteRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces service. The account owner of the service is always the environment owner, regardless of which account in the environment creates the service. Services have either a URL endpoint in a virtual private cloud (VPC), or a Lambda function endpoint.
 *
 * If an Amazon Web Services resource is launched in a service VPC, and you want it to be accessible to all of an environment’s services with VPCs and routes, apply the `RefactorSpacesSecurityGroup` to the resource. Alternatively, to add more cross-account constraints, apply your own security group.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces application. Before you can delete an application, you must first delete any services or routes within the application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces environment. Before you can delete an environment, you must first delete any applications and services within the environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes the resource policy set for the environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces route.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteRoute(crossinline block: DeleteRouteRequest.Builder.() -> Unit): DeleteRouteResponse = deleteRoute(DeleteRouteRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces service.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * Gets the resource-based permission policy that is set for the given environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces route.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getRoute(crossinline block: GetRouteRequest.Builder.() -> Unit): GetRouteResponse = getRoute(GetRouteRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces service.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getService(crossinline block: GetServiceRequest.Builder.() -> Unit): GetServiceResponse = getService(GetServiceRequest.Builder().apply(block).build())

/**
 * Lists all the Amazon Web Services Migration Hub Refactor Spaces applications within an environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists all Amazon Web Services Migration Hub Refactor Spaces service virtual private clouds (VPCs) that are part of the environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listEnvironmentVpcs(crossinline block: ListEnvironmentVpcsRequest.Builder.() -> Unit): ListEnvironmentVpcsResponse = listEnvironmentVpcs(ListEnvironmentVpcsRequest.Builder().apply(block).build())

/**
 * Lists Amazon Web Services Migration Hub Refactor Spaces environments owned by a caller account or shared with the caller account.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within an application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listRoutes(crossinline block: ListRoutesRequest.Builder.() -> Unit): ListRoutesResponse = listRoutes(ListRoutesRequest.Builder().apply(block).build())

/**
 * Lists all the Amazon Web Services Migration Hub Refactor Spaces services within an application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * Lists the tags of a resource. The caller account must be the same as the resource’s `OwnerAccountId`. Listing tags in other accounts is not supported.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Attaches a resource-based permission policy to the Amazon Web Services Migration Hub Refactor Spaces environment. The policy must contain the same actions and condition statements as the `arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment` permission in Resource Access Manager. The policy must not contain new lines or blank lines.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Removes the tags of a given resource. Tags are metadata which can be used to manage a resource. To tag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Tagging resources in other accounts is not supported.
 *
 * Amazon Web Services Migration Hub Refactor Spaces does not propagate tags to orchestrated resources, such as an environment’s transit gateway.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource. To untag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Untagging resources across accounts is not supported.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Web Services Migration Hub Refactor Spaces route.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.updateRoute(crossinline block: UpdateRouteRequest.Builder.() -> Unit): UpdateRouteResponse = updateRoute(UpdateRouteRequest.Builder().apply(block).build())
