// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesException
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteState
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UpdateRouteResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateRouteOperationDeserializer: HttpDeserialize<UpdateRouteResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateRouteResponse {
        if (!response.status.isSuccess()) {
            throwUpdateRouteError(context, response)
        }
        val builder = UpdateRouteResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRouteOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateRouteError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubRefactorSpacesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MigrationHubRefactorSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRouteOperationBody(builder: UpdateRouteResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationId"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTime"))
    val ROUTEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RouteId"))
    val SERVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceId"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(ROUTEID_DESCRIPTOR)
        field(SERVICEID_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROUTEID_DESCRIPTOR.index -> builder.routeId = deserializeString()
                SERVICEID_DESCRIPTOR.index -> builder.serviceId = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { RouteState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
