// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mobile.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mobile.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Mobile Service provides mobile app and website developers with capabilities required to configure AWS resources and bootstrap their developer desktop projects with the necessary SDKs, constants, tools and samples to make use of those resources.
 */
interface MobileClient : SdkClient {

    override val serviceName: String
        get() = "Mobile"
    /**
     * MobileClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MobileClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMobileClient(config)
        }

        operator fun invoke(config: Config): MobileClient = DefaultMobileClient(config)

        /**
         * Construct a [MobileClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MobileClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMobileClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an AWS Mobile Hub project.
     */
    suspend fun createProject(input: CreateProjectRequest = CreateProjectRequest {}): CreateProjectResponse

    /**
     * Creates an AWS Mobile Hub project.
     */
    suspend fun createProject(block: CreateProjectRequest.Builder.() -> Unit) = createProject(CreateProjectRequest.Builder().apply(block).build())

    /**
     * Delets a project in AWS Mobile Hub.
     */
    suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Delets a project in AWS Mobile Hub.
     */
    suspend fun deleteProject(block: DeleteProjectRequest.Builder.() -> Unit) = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

    /**
     * Get the bundle details for the requested bundle id.
     */
    suspend fun describeBundle(input: DescribeBundleRequest): DescribeBundleResponse

    /**
     * Get the bundle details for the requested bundle id.
     */
    suspend fun describeBundle(block: DescribeBundleRequest.Builder.() -> Unit) = describeBundle(DescribeBundleRequest.Builder().apply(block).build())

    /**
     * Gets details about a project in AWS Mobile Hub.
     */
    suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Gets details about a project in AWS Mobile Hub.
     */
    suspend fun describeProject(block: DescribeProjectRequest.Builder.() -> Unit) = describeProject(DescribeProjectRequest.Builder().apply(block).build())

    /**
     * Generates customized software development kit (SDK) and or tool packages used to integrate mobile web or mobile app clients with backend AWS resources.
     */
    suspend fun exportBundle(input: ExportBundleRequest): ExportBundleResponse

    /**
     * Generates customized software development kit (SDK) and or tool packages used to integrate mobile web or mobile app clients with backend AWS resources.
     */
    suspend fun exportBundle(block: ExportBundleRequest.Builder.() -> Unit) = exportBundle(ExportBundleRequest.Builder().apply(block).build())

    /**
     * Exports project configuration to a snapshot which can be downloaded and shared. Note that mobile app push credentials are encrypted in exported projects, so they can only be shared successfully within the same AWS account.
     */
    suspend fun exportProject(input: ExportProjectRequest): ExportProjectResponse

    /**
     * Exports project configuration to a snapshot which can be downloaded and shared. Note that mobile app push credentials are encrypted in exported projects, so they can only be shared successfully within the same AWS account.
     */
    suspend fun exportProject(block: ExportProjectRequest.Builder.() -> Unit) = exportProject(ExportProjectRequest.Builder().apply(block).build())

    /**
     * List all available bundles.
     */
    suspend fun listBundles(input: ListBundlesRequest = ListBundlesRequest {}): ListBundlesResponse

    /**
     * List all available bundles.
     */
    suspend fun listBundles(block: ListBundlesRequest.Builder.() -> Unit) = listBundles(ListBundlesRequest.Builder().apply(block).build())

    /**
     * Lists projects in AWS Mobile Hub.
     */
    suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest {}): ListProjectsResponse

    /**
     * Lists projects in AWS Mobile Hub.
     */
    suspend fun listProjects(block: ListProjectsRequest.Builder.() -> Unit) = listProjects(ListProjectsRequest.Builder().apply(block).build())

    /**
     * Update an existing project.
     */
    suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Update an existing project.
     */
    suspend fun updateProject(block: UpdateProjectRequest.Builder.() -> Unit) = updateProject(UpdateProjectRequest.Builder().apply(block).build())
}
