// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model



/**
 * Request structure used to request a project be created.
 */
class CreateProjectRequest private constructor(builder: Builder) {
    /**
     * ZIP or YAML file which contains configuration settings to be used when creating the project. This may be the contents of the file downloaded from the URL provided in an export project operation.
     */
    val contents: kotlin.ByteArray? = builder.contents
    /**
     * Name of the project.
     */
    val name: kotlin.String? = builder.name
    /**
     * Default region where project resources should be created.
     */
    val region: kotlin.String? = builder.region
    /**
     * Unique identifier for an exported snapshot of project configuration. This snapshot identifier is included in the share URL when a project is exported.
     */
    val snapshotId: kotlin.String? = builder.snapshotId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mobile.model.CreateProjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProjectRequest(")
        append("contents=$contents,")
        append("name=$name,")
        append("region=$region,")
        append("snapshotId=$snapshotId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contents?.contentHashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProjectRequest

        if (contents != null) {
            if (other.contents == null) return false
            if (!contents.contentEquals(other.contents)) return false
        } else if (other.contents != null) return false
        if (name != other.name) return false
        if (region != other.region) return false
        if (snapshotId != other.snapshotId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mobile.model.CreateProjectRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * ZIP or YAML file which contains configuration settings to be used when creating the project. This may be the contents of the file downloaded from the URL provided in an export project operation.
         */
        var contents: kotlin.ByteArray? = null
        /**
         * Name of the project.
         */
        var name: kotlin.String? = null
        /**
         * Default region where project resources should be created.
         */
        var region: kotlin.String? = null
        /**
         * Unique identifier for an exported snapshot of project configuration. This snapshot identifier is included in the share URL when a project is exported.
         */
        var snapshotId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mobile.model.CreateProjectRequest) : this() {
            this.contents = x.contents
            this.name = x.name
            this.region = x.region
            this.snapshotId = x.snapshotId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mobile.model.CreateProjectRequest = CreateProjectRequest(this)
    }
}
