// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model



/**
 * Result structure used for requests to export project configuration details.
 */
class ExportProjectResponse private constructor(builder: Builder) {
    /**
     * URL which can be used to download the exported project configuation file(s).
     */
    val downloadUrl: kotlin.String? = builder.downloadUrl
    /**
     * URL which can be shared to allow other AWS users to create their own project in AWS Mobile Hub with the same configuration as the specified project. This URL pertains to a snapshot in time of the project configuration that is created when this API is called. If you want to share additional changes to your project configuration, then you will need to create and share a new snapshot by calling this method again.
     */
    val shareUrl: kotlin.String? = builder.shareUrl
    /**
     * Unique identifier for the exported snapshot of the project configuration. This snapshot identifier is included in the share URL.
     */
    val snapshotId: kotlin.String? = builder.snapshotId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mobile.model.ExportProjectResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportProjectResponse(")
        append("downloadUrl=$downloadUrl,")
        append("shareUrl=$shareUrl,")
        append("snapshotId=$snapshotId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = downloadUrl?.hashCode() ?: 0
        result = 31 * result + (shareUrl?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportProjectResponse

        if (downloadUrl != other.downloadUrl) return false
        if (shareUrl != other.shareUrl) return false
        if (snapshotId != other.snapshotId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mobile.model.ExportProjectResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * URL which can be used to download the exported project configuation file(s).
         */
        var downloadUrl: kotlin.String? = null
        /**
         * URL which can be shared to allow other AWS users to create their own project in AWS Mobile Hub with the same configuration as the specified project. This URL pertains to a snapshot in time of the project configuration that is created when this API is called. If you want to share additional changes to your project configuration, then you will need to create and share a new snapshot by calling this method again.
         */
        var shareUrl: kotlin.String? = null
        /**
         * Unique identifier for the exported snapshot of the project configuration. This snapshot identifier is included in the share URL.
         */
        var snapshotId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mobile.model.ExportProjectResponse) : this() {
            this.downloadUrl = x.downloadUrl
            this.shareUrl = x.shareUrl
            this.snapshotId = x.snapshotId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mobile.model.ExportProjectResponse = ExportProjectResponse(this)
    }
}
