// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mobile.model



/**
 * Information about an instance of an AWS resource associated with a project.
 */
class Resource private constructor(builder: Builder) {
    /**
     * AWS resource name which uniquely identifies the resource in AWS systems.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * Key-value attribute pairs.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * Identifies which feature in AWS Mobile Hub is associated with this AWS resource.
     */
    val feature: kotlin.String? = builder.feature
    /**
     * Name of the AWS resource (e.g., for an Amazon S3 bucket this is the name of the bucket).
     */
    val name: kotlin.String? = builder.name
    /**
     * Simplified name for type of AWS resource (e.g., bucket is an Amazon S3 bucket).
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mobile.model.Resource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Resource(")
        append("arn=$arn,")
        append("attributes=$attributes,")
        append("feature=$feature,")
        append("name=$name,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (feature?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Resource

        if (arn != other.arn) return false
        if (attributes != other.attributes) return false
        if (feature != other.feature) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mobile.model.Resource = Builder(this).apply(block).build()

    class Builder {
        /**
         * AWS resource name which uniquely identifies the resource in AWS systems.
         */
        var arn: kotlin.String? = null
        /**
         * Key-value attribute pairs.
         */
        var attributes: Map<String, String>? = null
        /**
         * Identifies which feature in AWS Mobile Hub is associated with this AWS resource.
         */
        var feature: kotlin.String? = null
        /**
         * Name of the AWS resource (e.g., for an Amazon S3 bucket this is the name of the bucket).
         */
        var name: kotlin.String? = null
        /**
         * Simplified name for type of AWS resource (e.g., bucket is an Amazon S3 bucket).
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mobile.model.Resource) : this() {
            this.arn = x.arn
            this.attributes = x.attributes
            this.feature = x.feature
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mobile.model.Resource = Resource(this)
    }
}
