// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mturk.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mturk.model.*
import aws.sdk.kotlin.services.mturk.model.AcceptQualificationRequestRequest
import aws.sdk.kotlin.services.mturk.model.AcceptQualificationRequestResponse
import aws.sdk.kotlin.services.mturk.model.ApproveAssignmentRequest
import aws.sdk.kotlin.services.mturk.model.ApproveAssignmentResponse
import aws.sdk.kotlin.services.mturk.model.AssociateQualificationWithWorkerRequest
import aws.sdk.kotlin.services.mturk.model.AssociateQualificationWithWorkerResponse
import aws.sdk.kotlin.services.mturk.model.CreateAdditionalAssignmentsForHitRequest
import aws.sdk.kotlin.services.mturk.model.CreateAdditionalAssignmentsForHitResponse
import aws.sdk.kotlin.services.mturk.model.CreateHitRequest
import aws.sdk.kotlin.services.mturk.model.CreateHitResponse
import aws.sdk.kotlin.services.mturk.model.CreateHitTypeRequest
import aws.sdk.kotlin.services.mturk.model.CreateHitTypeResponse
import aws.sdk.kotlin.services.mturk.model.CreateHitWithHitTypeRequest
import aws.sdk.kotlin.services.mturk.model.CreateHitWithHitTypeResponse
import aws.sdk.kotlin.services.mturk.model.CreateQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.CreateQualificationTypeResponse
import aws.sdk.kotlin.services.mturk.model.CreateWorkerBlockRequest
import aws.sdk.kotlin.services.mturk.model.CreateWorkerBlockResponse
import aws.sdk.kotlin.services.mturk.model.DeleteHitRequest
import aws.sdk.kotlin.services.mturk.model.DeleteHitResponse
import aws.sdk.kotlin.services.mturk.model.DeleteQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.DeleteQualificationTypeResponse
import aws.sdk.kotlin.services.mturk.model.DeleteWorkerBlockRequest
import aws.sdk.kotlin.services.mturk.model.DeleteWorkerBlockResponse
import aws.sdk.kotlin.services.mturk.model.DisassociateQualificationFromWorkerRequest
import aws.sdk.kotlin.services.mturk.model.DisassociateQualificationFromWorkerResponse
import aws.sdk.kotlin.services.mturk.model.GetAccountBalanceRequest
import aws.sdk.kotlin.services.mturk.model.GetAccountBalanceResponse
import aws.sdk.kotlin.services.mturk.model.GetAssignmentRequest
import aws.sdk.kotlin.services.mturk.model.GetAssignmentResponse
import aws.sdk.kotlin.services.mturk.model.GetFileUploadUrlRequest
import aws.sdk.kotlin.services.mturk.model.GetFileUploadUrlResponse
import aws.sdk.kotlin.services.mturk.model.GetHitRequest
import aws.sdk.kotlin.services.mturk.model.GetHitResponse
import aws.sdk.kotlin.services.mturk.model.GetQualificationScoreRequest
import aws.sdk.kotlin.services.mturk.model.GetQualificationScoreResponse
import aws.sdk.kotlin.services.mturk.model.GetQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.GetQualificationTypeResponse
import aws.sdk.kotlin.services.mturk.model.ListAssignmentsForHitRequest
import aws.sdk.kotlin.services.mturk.model.ListAssignmentsForHitResponse
import aws.sdk.kotlin.services.mturk.model.ListBonusPaymentsRequest
import aws.sdk.kotlin.services.mturk.model.ListBonusPaymentsResponse
import aws.sdk.kotlin.services.mturk.model.ListHiTsForQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.ListHiTsForQualificationTypeResponse
import aws.sdk.kotlin.services.mturk.model.ListHiTsRequest
import aws.sdk.kotlin.services.mturk.model.ListHiTsResponse
import aws.sdk.kotlin.services.mturk.model.ListQualificationRequestsRequest
import aws.sdk.kotlin.services.mturk.model.ListQualificationRequestsResponse
import aws.sdk.kotlin.services.mturk.model.ListQualificationTypesRequest
import aws.sdk.kotlin.services.mturk.model.ListQualificationTypesResponse
import aws.sdk.kotlin.services.mturk.model.ListReviewPolicyResultsForHitRequest
import aws.sdk.kotlin.services.mturk.model.ListReviewPolicyResultsForHitResponse
import aws.sdk.kotlin.services.mturk.model.ListReviewableHiTsRequest
import aws.sdk.kotlin.services.mturk.model.ListReviewableHiTsResponse
import aws.sdk.kotlin.services.mturk.model.ListWorkerBlocksRequest
import aws.sdk.kotlin.services.mturk.model.ListWorkerBlocksResponse
import aws.sdk.kotlin.services.mturk.model.ListWorkersWithQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.ListWorkersWithQualificationTypeResponse
import aws.sdk.kotlin.services.mturk.model.NotifyWorkersRequest
import aws.sdk.kotlin.services.mturk.model.NotifyWorkersResponse
import aws.sdk.kotlin.services.mturk.model.RejectAssignmentRequest
import aws.sdk.kotlin.services.mturk.model.RejectAssignmentResponse
import aws.sdk.kotlin.services.mturk.model.RejectQualificationRequestRequest
import aws.sdk.kotlin.services.mturk.model.RejectQualificationRequestResponse
import aws.sdk.kotlin.services.mturk.model.SendBonusRequest
import aws.sdk.kotlin.services.mturk.model.SendBonusResponse
import aws.sdk.kotlin.services.mturk.model.SendTestEventNotificationRequest
import aws.sdk.kotlin.services.mturk.model.SendTestEventNotificationResponse
import aws.sdk.kotlin.services.mturk.model.UpdateExpirationForHitRequest
import aws.sdk.kotlin.services.mturk.model.UpdateExpirationForHitResponse
import aws.sdk.kotlin.services.mturk.model.UpdateHitReviewStatusRequest
import aws.sdk.kotlin.services.mturk.model.UpdateHitReviewStatusResponse
import aws.sdk.kotlin.services.mturk.model.UpdateHitTypeOfHitRequest
import aws.sdk.kotlin.services.mturk.model.UpdateHitTypeOfHitResponse
import aws.sdk.kotlin.services.mturk.model.UpdateNotificationSettingsRequest
import aws.sdk.kotlin.services.mturk.model.UpdateNotificationSettingsResponse
import aws.sdk.kotlin.services.mturk.model.UpdateQualificationTypeRequest
import aws.sdk.kotlin.services.mturk.model.UpdateQualificationTypeResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Mechanical Turk API Reference
 */
public interface MTurkClient : SdkClient {

    override val serviceName: String
        get() = "MTurk"
    /**
     * MTurkClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MTurkClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMTurkClient(config)
        }

        public operator fun invoke(config: Config): MTurkClient = DefaultMTurkClient(config)

        /**
         * Construct a [MTurkClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MTurkClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMTurkClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * The `AcceptQualificationRequest` operation approves a Worker's request for a Qualification.
     *
     *  Only the owner of the Qualification type can grant a Qualification request for that type.
     *
     *  A successful request for the `AcceptQualificationRequest` operation returns with no errors and an empty body.
     */
    public suspend fun acceptQualificationRequest(input: AcceptQualificationRequestRequest): AcceptQualificationRequestResponse

    /**
     * The `ApproveAssignment` operation approves the results of a completed assignment.
     *
     *  Approving an assignment initiates two payments from the Requester's Amazon.com account
     * +  The Worker who submitted the results is paid the reward specified in the HIT.
     * +  Amazon Mechanical Turk fees are debited.
     *
     *  If the Requester's account does not have adequate funds for these payments, the call to ApproveAssignment returns an exception, and the approval is not processed. You can include an optional feedback message with the approval, which the Worker can see in the Status section of the web site.
     *
     *  You can also call this operation for assignments that were previous rejected and approve them by explicitly overriding the previous rejection. This only works on rejected assignments that were submitted within the previous 30 days and only if the assignment's related HIT has not been deleted.
     */
    public suspend fun approveAssignment(input: ApproveAssignmentRequest): ApproveAssignmentResponse

    /**
     * The `AssociateQualificationWithWorker` operation gives a Worker a Qualification. `AssociateQualificationWithWorker` does not require that the Worker submit a Qualification request. It gives the Qualification directly to the Worker.
     *
     *  You can only assign a Qualification of a Qualification type that you created (using the `CreateQualificationType` operation).
     *
     *  Note: `AssociateQualificationWithWorker` does not affect any pending Qualification requests for the Qualification by the Worker. If you assign a Qualification to a Worker, then later grant a Qualification request made by the Worker, the granting of the request may modify the Qualification score. To resolve a pending Qualification request without affecting the Qualification the Worker already has, reject the request with the `RejectQualificationRequest` operation.
     */
    public suspend fun associateQualificationWithWorker(input: AssociateQualificationWithWorkerRequest): AssociateQualificationWithWorkerResponse

    /**
     * The `CreateAdditionalAssignmentsForHIT` operation increases the maximum number of assignments of an existing HIT.
     *
     *  To extend the maximum number of assignments, specify the number of additional assignments.
     *
     * + HITs created with fewer than 10 assignments cannot be extended to have 10 or more assignments. Attempting to add assignments in a way that brings the total number of assignments for a HIT from fewer than 10 assignments to 10 or more assignments will result in an `AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease` exception.
     * + HITs that were created before July 22, 2015 cannot be extended. Attempting to extend HITs that were created before July 22, 2015 will result in an `AWS.MechanicalTurk.HITTooOldForExtension` exception.
     */
    public suspend fun createAdditionalAssignmentsForHit(input: CreateAdditionalAssignmentsForHitRequest): CreateAdditionalAssignmentsForHitResponse

    /**
     * The `CreateHIT` operation creates a new Human Intelligence Task (HIT). The new HIT is made available for Workers to find and accept on the Amazon Mechanical Turk website.
     *
     *  This operation allows you to specify a new HIT by passing in values for the properties of the HIT, such as its title, reward amount and number of assignments. When you pass these values to `CreateHIT`, a new HIT is created for you, with a new `HITTypeID`. The HITTypeID can be used to create additional HITs in the future without needing to specify common parameters such as the title, description and reward amount each time.
     *
     *  An alternative way to create HITs is to first generate a HITTypeID using the `CreateHITType` operation and then call the `CreateHITWithHITType` operation. This is the recommended best practice for Requesters who are creating large numbers of HITs.
     *
     * CreateHIT also supports several ways to provide question data: by providing a value for the `Question` parameter that fully specifies the contents of the HIT, or by providing a `HitLayoutId` and associated `HitLayoutParameters`.
     *
     *  If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see [Amazon Mechanical Turk Pricing](https://requester.mturk.com/pricing).
     */
    public suspend fun createHit(input: CreateHitRequest): CreateHitResponse

    /**
     * The `CreateHITType` operation creates a new HIT type. This operation allows you to define a standard set of HIT properties to use when creating HITs. If you register a HIT type with values that match an existing HIT type, the HIT type ID of the existing type will be returned.
     */
    public suspend fun createHitType(input: CreateHitTypeRequest): CreateHitTypeResponse

    /**
     * The `CreateHITWithHITType` operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the `CreateHITType` operation.
     *
     *  This is an alternative way to create HITs from the `CreateHIT` operation. This is the recommended best practice for Requesters who are creating large numbers of HITs.
     *
     * CreateHITWithHITType also supports several ways to provide question data: by providing a value for the `Question` parameter that fully specifies the contents of the HIT, or by providing a `HitLayoutId` and associated `HitLayoutParameters`.
     *
     *  If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see [Amazon Mechanical Turk Pricing](https://requester.mturk.com/pricing).
     */
    public suspend fun createHitWithHitType(input: CreateHitWithHitTypeRequest): CreateHitWithHitTypeResponse

    /**
     * The `CreateQualificationType` operation creates a new Qualification type, which is represented by a `QualificationType` data structure.
     */
    public suspend fun createQualificationType(input: CreateQualificationTypeRequest): CreateQualificationTypeResponse

    /**
     * The `CreateWorkerBlock` operation allows you to prevent a Worker from working on your HITs. For example, you can block a Worker who is producing poor quality work. You can block up to 100,000 Workers.
     */
    public suspend fun createWorkerBlock(input: CreateWorkerBlockRequest): CreateWorkerBlockResponse

    /**
     * The `DeleteHIT` operation is used to delete HIT that is no longer needed. Only the Requester who created the HIT can delete it.
     *
     *  You can only dispose of HITs that are in the `Reviewable` state, with all of their submitted assignments already either approved or rejected. If you call the DeleteHIT operation on a HIT that is not in the `Reviewable` state (for example, that has not expired, or still has active assignments), or on a HIT that is Reviewable but without all of its submitted assignments already approved or rejected, the service will return an error.
     *
     * +  HITs are automatically disposed of after 120 days.
     * +  After you dispose of a HIT, you can no longer approve the HIT's rejected assignments.
     * +  Disposed HITs are not returned in results for the ListHITs operation.
     * +  Disposing HITs can improve the performance of operations such as ListReviewableHITs and ListHITs.
     */
    public suspend fun deleteHit(input: DeleteHitRequest): DeleteHitResponse

    /**
     * The `DeleteQualificationType` deletes a Qualification type and deletes any HIT types that are associated with the Qualification type.
     *
     * This operation does not revoke Qualifications already assigned to Workers because the Qualifications might be needed for active HITs. If there are any pending requests for the Qualification type, Amazon Mechanical Turk rejects those requests. After you delete a Qualification type, you can no longer use it to create HITs or HIT types.
     *
     * DeleteQualificationType must wait for all the HITs that use the deleted Qualification type to be deleted before completing. It may take up to 48 hours before DeleteQualificationType completes and the unique name of the Qualification type is available for reuse with CreateQualificationType.
     */
    public suspend fun deleteQualificationType(input: DeleteQualificationTypeRequest): DeleteQualificationTypeResponse

    /**
     * The `DeleteWorkerBlock` operation allows you to reinstate a blocked Worker to work on your HITs. This operation reverses the effects of the CreateWorkerBlock operation. You need the Worker ID to use this operation. If the Worker ID is missing or invalid, this operation fails and returns the message “WorkerId is invalid.” If the specified Worker is not blocked, this operation returns successfully.
     */
    public suspend fun deleteWorkerBlock(input: DeleteWorkerBlockRequest): DeleteWorkerBlockResponse

    /**
     * The `DisassociateQualificationFromWorker` revokes a previously granted Qualification from a user.
     *
     *  You can provide a text message explaining why the Qualification was revoked. The user who had the Qualification can see this message.
     */
    public suspend fun disassociateQualificationFromWorker(input: DisassociateQualificationFromWorkerRequest): DisassociateQualificationFromWorkerResponse

    /**
     * The `GetAccountBalance` operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk account if you are a Prepaid Requester. Alternatively, this operation will retrieve the remaining available AWS Billing usage if you have enabled AWS Billing. Note: If you have enabled AWS Billing and still have a remaining Prepaid HITs balance, this balance can be viewed on the My Account page in the Requester console.
     */
    public suspend fun getAccountBalance(input: GetAccountBalanceRequest = GetAccountBalanceRequest {}): GetAccountBalanceResponse

    /**
     * The `GetAssignment` operation retrieves the details of the specified Assignment.
     */
    public suspend fun getAssignment(input: GetAssignmentRequest): GetAssignmentResponse

    /**
     * The `GetFileUploadURL` operation generates and returns a temporary URL. You use the temporary URL to retrieve a file uploaded by a Worker as an answer to a FileUploadAnswer question for a HIT. The temporary URL is generated the instant the GetFileUploadURL operation is called, and is valid for 60 seconds. You can get a temporary file upload URL any time until the HIT is disposed. After the HIT is disposed, any uploaded files are deleted, and cannot be retrieved. Pending Deprecation on December 12, 2017. The Answer Specification structure will no longer support the `FileUploadAnswer` element to be used for the QuestionForm data structure. Instead, we recommend that Requesters who want to create HITs asking Workers to upload files to use Amazon S3.
     */
    public suspend fun getFileUploadUrl(input: GetFileUploadUrlRequest): GetFileUploadUrlResponse

    /**
     * The `GetHIT` operation retrieves the details of the specified HIT.
     */
    public suspend fun getHit(input: GetHitRequest): GetHitResponse

    /**
     * The `GetQualificationScore` operation returns the value of a Worker's Qualification for a given Qualification type.
     *
     *  To get a Worker's Qualification, you must know the Worker's ID. The Worker's ID is included in the assignment data returned by the `ListAssignmentsForHIT` operation.
     *
     * Only the owner of a Qualification type can query the value of a Worker's Qualification of that type.
     */
    public suspend fun getQualificationScore(input: GetQualificationScoreRequest): GetQualificationScoreResponse

    /**
     * The `GetQualificationType`operation retrieves information about a Qualification type using its ID.
     */
    public suspend fun getQualificationType(input: GetQualificationTypeRequest): GetQualificationTypeResponse

    /**
     * The `ListAssignmentsForHIT` operation retrieves completed assignments for a HIT. You can use this operation to retrieve the results for a HIT.
     *
     *  You can get assignments for a HIT at any time, even if the HIT is not yet Reviewable. If a HIT requested multiple assignments, and has received some results but has not yet become Reviewable, you can still retrieve the partial results with this operation.
     *
     *  Use the AssignmentStatus parameter to control which set of assignments for a HIT are returned. The ListAssignmentsForHIT operation can return submitted assignments awaiting approval, or it can return assignments that have already been approved or rejected. You can set AssignmentStatus=Approved,Rejected to get assignments that have already been approved and rejected together in one result set.
     *
     *  Only the Requester who created the HIT can retrieve the assignments for that HIT.
     *
     *  Results are sorted and divided into numbered pages and the operation returns a single page of results. You can use the parameters of the operation to control sorting and pagination.
     */
    public suspend fun listAssignmentsForHit(input: ListAssignmentsForHitRequest): ListAssignmentsForHitResponse

    /**
     * The `ListBonusPayments` operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment.
     */
    public suspend fun listBonusPayments(input: ListBonusPaymentsRequest = ListBonusPaymentsRequest {}): ListBonusPaymentsResponse

    /**
     * The `ListHITs` operation returns all of a Requester's HITs. The operation returns HITs of any status, except for HITs that have been deleted of with the DeleteHIT operation or that have been auto-deleted.
     */
    public suspend fun listHiTs(input: ListHiTsRequest = ListHiTsRequest {}): ListHiTsResponse

    /**
     * The `ListHITsForQualificationType` operation returns the HITs that use the given Qualification type for a Qualification requirement. The operation returns HITs of any status, except for HITs that have been deleted with the `DeleteHIT` operation or that have been auto-deleted.
     */
    public suspend fun listHiTsForQualificationType(input: ListHiTsForQualificationTypeRequest): ListHiTsForQualificationTypeResponse

    /**
     * The `ListQualificationRequests` operation retrieves requests for Qualifications of a particular Qualification type. The owner of the Qualification type calls this operation to poll for pending requests, and accepts them using the AcceptQualification operation.
     */
    public suspend fun listQualificationRequests(input: ListQualificationRequestsRequest = ListQualificationRequestsRequest {}): ListQualificationRequestsResponse

    /**
     * The `ListQualificationTypes` operation returns a list of Qualification types, filtered by an optional search term.
     */
    public suspend fun listQualificationTypes(input: ListQualificationTypesRequest): ListQualificationTypesResponse

    /**
     * The `ListReviewPolicyResultsForHIT` operation retrieves the computed results and the actions taken in the course of executing your Review Policies for a given HIT. For information about how to specify Review Policies when you call CreateHIT, see Review Policies. The ListReviewPolicyResultsForHIT operation can return results for both Assignment-level and HIT-level review results.
     */
    public suspend fun listReviewPolicyResultsForHit(input: ListReviewPolicyResultsForHitRequest): ListReviewPolicyResultsForHitResponse

    /**
     * The `ListReviewableHITs` operation retrieves the HITs with Status equal to Reviewable or Status equal to Reviewing that belong to the Requester calling the operation.
     */
    public suspend fun listReviewableHiTs(input: ListReviewableHiTsRequest = ListReviewableHiTsRequest {}): ListReviewableHiTsResponse

    /**
     * The `ListWorkersBlocks` operation retrieves a list of Workers who are blocked from working on your HITs.
     */
    public suspend fun listWorkerBlocks(input: ListWorkerBlocksRequest = ListWorkerBlocksRequest {}): ListWorkerBlocksResponse

    /**
     * The `ListWorkersWithQualificationType` operation returns all of the Workers that have been associated with a given Qualification type.
     */
    public suspend fun listWorkersWithQualificationType(input: ListWorkersWithQualificationTypeRequest): ListWorkersWithQualificationTypeResponse

    /**
     * The `NotifyWorkers` operation sends an email to one or more Workers that you specify with the Worker ID. You can specify up to 100 Worker IDs to send the same message with a single call to the NotifyWorkers operation. The NotifyWorkers operation will send a notification email to a Worker only if you have previously approved or rejected work from the Worker.
     */
    public suspend fun notifyWorkers(input: NotifyWorkersRequest): NotifyWorkersResponse

    /**
     * The `RejectAssignment` operation rejects the results of a completed assignment.
     *
     *  You can include an optional feedback message with the rejection, which the Worker can see in the Status section of the web site. When you include a feedback message with the rejection, it helps the Worker understand why the assignment was rejected, and can improve the quality of the results the Worker submits in the future.
     *
     *  Only the Requester who created the HIT can reject an assignment for the HIT.
     */
    public suspend fun rejectAssignment(input: RejectAssignmentRequest): RejectAssignmentResponse

    /**
     * The `RejectQualificationRequest` operation rejects a user's request for a Qualification.
     *
     *  You can provide a text message explaining why the request was rejected. The Worker who made the request can see this message.
     */
    public suspend fun rejectQualificationRequest(input: RejectQualificationRequestRequest): RejectQualificationRequestResponse

    /**
     * The `SendBonus` operation issues a payment of money from your account to a Worker. This payment happens separately from the reward you pay to the Worker when you approve the Worker's assignment. The SendBonus operation requires the Worker's ID and the assignment ID as parameters to initiate payment of the bonus. You must include a message that explains the reason for the bonus payment, as the Worker may not be expecting the payment. Amazon Mechanical Turk collects a fee for bonus payments, similar to the HIT listing fee. This operation fails if your account does not have enough funds to pay for both the bonus and the fees.
     */
    public suspend fun sendBonus(input: SendBonusRequest): SendBonusResponse

    /**
     * The `SendTestEventNotification` operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification. This allows you to test notifications without setting up notifications for a real HIT type and trying to trigger them using the website. When you call this operation, the service attempts to send the test notification immediately.
     */
    public suspend fun sendTestEventNotification(input: SendTestEventNotificationRequest): SendTestEventNotificationResponse

    /**
     * The `UpdateExpirationForHIT` operation allows you update the expiration time of a HIT. If you update it to a time in the past, the HIT will be immediately expired.
     */
    public suspend fun updateExpirationForHit(input: UpdateExpirationForHitRequest): UpdateExpirationForHitResponse

    /**
     * The `UpdateHITReviewStatus` operation updates the status of a HIT. If the status is Reviewable, this operation can update the status to Reviewing, or it can revert a Reviewing HIT back to the Reviewable status.
     */
    public suspend fun updateHitReviewStatus(input: UpdateHitReviewStatusRequest): UpdateHitReviewStatusResponse

    /**
     * The `UpdateHITTypeOfHIT` operation allows you to change the HITType properties of a HIT. This operation disassociates the HIT from its old HITType properties and associates it with the new HITType properties. The HIT takes on the properties of the new HITType in place of the old ones.
     */
    public suspend fun updateHitTypeOfHit(input: UpdateHitTypeOfHitRequest): UpdateHitTypeOfHitResponse

    /**
     * The `UpdateNotificationSettings` operation creates, updates, disables or re-enables notifications for a HIT type. If you call the UpdateNotificationSettings operation for a HIT type that already has a notification specification, the operation replaces the old specification with a new one. You can call the UpdateNotificationSettings operation to enable or disable notifications for the HIT type, without having to modify the notification specification itself by providing updates to the Active status without specifying a new notification specification. To change the Active status of a HIT type's notifications, the HIT type must already have a notification specification, or one must be provided in the same call to `UpdateNotificationSettings`.
     */
    public suspend fun updateNotificationSettings(input: UpdateNotificationSettingsRequest): UpdateNotificationSettingsResponse

    /**
     * The `UpdateQualificationType` operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure. Only the owner of a Qualification type can modify its attributes.
     *
     *  Most attributes of a Qualification type can be changed after the type has been created. However, the Name and Keywords fields cannot be modified. The RetryDelayInSeconds parameter can be modified or added to change the delay or to enable retries, but RetryDelayInSeconds cannot be used to disable retries.
     *
     *  You can use this operation to update the test for a Qualification type. The test is updated based on the values specified for the Test, TestDurationInSeconds and AnswerKey parameters. All three parameters specify the updated test. If you are updating the test for a type, you must specify the Test and TestDurationInSeconds parameters. The AnswerKey parameter is optional; omitting it specifies that the updated test does not have an answer key.
     *
     *  If you omit the Test parameter, the test for the Qualification type is unchanged. There is no way to remove a test from a Qualification type that has one. If the type already has a test, you cannot update it to be AutoGranted. If the Qualification type does not have a test and one is provided by an update, the type will henceforth have a test.
     *
     *  If you want to update the test duration or answer key for an existing test without changing the questions, you must specify a Test parameter with the original questions, along with the updated values.
     *
     *  If you provide an updated Test but no AnswerKey, the new test will not have an answer key. Requests for such Qualifications must be granted manually.
     *
     *  You can also update the AutoGranted and AutoGrantedValue attributes of the Qualification type.
     */
    public suspend fun updateQualificationType(input: UpdateQualificationTypeRequest): UpdateQualificationTypeResponse
}

/**
 * The `AcceptQualificationRequest` operation approves a Worker's request for a Qualification.
 *
 *  Only the owner of the Qualification type can grant a Qualification request for that type.
 *
 *  A successful request for the `AcceptQualificationRequest` operation returns with no errors and an empty body.
 */
public suspend inline fun MTurkClient.acceptQualificationRequest(crossinline block: AcceptQualificationRequestRequest.Builder.() -> Unit): AcceptQualificationRequestResponse = acceptQualificationRequest(AcceptQualificationRequestRequest.Builder().apply(block).build())

/**
 * The `ApproveAssignment` operation approves the results of a completed assignment.
 *
 *  Approving an assignment initiates two payments from the Requester's Amazon.com account
 * +  The Worker who submitted the results is paid the reward specified in the HIT.
 * +  Amazon Mechanical Turk fees are debited.
 *
 *  If the Requester's account does not have adequate funds for these payments, the call to ApproveAssignment returns an exception, and the approval is not processed. You can include an optional feedback message with the approval, which the Worker can see in the Status section of the web site.
 *
 *  You can also call this operation for assignments that were previous rejected and approve them by explicitly overriding the previous rejection. This only works on rejected assignments that were submitted within the previous 30 days and only if the assignment's related HIT has not been deleted.
 */
public suspend inline fun MTurkClient.approveAssignment(crossinline block: ApproveAssignmentRequest.Builder.() -> Unit): ApproveAssignmentResponse = approveAssignment(ApproveAssignmentRequest.Builder().apply(block).build())

/**
 * The `AssociateQualificationWithWorker` operation gives a Worker a Qualification. `AssociateQualificationWithWorker` does not require that the Worker submit a Qualification request. It gives the Qualification directly to the Worker.
 *
 *  You can only assign a Qualification of a Qualification type that you created (using the `CreateQualificationType` operation).
 *
 *  Note: `AssociateQualificationWithWorker` does not affect any pending Qualification requests for the Qualification by the Worker. If you assign a Qualification to a Worker, then later grant a Qualification request made by the Worker, the granting of the request may modify the Qualification score. To resolve a pending Qualification request without affecting the Qualification the Worker already has, reject the request with the `RejectQualificationRequest` operation.
 */
public suspend inline fun MTurkClient.associateQualificationWithWorker(crossinline block: AssociateQualificationWithWorkerRequest.Builder.() -> Unit): AssociateQualificationWithWorkerResponse = associateQualificationWithWorker(AssociateQualificationWithWorkerRequest.Builder().apply(block).build())

/**
 * The `CreateAdditionalAssignmentsForHIT` operation increases the maximum number of assignments of an existing HIT.
 *
 *  To extend the maximum number of assignments, specify the number of additional assignments.
 *
 * + HITs created with fewer than 10 assignments cannot be extended to have 10 or more assignments. Attempting to add assignments in a way that brings the total number of assignments for a HIT from fewer than 10 assignments to 10 or more assignments will result in an `AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease` exception.
 * + HITs that were created before July 22, 2015 cannot be extended. Attempting to extend HITs that were created before July 22, 2015 will result in an `AWS.MechanicalTurk.HITTooOldForExtension` exception.
 */
public suspend inline fun MTurkClient.createAdditionalAssignmentsForHit(crossinline block: CreateAdditionalAssignmentsForHitRequest.Builder.() -> Unit): CreateAdditionalAssignmentsForHitResponse = createAdditionalAssignmentsForHit(CreateAdditionalAssignmentsForHitRequest.Builder().apply(block).build())

/**
 * The `CreateHIT` operation creates a new Human Intelligence Task (HIT). The new HIT is made available for Workers to find and accept on the Amazon Mechanical Turk website.
 *
 *  This operation allows you to specify a new HIT by passing in values for the properties of the HIT, such as its title, reward amount and number of assignments. When you pass these values to `CreateHIT`, a new HIT is created for you, with a new `HITTypeID`. The HITTypeID can be used to create additional HITs in the future without needing to specify common parameters such as the title, description and reward amount each time.
 *
 *  An alternative way to create HITs is to first generate a HITTypeID using the `CreateHITType` operation and then call the `CreateHITWithHITType` operation. This is the recommended best practice for Requesters who are creating large numbers of HITs.
 *
 * CreateHIT also supports several ways to provide question data: by providing a value for the `Question` parameter that fully specifies the contents of the HIT, or by providing a `HitLayoutId` and associated `HitLayoutParameters`.
 *
 *  If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see [Amazon Mechanical Turk Pricing](https://requester.mturk.com/pricing).
 */
public suspend inline fun MTurkClient.createHit(crossinline block: CreateHitRequest.Builder.() -> Unit): CreateHitResponse = createHit(CreateHitRequest.Builder().apply(block).build())

/**
 * The `CreateHITType` operation creates a new HIT type. This operation allows you to define a standard set of HIT properties to use when creating HITs. If you register a HIT type with values that match an existing HIT type, the HIT type ID of the existing type will be returned.
 */
public suspend inline fun MTurkClient.createHitType(crossinline block: CreateHitTypeRequest.Builder.() -> Unit): CreateHitTypeResponse = createHitType(CreateHitTypeRequest.Builder().apply(block).build())

/**
 * The `CreateHITWithHITType` operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the `CreateHITType` operation.
 *
 *  This is an alternative way to create HITs from the `CreateHIT` operation. This is the recommended best practice for Requesters who are creating large numbers of HITs.
 *
 * CreateHITWithHITType also supports several ways to provide question data: by providing a value for the `Question` parameter that fully specifies the contents of the HIT, or by providing a `HitLayoutId` and associated `HitLayoutParameters`.
 *
 *  If a HIT is created with 10 or more maximum assignments, there is an additional fee. For more information, see [Amazon Mechanical Turk Pricing](https://requester.mturk.com/pricing).
 */
public suspend inline fun MTurkClient.createHitWithHitType(crossinline block: CreateHitWithHitTypeRequest.Builder.() -> Unit): CreateHitWithHitTypeResponse = createHitWithHitType(CreateHitWithHitTypeRequest.Builder().apply(block).build())

/**
 * The `CreateQualificationType` operation creates a new Qualification type, which is represented by a `QualificationType` data structure.
 */
public suspend inline fun MTurkClient.createQualificationType(crossinline block: CreateQualificationTypeRequest.Builder.() -> Unit): CreateQualificationTypeResponse = createQualificationType(CreateQualificationTypeRequest.Builder().apply(block).build())

/**
 * The `CreateWorkerBlock` operation allows you to prevent a Worker from working on your HITs. For example, you can block a Worker who is producing poor quality work. You can block up to 100,000 Workers.
 */
public suspend inline fun MTurkClient.createWorkerBlock(crossinline block: CreateWorkerBlockRequest.Builder.() -> Unit): CreateWorkerBlockResponse = createWorkerBlock(CreateWorkerBlockRequest.Builder().apply(block).build())

/**
 * The `DeleteHIT` operation is used to delete HIT that is no longer needed. Only the Requester who created the HIT can delete it.
 *
 *  You can only dispose of HITs that are in the `Reviewable` state, with all of their submitted assignments already either approved or rejected. If you call the DeleteHIT operation on a HIT that is not in the `Reviewable` state (for example, that has not expired, or still has active assignments), or on a HIT that is Reviewable but without all of its submitted assignments already approved or rejected, the service will return an error.
 *
 * +  HITs are automatically disposed of after 120 days.
 * +  After you dispose of a HIT, you can no longer approve the HIT's rejected assignments.
 * +  Disposed HITs are not returned in results for the ListHITs operation.
 * +  Disposing HITs can improve the performance of operations such as ListReviewableHITs and ListHITs.
 */
public suspend inline fun MTurkClient.deleteHit(crossinline block: DeleteHitRequest.Builder.() -> Unit): DeleteHitResponse = deleteHit(DeleteHitRequest.Builder().apply(block).build())

/**
 * The `DeleteQualificationType` deletes a Qualification type and deletes any HIT types that are associated with the Qualification type.
 *
 * This operation does not revoke Qualifications already assigned to Workers because the Qualifications might be needed for active HITs. If there are any pending requests for the Qualification type, Amazon Mechanical Turk rejects those requests. After you delete a Qualification type, you can no longer use it to create HITs or HIT types.
 *
 * DeleteQualificationType must wait for all the HITs that use the deleted Qualification type to be deleted before completing. It may take up to 48 hours before DeleteQualificationType completes and the unique name of the Qualification type is available for reuse with CreateQualificationType.
 */
public suspend inline fun MTurkClient.deleteQualificationType(crossinline block: DeleteQualificationTypeRequest.Builder.() -> Unit): DeleteQualificationTypeResponse = deleteQualificationType(DeleteQualificationTypeRequest.Builder().apply(block).build())

/**
 * The `DeleteWorkerBlock` operation allows you to reinstate a blocked Worker to work on your HITs. This operation reverses the effects of the CreateWorkerBlock operation. You need the Worker ID to use this operation. If the Worker ID is missing or invalid, this operation fails and returns the message “WorkerId is invalid.” If the specified Worker is not blocked, this operation returns successfully.
 */
public suspend inline fun MTurkClient.deleteWorkerBlock(crossinline block: DeleteWorkerBlockRequest.Builder.() -> Unit): DeleteWorkerBlockResponse = deleteWorkerBlock(DeleteWorkerBlockRequest.Builder().apply(block).build())

/**
 * The `DisassociateQualificationFromWorker` revokes a previously granted Qualification from a user.
 *
 *  You can provide a text message explaining why the Qualification was revoked. The user who had the Qualification can see this message.
 */
public suspend inline fun MTurkClient.disassociateQualificationFromWorker(crossinline block: DisassociateQualificationFromWorkerRequest.Builder.() -> Unit): DisassociateQualificationFromWorkerResponse = disassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest.Builder().apply(block).build())

/**
 * The `GetAccountBalance` operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk account if you are a Prepaid Requester. Alternatively, this operation will retrieve the remaining available AWS Billing usage if you have enabled AWS Billing. Note: If you have enabled AWS Billing and still have a remaining Prepaid HITs balance, this balance can be viewed on the My Account page in the Requester console.
 */
public suspend inline fun MTurkClient.getAccountBalance(crossinline block: GetAccountBalanceRequest.Builder.() -> Unit): GetAccountBalanceResponse = getAccountBalance(GetAccountBalanceRequest.Builder().apply(block).build())

/**
 * The `GetAssignment` operation retrieves the details of the specified Assignment.
 */
public suspend inline fun MTurkClient.getAssignment(crossinline block: GetAssignmentRequest.Builder.() -> Unit): GetAssignmentResponse = getAssignment(GetAssignmentRequest.Builder().apply(block).build())

/**
 * The `GetFileUploadURL` operation generates and returns a temporary URL. You use the temporary URL to retrieve a file uploaded by a Worker as an answer to a FileUploadAnswer question for a HIT. The temporary URL is generated the instant the GetFileUploadURL operation is called, and is valid for 60 seconds. You can get a temporary file upload URL any time until the HIT is disposed. After the HIT is disposed, any uploaded files are deleted, and cannot be retrieved. Pending Deprecation on December 12, 2017. The Answer Specification structure will no longer support the `FileUploadAnswer` element to be used for the QuestionForm data structure. Instead, we recommend that Requesters who want to create HITs asking Workers to upload files to use Amazon S3.
 */
public suspend inline fun MTurkClient.getFileUploadUrl(crossinline block: GetFileUploadUrlRequest.Builder.() -> Unit): GetFileUploadUrlResponse = getFileUploadUrl(GetFileUploadUrlRequest.Builder().apply(block).build())

/**
 * The `GetHIT` operation retrieves the details of the specified HIT.
 */
public suspend inline fun MTurkClient.getHit(crossinline block: GetHitRequest.Builder.() -> Unit): GetHitResponse = getHit(GetHitRequest.Builder().apply(block).build())

/**
 * The `GetQualificationScore` operation returns the value of a Worker's Qualification for a given Qualification type.
 *
 *  To get a Worker's Qualification, you must know the Worker's ID. The Worker's ID is included in the assignment data returned by the `ListAssignmentsForHIT` operation.
 *
 * Only the owner of a Qualification type can query the value of a Worker's Qualification of that type.
 */
public suspend inline fun MTurkClient.getQualificationScore(crossinline block: GetQualificationScoreRequest.Builder.() -> Unit): GetQualificationScoreResponse = getQualificationScore(GetQualificationScoreRequest.Builder().apply(block).build())

/**
 * The `GetQualificationType`operation retrieves information about a Qualification type using its ID.
 */
public suspend inline fun MTurkClient.getQualificationType(crossinline block: GetQualificationTypeRequest.Builder.() -> Unit): GetQualificationTypeResponse = getQualificationType(GetQualificationTypeRequest.Builder().apply(block).build())

/**
 * The `ListAssignmentsForHIT` operation retrieves completed assignments for a HIT. You can use this operation to retrieve the results for a HIT.
 *
 *  You can get assignments for a HIT at any time, even if the HIT is not yet Reviewable. If a HIT requested multiple assignments, and has received some results but has not yet become Reviewable, you can still retrieve the partial results with this operation.
 *
 *  Use the AssignmentStatus parameter to control which set of assignments for a HIT are returned. The ListAssignmentsForHIT operation can return submitted assignments awaiting approval, or it can return assignments that have already been approved or rejected. You can set AssignmentStatus=Approved,Rejected to get assignments that have already been approved and rejected together in one result set.
 *
 *  Only the Requester who created the HIT can retrieve the assignments for that HIT.
 *
 *  Results are sorted and divided into numbered pages and the operation returns a single page of results. You can use the parameters of the operation to control sorting and pagination.
 */
public suspend inline fun MTurkClient.listAssignmentsForHit(crossinline block: ListAssignmentsForHitRequest.Builder.() -> Unit): ListAssignmentsForHitResponse = listAssignmentsForHit(ListAssignmentsForHitRequest.Builder().apply(block).build())

/**
 * The `ListBonusPayments` operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment.
 */
public suspend inline fun MTurkClient.listBonusPayments(crossinline block: ListBonusPaymentsRequest.Builder.() -> Unit): ListBonusPaymentsResponse = listBonusPayments(ListBonusPaymentsRequest.Builder().apply(block).build())

/**
 * The `ListHITs` operation returns all of a Requester's HITs. The operation returns HITs of any status, except for HITs that have been deleted of with the DeleteHIT operation or that have been auto-deleted.
 */
public suspend inline fun MTurkClient.listHiTs(crossinline block: ListHiTsRequest.Builder.() -> Unit): ListHiTsResponse = listHiTs(ListHiTsRequest.Builder().apply(block).build())

/**
 * The `ListHITsForQualificationType` operation returns the HITs that use the given Qualification type for a Qualification requirement. The operation returns HITs of any status, except for HITs that have been deleted with the `DeleteHIT` operation or that have been auto-deleted.
 */
public suspend inline fun MTurkClient.listHiTsForQualificationType(crossinline block: ListHiTsForQualificationTypeRequest.Builder.() -> Unit): ListHiTsForQualificationTypeResponse = listHiTsForQualificationType(ListHiTsForQualificationTypeRequest.Builder().apply(block).build())

/**
 * The `ListQualificationRequests` operation retrieves requests for Qualifications of a particular Qualification type. The owner of the Qualification type calls this operation to poll for pending requests, and accepts them using the AcceptQualification operation.
 */
public suspend inline fun MTurkClient.listQualificationRequests(crossinline block: ListQualificationRequestsRequest.Builder.() -> Unit): ListQualificationRequestsResponse = listQualificationRequests(ListQualificationRequestsRequest.Builder().apply(block).build())

/**
 * The `ListQualificationTypes` operation returns a list of Qualification types, filtered by an optional search term.
 */
public suspend inline fun MTurkClient.listQualificationTypes(crossinline block: ListQualificationTypesRequest.Builder.() -> Unit): ListQualificationTypesResponse = listQualificationTypes(ListQualificationTypesRequest.Builder().apply(block).build())

/**
 * The `ListReviewPolicyResultsForHIT` operation retrieves the computed results and the actions taken in the course of executing your Review Policies for a given HIT. For information about how to specify Review Policies when you call CreateHIT, see Review Policies. The ListReviewPolicyResultsForHIT operation can return results for both Assignment-level and HIT-level review results.
 */
public suspend inline fun MTurkClient.listReviewPolicyResultsForHit(crossinline block: ListReviewPolicyResultsForHitRequest.Builder.() -> Unit): ListReviewPolicyResultsForHitResponse = listReviewPolicyResultsForHit(ListReviewPolicyResultsForHitRequest.Builder().apply(block).build())

/**
 * The `ListReviewableHITs` operation retrieves the HITs with Status equal to Reviewable or Status equal to Reviewing that belong to the Requester calling the operation.
 */
public suspend inline fun MTurkClient.listReviewableHiTs(crossinline block: ListReviewableHiTsRequest.Builder.() -> Unit): ListReviewableHiTsResponse = listReviewableHiTs(ListReviewableHiTsRequest.Builder().apply(block).build())

/**
 * The `ListWorkersBlocks` operation retrieves a list of Workers who are blocked from working on your HITs.
 */
public suspend inline fun MTurkClient.listWorkerBlocks(crossinline block: ListWorkerBlocksRequest.Builder.() -> Unit): ListWorkerBlocksResponse = listWorkerBlocks(ListWorkerBlocksRequest.Builder().apply(block).build())

/**
 * The `ListWorkersWithQualificationType` operation returns all of the Workers that have been associated with a given Qualification type.
 */
public suspend inline fun MTurkClient.listWorkersWithQualificationType(crossinline block: ListWorkersWithQualificationTypeRequest.Builder.() -> Unit): ListWorkersWithQualificationTypeResponse = listWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest.Builder().apply(block).build())

/**
 * The `NotifyWorkers` operation sends an email to one or more Workers that you specify with the Worker ID. You can specify up to 100 Worker IDs to send the same message with a single call to the NotifyWorkers operation. The NotifyWorkers operation will send a notification email to a Worker only if you have previously approved or rejected work from the Worker.
 */
public suspend inline fun MTurkClient.notifyWorkers(crossinline block: NotifyWorkersRequest.Builder.() -> Unit): NotifyWorkersResponse = notifyWorkers(NotifyWorkersRequest.Builder().apply(block).build())

/**
 * The `RejectAssignment` operation rejects the results of a completed assignment.
 *
 *  You can include an optional feedback message with the rejection, which the Worker can see in the Status section of the web site. When you include a feedback message with the rejection, it helps the Worker understand why the assignment was rejected, and can improve the quality of the results the Worker submits in the future.
 *
 *  Only the Requester who created the HIT can reject an assignment for the HIT.
 */
public suspend inline fun MTurkClient.rejectAssignment(crossinline block: RejectAssignmentRequest.Builder.() -> Unit): RejectAssignmentResponse = rejectAssignment(RejectAssignmentRequest.Builder().apply(block).build())

/**
 * The `RejectQualificationRequest` operation rejects a user's request for a Qualification.
 *
 *  You can provide a text message explaining why the request was rejected. The Worker who made the request can see this message.
 */
public suspend inline fun MTurkClient.rejectQualificationRequest(crossinline block: RejectQualificationRequestRequest.Builder.() -> Unit): RejectQualificationRequestResponse = rejectQualificationRequest(RejectQualificationRequestRequest.Builder().apply(block).build())

/**
 * The `SendBonus` operation issues a payment of money from your account to a Worker. This payment happens separately from the reward you pay to the Worker when you approve the Worker's assignment. The SendBonus operation requires the Worker's ID and the assignment ID as parameters to initiate payment of the bonus. You must include a message that explains the reason for the bonus payment, as the Worker may not be expecting the payment. Amazon Mechanical Turk collects a fee for bonus payments, similar to the HIT listing fee. This operation fails if your account does not have enough funds to pay for both the bonus and the fees.
 */
public suspend inline fun MTurkClient.sendBonus(crossinline block: SendBonusRequest.Builder.() -> Unit): SendBonusResponse = sendBonus(SendBonusRequest.Builder().apply(block).build())

/**
 * The `SendTestEventNotification` operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification. This allows you to test notifications without setting up notifications for a real HIT type and trying to trigger them using the website. When you call this operation, the service attempts to send the test notification immediately.
 */
public suspend inline fun MTurkClient.sendTestEventNotification(crossinline block: SendTestEventNotificationRequest.Builder.() -> Unit): SendTestEventNotificationResponse = sendTestEventNotification(SendTestEventNotificationRequest.Builder().apply(block).build())

/**
 * The `UpdateExpirationForHIT` operation allows you update the expiration time of a HIT. If you update it to a time in the past, the HIT will be immediately expired.
 */
public suspend inline fun MTurkClient.updateExpirationForHit(crossinline block: UpdateExpirationForHitRequest.Builder.() -> Unit): UpdateExpirationForHitResponse = updateExpirationForHit(UpdateExpirationForHitRequest.Builder().apply(block).build())

/**
 * The `UpdateHITReviewStatus` operation updates the status of a HIT. If the status is Reviewable, this operation can update the status to Reviewing, or it can revert a Reviewing HIT back to the Reviewable status.
 */
public suspend inline fun MTurkClient.updateHitReviewStatus(crossinline block: UpdateHitReviewStatusRequest.Builder.() -> Unit): UpdateHitReviewStatusResponse = updateHitReviewStatus(UpdateHitReviewStatusRequest.Builder().apply(block).build())

/**
 * The `UpdateHITTypeOfHIT` operation allows you to change the HITType properties of a HIT. This operation disassociates the HIT from its old HITType properties and associates it with the new HITType properties. The HIT takes on the properties of the new HITType in place of the old ones.
 */
public suspend inline fun MTurkClient.updateHitTypeOfHit(crossinline block: UpdateHitTypeOfHitRequest.Builder.() -> Unit): UpdateHitTypeOfHitResponse = updateHitTypeOfHit(UpdateHitTypeOfHitRequest.Builder().apply(block).build())

/**
 * The `UpdateNotificationSettings` operation creates, updates, disables or re-enables notifications for a HIT type. If you call the UpdateNotificationSettings operation for a HIT type that already has a notification specification, the operation replaces the old specification with a new one. You can call the UpdateNotificationSettings operation to enable or disable notifications for the HIT type, without having to modify the notification specification itself by providing updates to the Active status without specifying a new notification specification. To change the Active status of a HIT type's notifications, the HIT type must already have a notification specification, or one must be provided in the same call to `UpdateNotificationSettings`.
 */
public suspend inline fun MTurkClient.updateNotificationSettings(crossinline block: UpdateNotificationSettingsRequest.Builder.() -> Unit): UpdateNotificationSettingsResponse = updateNotificationSettings(UpdateNotificationSettingsRequest.Builder().apply(block).build())

/**
 * The `UpdateQualificationType` operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure. Only the owner of a Qualification type can modify its attributes.
 *
 *  Most attributes of a Qualification type can be changed after the type has been created. However, the Name and Keywords fields cannot be modified. The RetryDelayInSeconds parameter can be modified or added to change the delay or to enable retries, but RetryDelayInSeconds cannot be used to disable retries.
 *
 *  You can use this operation to update the test for a Qualification type. The test is updated based on the values specified for the Test, TestDurationInSeconds and AnswerKey parameters. All three parameters specify the updated test. If you are updating the test for a type, you must specify the Test and TestDurationInSeconds parameters. The AnswerKey parameter is optional; omitting it specifies that the updated test does not have an answer key.
 *
 *  If you omit the Test parameter, the test for the Qualification type is unchanged. There is no way to remove a test from a Qualification type that has one. If the type already has a test, you cannot update it to be AutoGranted. If the Qualification type does not have a test and one is provided by an update, the type will henceforth have a test.
 *
 *  If you want to update the test duration or answer key for an existing test without changing the questions, you must specify a Test parameter with the original questions, along with the updated values.
 *
 *  If you provide an updated Test but no AnswerKey, the new test will not have an answer key. Requests for such Qualifications must be granted manually.
 *
 *  You can also update the AutoGranted and AutoGrantedValue attributes of the Qualification type.
 */
public suspend inline fun MTurkClient.updateQualificationType(crossinline block: UpdateQualificationTypeRequest.Builder.() -> Unit): UpdateQualificationTypeResponse = updateQualificationType(UpdateQualificationTypeRequest.Builder().apply(block).build())
