// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



public class CreateQualificationTypeRequest private constructor(builder: Builder) {
    /**
     * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.
     *
     * Constraints: Must not be longer than 65535 bytes.
     *
     * Constraints: None. If not specified, you must process Qualification requests manually.
     */
    public val answerKey: kotlin.String? = builder.answerKey
    /**
     * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.
     *
     * Constraints: If the Test parameter is specified, this parameter cannot be true.
     */
    public val autoGranted: kotlin.Boolean? = builder.autoGranted
    /**
     * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.
     */
    public val autoGrantedValue: kotlin.Int? = builder.autoGrantedValue
    /**
     * A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is displayed when a Worker examines a Qualification type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a type make the type easier to find during a search.
     */
    public val keywords: kotlin.String? = builder.keywords
    /**
     * The name you give to the Qualification type. The type name is used to represent the Qualification to Workers, and to find the type using a Qualification type search. It must be unique across all of your Qualification types.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The initial status of the Qualification type.
     *
     * Constraints: Valid values are: Active | Inactive
     */
    public val qualificationTypeStatus: aws.sdk.kotlin.services.mturk.model.QualificationTypeStatus? = builder.qualificationTypeStatus
    /**
     * The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type before the worker can retry the Qualification request.
     *
     * Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this type only once, even if the Worker has not been granted the Qualification. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must delete existing retry-enabled Qualification type and then create a new Qualification type with retries disabled.
     */
    public val retryDelayInSeconds: kotlin.Long? = builder.retryDelayInSeconds
    /**
     * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, `TestDurationInSeconds` must also be specified.
     *
     * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.
     *
     * Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.
     */
    public val test: kotlin.String? = builder.test
    /**
     * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.
     */
    public val testDurationInSeconds: kotlin.Long? = builder.testDurationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.CreateQualificationTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateQualificationTypeRequest(")
        append("answerKey=$answerKey,")
        append("autoGranted=$autoGranted,")
        append("autoGrantedValue=$autoGrantedValue,")
        append("description=$description,")
        append("keywords=$keywords,")
        append("name=$name,")
        append("qualificationTypeStatus=$qualificationTypeStatus,")
        append("retryDelayInSeconds=$retryDelayInSeconds,")
        append("test=$test,")
        append("testDurationInSeconds=$testDurationInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = answerKey?.hashCode() ?: 0
        result = 31 * result + (autoGranted?.hashCode() ?: 0)
        result = 31 * result + (autoGrantedValue ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeStatus?.hashCode() ?: 0)
        result = 31 * result + (retryDelayInSeconds?.hashCode() ?: 0)
        result = 31 * result + (test?.hashCode() ?: 0)
        result = 31 * result + (testDurationInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateQualificationTypeRequest

        if (answerKey != other.answerKey) return false
        if (autoGranted != other.autoGranted) return false
        if (autoGrantedValue != other.autoGrantedValue) return false
        if (description != other.description) return false
        if (keywords != other.keywords) return false
        if (name != other.name) return false
        if (qualificationTypeStatus != other.qualificationTypeStatus) return false
        if (retryDelayInSeconds != other.retryDelayInSeconds) return false
        if (test != other.test) return false
        if (testDurationInSeconds != other.testDurationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.CreateQualificationTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The answers to the Qualification test specified in the Test parameter, in the form of an AnswerKey data structure.
         *
         * Constraints: Must not be longer than 65535 bytes.
         *
         * Constraints: None. If not specified, you must process Qualification requests manually.
         */
        public var answerKey: kotlin.String? = null
        /**
         * Specifies whether requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test.
         *
         * Constraints: If the Test parameter is specified, this parameter cannot be true.
         */
        public var autoGranted: kotlin.Boolean? = null
        /**
         * The Qualification value to use for automatically granted Qualifications. This parameter is used only if the AutoGranted parameter is true.
         */
        public var autoGrantedValue: kotlin.Int? = null
        /**
         * A long description for the Qualification type. On the Amazon Mechanical Turk website, the long description is displayed when a Worker examines a Qualification type.
         */
        public var description: kotlin.String? = null
        /**
         * One or more words or phrases that describe the Qualification type, separated by commas. The keywords of a type make the type easier to find during a search.
         */
        public var keywords: kotlin.String? = null
        /**
         * The name you give to the Qualification type. The type name is used to represent the Qualification to Workers, and to find the type using a Qualification type search. It must be unique across all of your Qualification types.
         */
        public var name: kotlin.String? = null
        /**
         * The initial status of the Qualification type.
         *
         * Constraints: Valid values are: Active | Inactive
         */
        public var qualificationTypeStatus: aws.sdk.kotlin.services.mturk.model.QualificationTypeStatus? = null
        /**
         * The number of seconds that a Worker must wait after requesting a Qualification of the Qualification type before the worker can retry the Qualification request.
         *
         * Constraints: None. If not specified, retries are disabled and Workers can request a Qualification of this type only once, even if the Worker has not been granted the Qualification. It is not possible to disable retries for a Qualification type after it has been created with retries enabled. If you want to disable retries, you must delete existing retry-enabled Qualification type and then create a new Qualification type with retries disabled.
         */
        public var retryDelayInSeconds: kotlin.Long? = null
        /**
         * The questions for the Qualification test a Worker must answer correctly to obtain a Qualification of this type. If this parameter is specified, `TestDurationInSeconds` must also be specified.
         *
         * Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm data structure. This parameter cannot be specified if AutoGranted is true.
         *
         * Constraints: None. If not specified, the Worker may request the Qualification without answering any questions.
         */
        public var test: kotlin.String? = null
        /**
         * The number of seconds the Worker has to complete the Qualification test, starting from the time the Worker requests the Qualification.
         */
        public var testDurationInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.CreateQualificationTypeRequest) : this() {
            this.answerKey = x.answerKey
            this.autoGranted = x.autoGranted
            this.autoGrantedValue = x.autoGrantedValue
            this.description = x.description
            this.keywords = x.keywords
            this.name = x.name
            this.qualificationTypeStatus = x.qualificationTypeStatus
            this.retryDelayInSeconds = x.retryDelayInSeconds
            this.test = x.test
            this.testDurationInSeconds = x.testDurationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.CreateQualificationTypeRequest = CreateQualificationTypeRequest(this)
    }
}
