// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The HIT data structure represents a single HIT, including all the information necessary for a Worker to accept and complete the HIT.
 */
public class Hit private constructor(builder: Builder) {
    /**
     * The length of time, in seconds, that a Worker has to complete the HIT after accepting it.
     */
    public val assignmentDurationInSeconds: kotlin.Long? = builder.assignmentDurationInSeconds
    /**
     * The amount of time, in seconds, after the Worker submits an assignment for the HIT that the results are automatically approved by Amazon Mechanical Turk. This is the amount of time the Requester has to reject an assignment submitted by a Worker before the assignment is auto-approved and the Worker is paid.
     */
    public val autoApprovalDelayInSeconds: kotlin.Long? = builder.autoApprovalDelayInSeconds
    /**
     * The date and time the HIT was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A general description of the HIT.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date and time the HIT expires.
     */
    public val expiration: aws.smithy.kotlin.runtime.time.Instant? = builder.expiration
    /**
     * The ID of the HIT Group of this HIT.
     */
    public val hitGroupId: kotlin.String? = builder.hitGroupId
    /**
     * A unique identifier for the HIT.
     */
    public val hitId: kotlin.String? = builder.hitId
    /**
     * The ID of the HIT Layout of this HIT.
     */
    public val hitLayoutId: kotlin.String? = builder.hitLayoutId
    /**
     * Indicates the review status of the HIT. Valid Values are NotReviewed | MarkedForReview | ReviewedAppropriate | ReviewedInappropriate.
     */
    public val hitReviewStatus: aws.sdk.kotlin.services.mturk.model.HitReviewStatus? = builder.hitReviewStatus
    /**
     * The status of the HIT and its assignments. Valid Values are Assignable | Unassignable | Reviewable | Reviewing | Disposed.
     */
    public val hitStatus: aws.sdk.kotlin.services.mturk.model.HitStatus? = builder.hitStatus
    /**
     * The ID of the HIT type of this HIT
     */
    public val hitTypeId: kotlin.String? = builder.hitTypeId
    /**
     * One or more words or phrases that describe the HIT, separated by commas. Search terms similar to the keywords of a HIT are more likely to have the HIT in the search results.
     */
    public val keywords: kotlin.String? = builder.keywords
    /**
     * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
     */
    public val maxAssignments: kotlin.Int? = builder.maxAssignments
    /**
     * The number of assignments for this HIT that are available for Workers to accept.
     */
    public val numberOfAssignmentsAvailable: kotlin.Int? = builder.numberOfAssignmentsAvailable
    /**
     * The number of assignments for this HIT that have been approved or rejected.
     */
    public val numberOfAssignmentsCompleted: kotlin.Int? = builder.numberOfAssignmentsCompleted
    /**
     * The number of assignments for this HIT that are being previewed or have been accepted by Workers, but have not yet been submitted, returned, or abandoned.
     */
    public val numberOfAssignmentsPending: kotlin.Int? = builder.numberOfAssignmentsPending
    /**
     * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the `ActionsGuarded` field on each `QualificationRequirement` structure.
     */
    public val qualificationRequirements: List<QualificationRequirement>? = builder.qualificationRequirements
    /**
     * The data the Worker completing the HIT uses produce the results. This is either either a QuestionForm, HTMLQuestion or an ExternalQuestion data structure.
     */
    public val question: kotlin.String? = builder.question
    /**
     * An arbitrary data field the Requester who created the HIT can use. This field is visible only to the creator of the HIT.
     */
    public val requesterAnnotation: kotlin.String? = builder.requesterAnnotation
    /**
     * A string representing a currency amount.
     */
    public val reward: kotlin.String? = builder.reward
    /**
     * The title of the HIT.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.Hit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Hit(")
        append("assignmentDurationInSeconds=$assignmentDurationInSeconds,")
        append("autoApprovalDelayInSeconds=$autoApprovalDelayInSeconds,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("expiration=$expiration,")
        append("hitGroupId=$hitGroupId,")
        append("hitId=$hitId,")
        append("hitLayoutId=$hitLayoutId,")
        append("hitReviewStatus=$hitReviewStatus,")
        append("hitStatus=$hitStatus,")
        append("hitTypeId=$hitTypeId,")
        append("keywords=$keywords,")
        append("maxAssignments=$maxAssignments,")
        append("numberOfAssignmentsAvailable=$numberOfAssignmentsAvailable,")
        append("numberOfAssignmentsCompleted=$numberOfAssignmentsCompleted,")
        append("numberOfAssignmentsPending=$numberOfAssignmentsPending,")
        append("qualificationRequirements=$qualificationRequirements,")
        append("question=$question,")
        append("requesterAnnotation=$requesterAnnotation,")
        append("reward=$reward,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignmentDurationInSeconds?.hashCode() ?: 0
        result = 31 * result + (autoApprovalDelayInSeconds?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (hitGroupId?.hashCode() ?: 0)
        result = 31 * result + (hitId?.hashCode() ?: 0)
        result = 31 * result + (hitLayoutId?.hashCode() ?: 0)
        result = 31 * result + (hitReviewStatus?.hashCode() ?: 0)
        result = 31 * result + (hitStatus?.hashCode() ?: 0)
        result = 31 * result + (hitTypeId?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (maxAssignments ?: 0)
        result = 31 * result + (numberOfAssignmentsAvailable ?: 0)
        result = 31 * result + (numberOfAssignmentsCompleted ?: 0)
        result = 31 * result + (numberOfAssignmentsPending ?: 0)
        result = 31 * result + (qualificationRequirements?.hashCode() ?: 0)
        result = 31 * result + (question?.hashCode() ?: 0)
        result = 31 * result + (requesterAnnotation?.hashCode() ?: 0)
        result = 31 * result + (reward?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Hit

        if (assignmentDurationInSeconds != other.assignmentDurationInSeconds) return false
        if (autoApprovalDelayInSeconds != other.autoApprovalDelayInSeconds) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (expiration != other.expiration) return false
        if (hitGroupId != other.hitGroupId) return false
        if (hitId != other.hitId) return false
        if (hitLayoutId != other.hitLayoutId) return false
        if (hitReviewStatus != other.hitReviewStatus) return false
        if (hitStatus != other.hitStatus) return false
        if (hitTypeId != other.hitTypeId) return false
        if (keywords != other.keywords) return false
        if (maxAssignments != other.maxAssignments) return false
        if (numberOfAssignmentsAvailable != other.numberOfAssignmentsAvailable) return false
        if (numberOfAssignmentsCompleted != other.numberOfAssignmentsCompleted) return false
        if (numberOfAssignmentsPending != other.numberOfAssignmentsPending) return false
        if (qualificationRequirements != other.qualificationRequirements) return false
        if (question != other.question) return false
        if (requesterAnnotation != other.requesterAnnotation) return false
        if (reward != other.reward) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.Hit = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The length of time, in seconds, that a Worker has to complete the HIT after accepting it.
         */
        public var assignmentDurationInSeconds: kotlin.Long? = null
        /**
         * The amount of time, in seconds, after the Worker submits an assignment for the HIT that the results are automatically approved by Amazon Mechanical Turk. This is the amount of time the Requester has to reject an assignment submitted by a Worker before the assignment is auto-approved and the Worker is paid.
         */
        public var autoApprovalDelayInSeconds: kotlin.Long? = null
        /**
         * The date and time the HIT was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A general description of the HIT.
         */
        public var description: kotlin.String? = null
        /**
         * The date and time the HIT expires.
         */
        public var expiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the HIT Group of this HIT.
         */
        public var hitGroupId: kotlin.String? = null
        /**
         * A unique identifier for the HIT.
         */
        public var hitId: kotlin.String? = null
        /**
         * The ID of the HIT Layout of this HIT.
         */
        public var hitLayoutId: kotlin.String? = null
        /**
         * Indicates the review status of the HIT. Valid Values are NotReviewed | MarkedForReview | ReviewedAppropriate | ReviewedInappropriate.
         */
        public var hitReviewStatus: aws.sdk.kotlin.services.mturk.model.HitReviewStatus? = null
        /**
         * The status of the HIT and its assignments. Valid Values are Assignable | Unassignable | Reviewable | Reviewing | Disposed.
         */
        public var hitStatus: aws.sdk.kotlin.services.mturk.model.HitStatus? = null
        /**
         * The ID of the HIT type of this HIT
         */
        public var hitTypeId: kotlin.String? = null
        /**
         * One or more words or phrases that describe the HIT, separated by commas. Search terms similar to the keywords of a HIT are more likely to have the HIT in the search results.
         */
        public var keywords: kotlin.String? = null
        /**
         * The number of times the HIT can be accepted and completed before the HIT becomes unavailable.
         */
        public var maxAssignments: kotlin.Int? = null
        /**
         * The number of assignments for this HIT that are available for Workers to accept.
         */
        public var numberOfAssignmentsAvailable: kotlin.Int? = null
        /**
         * The number of assignments for this HIT that have been approved or rejected.
         */
        public var numberOfAssignmentsCompleted: kotlin.Int? = null
        /**
         * The number of assignments for this HIT that are being previewed or have been accepted by Workers, but have not yet been submitted, returned, or abandoned.
         */
        public var numberOfAssignmentsPending: kotlin.Int? = null
        /**
         * Conditions that a Worker's Qualifications must meet in order to accept the HIT. A HIT can have between zero and ten Qualification requirements. All requirements must be met in order for a Worker to accept the HIT. Additionally, other actions can be restricted using the `ActionsGuarded` field on each `QualificationRequirement` structure.
         */
        public var qualificationRequirements: List<QualificationRequirement>? = null
        /**
         * The data the Worker completing the HIT uses produce the results. This is either either a QuestionForm, HTMLQuestion or an ExternalQuestion data structure.
         */
        public var question: kotlin.String? = null
        /**
         * An arbitrary data field the Requester who created the HIT can use. This field is visible only to the creator of the HIT.
         */
        public var requesterAnnotation: kotlin.String? = null
        /**
         * A string representing a currency amount.
         */
        public var reward: kotlin.String? = null
        /**
         * The title of the HIT.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.Hit) : this() {
            this.assignmentDurationInSeconds = x.assignmentDurationInSeconds
            this.autoApprovalDelayInSeconds = x.autoApprovalDelayInSeconds
            this.creationTime = x.creationTime
            this.description = x.description
            this.expiration = x.expiration
            this.hitGroupId = x.hitGroupId
            this.hitId = x.hitId
            this.hitLayoutId = x.hitLayoutId
            this.hitReviewStatus = x.hitReviewStatus
            this.hitStatus = x.hitStatus
            this.hitTypeId = x.hitTypeId
            this.keywords = x.keywords
            this.maxAssignments = x.maxAssignments
            this.numberOfAssignmentsAvailable = x.numberOfAssignmentsAvailable
            this.numberOfAssignmentsCompleted = x.numberOfAssignmentsCompleted
            this.numberOfAssignmentsPending = x.numberOfAssignmentsPending
            this.qualificationRequirements = x.qualificationRequirements
            this.question = x.question
            this.requesterAnnotation = x.requesterAnnotation
            this.reward = x.reward
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.Hit = Hit(this)
    }
}
