// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



/**
 * The NotificationSpecification data structure describes a HIT event notification for a HIT type.
 */
public class NotificationSpecification private constructor(builder: Builder) {
    /**
     * The target for notification messages. The Destination’s format is determined by the specified Transport:
     * + When Transport is Email, the Destination is your email address.
     * + When Transport is SQS, the Destination is your queue URL.
     * + When Transport is SNS, the Destination is the ARN of your topic.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The list of events that should cause notifications to be sent. Valid Values: AssignmentAccepted | AssignmentAbandoned | AssignmentReturned | AssignmentSubmitted | AssignmentRejected | AssignmentApproved | HITCreated | HITExtended | HITDisposed | HITReviewable | HITExpired | Ping. The Ping event is only valid for the SendTestEventNotification operation.
     */
    public val eventTypes: List<EventType>? = builder.eventTypes
    /**
     * The method Amazon Mechanical Turk uses to send the notification. Valid Values: Email | SQS | SNS.
     */
    public val transport: aws.sdk.kotlin.services.mturk.model.NotificationTransport? = builder.transport
    /**
     * The version of the Notification API to use. Valid value is 2006-05-05.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.NotificationSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationSpecification(")
        append("destination=$destination,")
        append("eventTypes=$eventTypes,")
        append("transport=$transport,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (eventTypes?.hashCode() ?: 0)
        result = 31 * result + (transport?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationSpecification

        if (destination != other.destination) return false
        if (eventTypes != other.eventTypes) return false
        if (transport != other.transport) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.NotificationSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The target for notification messages. The Destination’s format is determined by the specified Transport:
         * + When Transport is Email, the Destination is your email address.
         * + When Transport is SQS, the Destination is your queue URL.
         * + When Transport is SNS, the Destination is the ARN of your topic.
         */
        public var destination: kotlin.String? = null
        /**
         * The list of events that should cause notifications to be sent. Valid Values: AssignmentAccepted | AssignmentAbandoned | AssignmentReturned | AssignmentSubmitted | AssignmentRejected | AssignmentApproved | HITCreated | HITExtended | HITDisposed | HITReviewable | HITExpired | Ping. The Ping event is only valid for the SendTestEventNotification operation.
         */
        public var eventTypes: List<EventType>? = null
        /**
         * The method Amazon Mechanical Turk uses to send the notification. Valid Values: Email | SQS | SNS.
         */
        public var transport: aws.sdk.kotlin.services.mturk.model.NotificationTransport? = null
        /**
         * The version of the Notification API to use. Valid value is 2006-05-05.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.NotificationSpecification) : this() {
            this.destination = x.destination
            this.eventTypes = x.eventTypes
            this.transport = x.transport
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.NotificationSpecification = NotificationSpecification(this)
    }
}
