// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Qualification data structure represents a Qualification assigned to a user, including the Qualification type and the value (score).
 */
public class Qualification private constructor(builder: Builder) {
    /**
     * The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the AcceptQualificationRequest operation.
     */
    public val grantTime: aws.smithy.kotlin.runtime.time.Instant? = builder.grantTime
    /**
     * The value (score) of the Qualification, if the Qualification has an integer value.
     */
    public val integerValue: kotlin.Int? = builder.integerValue
    /**
     * The Locale data structure represents a geographical region or location.
     */
    public val localeValue: aws.sdk.kotlin.services.mturk.model.Locale? = builder.localeValue
    /**
     * The ID of the Qualification type for the Qualification.
     */
    public val qualificationTypeId: kotlin.String? = builder.qualificationTypeId
    /**
     * The status of the Qualification. Valid values are Granted | Revoked.
     */
    public val status: aws.sdk.kotlin.services.mturk.model.QualificationStatus? = builder.status
    /**
     * The ID of the Worker who possesses the Qualification.
     */
    public val workerId: kotlin.String? = builder.workerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.Qualification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Qualification(")
        append("grantTime=$grantTime,")
        append("integerValue=$integerValue,")
        append("localeValue=$localeValue,")
        append("qualificationTypeId=$qualificationTypeId,")
        append("status=$status,")
        append("workerId=$workerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = grantTime?.hashCode() ?: 0
        result = 31 * result + (integerValue ?: 0)
        result = 31 * result + (localeValue?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (workerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Qualification

        if (grantTime != other.grantTime) return false
        if (integerValue != other.integerValue) return false
        if (localeValue != other.localeValue) return false
        if (qualificationTypeId != other.qualificationTypeId) return false
        if (status != other.status) return false
        if (workerId != other.workerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.Qualification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time the Qualification was granted to the Worker. If the Worker's Qualification was revoked, and then re-granted based on a new Qualification request, GrantTime is the date and time of the last call to the AcceptQualificationRequest operation.
         */
        public var grantTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The value (score) of the Qualification, if the Qualification has an integer value.
         */
        public var integerValue: kotlin.Int? = null
        /**
         * The Locale data structure represents a geographical region or location.
         */
        public var localeValue: aws.sdk.kotlin.services.mturk.model.Locale? = null
        /**
         * The ID of the Qualification type for the Qualification.
         */
        public var qualificationTypeId: kotlin.String? = null
        /**
         * The status of the Qualification. Valid values are Granted | Revoked.
         */
        public var status: aws.sdk.kotlin.services.mturk.model.QualificationStatus? = null
        /**
         * The ID of the Worker who possesses the Qualification.
         */
        public var workerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.Qualification) : this() {
            this.grantTime = x.grantTime
            this.integerValue = x.integerValue
            this.localeValue = x.localeValue
            this.qualificationTypeId = x.qualificationTypeId
            this.status = x.status
            this.workerId = x.workerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.Qualification = Qualification(this)

        /**
         * construct an [aws.sdk.kotlin.services.mturk.model.Locale] inside the given [block]
         */
        public fun localeValue(block: aws.sdk.kotlin.services.mturk.model.Locale.Builder.() -> kotlin.Unit) {
            this.localeValue = aws.sdk.kotlin.services.mturk.model.Locale.invoke(block)
        }
    }
}
