// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The QualificationRequest data structure represents a request a Worker has made for a Qualification.
 */
public class QualificationRequest private constructor(builder: Builder) {
    /**
     * The Worker's answers for the Qualification type's test contained in a QuestionFormAnswers document, if the type has a test and the Worker has submitted answers. If the Worker does not provide any answers, Answer may be empty.
     */
    public val answer: kotlin.String? = builder.answer
    /**
     * The ID of the Qualification request, a unique identifier generated when the request was submitted.
     */
    public val qualificationRequestId: kotlin.String? = builder.qualificationRequestId
    /**
     * The ID of the Qualification type the Worker is requesting, as returned by the CreateQualificationType operation.
     */
    public val qualificationTypeId: kotlin.String? = builder.qualificationTypeId
    /**
     * The date and time the Qualification request had a status of Submitted. This is either the time the Worker submitted answers for a Qualification test, or the time the Worker requested the Qualification if the Qualification type does not have a test.
     */
    public val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * The contents of the Qualification test that was presented to the Worker, if the type has a test and the Worker has submitted answers. This value is identical to the QuestionForm associated with the Qualification type at the time the Worker requests the Qualification.
     */
    public val test: kotlin.String? = builder.test
    /**
     * The ID of the Worker requesting the Qualification.
     */
    public val workerId: kotlin.String? = builder.workerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.QualificationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QualificationRequest(")
        append("answer=$answer,")
        append("qualificationRequestId=$qualificationRequestId,")
        append("qualificationTypeId=$qualificationTypeId,")
        append("submitTime=$submitTime,")
        append("test=$test,")
        append("workerId=$workerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = answer?.hashCode() ?: 0
        result = 31 * result + (qualificationRequestId?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeId?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (test?.hashCode() ?: 0)
        result = 31 * result + (workerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QualificationRequest

        if (answer != other.answer) return false
        if (qualificationRequestId != other.qualificationRequestId) return false
        if (qualificationTypeId != other.qualificationTypeId) return false
        if (submitTime != other.submitTime) return false
        if (test != other.test) return false
        if (workerId != other.workerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.QualificationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Worker's answers for the Qualification type's test contained in a QuestionFormAnswers document, if the type has a test and the Worker has submitted answers. If the Worker does not provide any answers, Answer may be empty.
         */
        public var answer: kotlin.String? = null
        /**
         * The ID of the Qualification request, a unique identifier generated when the request was submitted.
         */
        public var qualificationRequestId: kotlin.String? = null
        /**
         * The ID of the Qualification type the Worker is requesting, as returned by the CreateQualificationType operation.
         */
        public var qualificationTypeId: kotlin.String? = null
        /**
         * The date and time the Qualification request had a status of Submitted. This is either the time the Worker submitted answers for a Qualification test, or the time the Worker requested the Qualification if the Qualification type does not have a test.
         */
        public var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The contents of the Qualification test that was presented to the Worker, if the type has a test and the Worker has submitted answers. This value is identical to the QuestionForm associated with the Qualification type at the time the Worker requests the Qualification.
         */
        public var test: kotlin.String? = null
        /**
         * The ID of the Worker requesting the Qualification.
         */
        public var workerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.QualificationRequest) : this() {
            this.answer = x.answer
            this.qualificationRequestId = x.qualificationRequestId
            this.qualificationTypeId = x.qualificationTypeId
            this.submitTime = x.submitTime
            this.test = x.test
            this.workerId = x.workerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.QualificationRequest = QualificationRequest(this)
    }
}
