// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



/**
 * The QualificationRequirement data structure describes a Qualification that a Worker must have before the Worker is allowed to accept a HIT. A requirement may optionally state that a Worker must have the Qualification in order to preview the HIT, or see the HIT in search results.
 */
public class QualificationRequirement private constructor(builder: Builder) {
    /**
     * Setting this attribute prevents Workers whose Qualifications do not meet this QualificationRequirement from taking the specified action. Valid arguments include "Accept" (Worker cannot accept the HIT, but can preview the HIT and see it in their search results), "PreviewAndAccept" (Worker cannot accept or preview the HIT, but can see the HIT in their search results), and "DiscoverPreviewAndAccept" (Worker cannot accept, preview, or see the HIT in their search results). It's possible for you to create a HIT with multiple QualificationRequirements (which can have different values for the ActionGuarded attribute). In this case, the Worker is only permitted to perform an action when they have met all QualificationRequirements guarding the action. The actions in the order of least restrictive to most restrictive are Discover, Preview and Accept. For example, if a Worker meets all QualificationRequirements that are set to DiscoverPreviewAndAccept, but do not meet all requirements that are set with PreviewAndAccept, then the Worker will be able to Discover, i.e. see the HIT in their search result, but will not be able to Preview or Accept the HIT. ActionsGuarded should not be used in combination with the `RequiredToPreview` field.
     */
    public val actionsGuarded: aws.sdk.kotlin.services.mturk.model.HitAccessActions? = builder.actionsGuarded
    /**
     * The kind of comparison to make against a Qualification's value. You can compare a Qualification's value to an IntegerValue to see if it is LessThan, LessThanOrEqualTo, GreaterThan, GreaterThanOrEqualTo, EqualTo, or NotEqualTo the IntegerValue. You can compare it to a LocaleValue to see if it is EqualTo, or NotEqualTo the LocaleValue. You can check to see if the value is In or NotIn a set of IntegerValue or LocaleValue values. Lastly, a Qualification requirement can also test if a Qualification Exists or DoesNotExist in the user's profile, regardless of its value.
     */
    public val comparator: aws.sdk.kotlin.services.mturk.model.Comparator? = builder.comparator
    /**
     * The integer value to compare against the Qualification's value. IntegerValue must not be present if Comparator is Exists or DoesNotExist. IntegerValue can only be used if the Qualification type has an integer value; it cannot be used with the Worker_Locale QualificationType ID. When performing a set comparison by using the In or the NotIn comparator, you can use up to 15 IntegerValue elements in a QualificationRequirement data structure.
     */
    public val integerValues: List<Int>? = builder.integerValues
    /**
     * The locale value to compare against the Qualification's value. The local value must be a valid ISO 3166 country code or supports ISO 3166-2 subdivisions. LocaleValue can only be used with a Worker_Locale QualificationType ID. LocaleValue can only be used with the EqualTo, NotEqualTo, In, and NotIn comparators. You must only use a single LocaleValue element when using the EqualTo or NotEqualTo comparators. When performing a set comparison by using the In or the NotIn comparator, you can use up to 30 LocaleValue elements in a QualificationRequirement data structure.
     */
    public val localeValues: List<Locale>? = builder.localeValues
    /**
     * The ID of the Qualification type for the requirement.
     */
    public val qualificationTypeId: kotlin.String? = builder.qualificationTypeId
    /**
     * DEPRECATED: Use the `ActionsGuarded` field instead. If RequiredToPreview is true, the question data for the HIT will not be shown when a Worker whose Qualifications do not meet this requirement tries to preview the HIT. That is, a Worker's Qualifications must meet all of the requirements for which RequiredToPreview is true in order to preview the HIT. If a Worker meets all of the requirements where RequiredToPreview is true (or if there are no such requirements), but does not meet all of the requirements for the HIT, the Worker will be allowed to preview the HIT's question data, but will not be allowed to accept and complete the HIT. The default is false. This should not be used in combination with the `ActionsGuarded` field.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val requiredToPreview: kotlin.Boolean? = builder.requiredToPreview

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.QualificationRequirement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QualificationRequirement(")
        append("actionsGuarded=$actionsGuarded,")
        append("comparator=$comparator,")
        append("integerValues=$integerValues,")
        append("localeValues=$localeValues,")
        append("qualificationTypeId=$qualificationTypeId,")
        append("requiredToPreview=$requiredToPreview)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionsGuarded?.hashCode() ?: 0
        result = 31 * result + (comparator?.hashCode() ?: 0)
        result = 31 * result + (integerValues?.hashCode() ?: 0)
        result = 31 * result + (localeValues?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeId?.hashCode() ?: 0)
        result = 31 * result + (requiredToPreview?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QualificationRequirement

        if (actionsGuarded != other.actionsGuarded) return false
        if (comparator != other.comparator) return false
        if (integerValues != other.integerValues) return false
        if (localeValues != other.localeValues) return false
        if (qualificationTypeId != other.qualificationTypeId) return false
        if (requiredToPreview != other.requiredToPreview) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.QualificationRequirement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Setting this attribute prevents Workers whose Qualifications do not meet this QualificationRequirement from taking the specified action. Valid arguments include "Accept" (Worker cannot accept the HIT, but can preview the HIT and see it in their search results), "PreviewAndAccept" (Worker cannot accept or preview the HIT, but can see the HIT in their search results), and "DiscoverPreviewAndAccept" (Worker cannot accept, preview, or see the HIT in their search results). It's possible for you to create a HIT with multiple QualificationRequirements (which can have different values for the ActionGuarded attribute). In this case, the Worker is only permitted to perform an action when they have met all QualificationRequirements guarding the action. The actions in the order of least restrictive to most restrictive are Discover, Preview and Accept. For example, if a Worker meets all QualificationRequirements that are set to DiscoverPreviewAndAccept, but do not meet all requirements that are set with PreviewAndAccept, then the Worker will be able to Discover, i.e. see the HIT in their search result, but will not be able to Preview or Accept the HIT. ActionsGuarded should not be used in combination with the `RequiredToPreview` field.
         */
        public var actionsGuarded: aws.sdk.kotlin.services.mturk.model.HitAccessActions? = null
        /**
         * The kind of comparison to make against a Qualification's value. You can compare a Qualification's value to an IntegerValue to see if it is LessThan, LessThanOrEqualTo, GreaterThan, GreaterThanOrEqualTo, EqualTo, or NotEqualTo the IntegerValue. You can compare it to a LocaleValue to see if it is EqualTo, or NotEqualTo the LocaleValue. You can check to see if the value is In or NotIn a set of IntegerValue or LocaleValue values. Lastly, a Qualification requirement can also test if a Qualification Exists or DoesNotExist in the user's profile, regardless of its value.
         */
        public var comparator: aws.sdk.kotlin.services.mturk.model.Comparator? = null
        /**
         * The integer value to compare against the Qualification's value. IntegerValue must not be present if Comparator is Exists or DoesNotExist. IntegerValue can only be used if the Qualification type has an integer value; it cannot be used with the Worker_Locale QualificationType ID. When performing a set comparison by using the In or the NotIn comparator, you can use up to 15 IntegerValue elements in a QualificationRequirement data structure.
         */
        public var integerValues: List<Int>? = null
        /**
         * The locale value to compare against the Qualification's value. The local value must be a valid ISO 3166 country code or supports ISO 3166-2 subdivisions. LocaleValue can only be used with a Worker_Locale QualificationType ID. LocaleValue can only be used with the EqualTo, NotEqualTo, In, and NotIn comparators. You must only use a single LocaleValue element when using the EqualTo or NotEqualTo comparators. When performing a set comparison by using the In or the NotIn comparator, you can use up to 30 LocaleValue elements in a QualificationRequirement data structure.
         */
        public var localeValues: List<Locale>? = null
        /**
         * The ID of the Qualification type for the requirement.
         */
        public var qualificationTypeId: kotlin.String? = null
        /**
         * DEPRECATED: Use the `ActionsGuarded` field instead. If RequiredToPreview is true, the question data for the HIT will not be shown when a Worker whose Qualifications do not meet this requirement tries to preview the HIT. That is, a Worker's Qualifications must meet all of the requirements for which RequiredToPreview is true in order to preview the HIT. If a Worker meets all of the requirements where RequiredToPreview is true (or if there are no such requirements), but does not meet all of the requirements for the HIT, the Worker will be allowed to preview the HIT's question data, but will not be allowed to accept and complete the HIT. The default is false. This should not be used in combination with the `ActionsGuarded` field.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var requiredToPreview: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.QualificationRequirement) : this() {
            this.actionsGuarded = x.actionsGuarded
            this.comparator = x.comparator
            this.integerValues = x.integerValues
            this.localeValues = x.localeValues
            this.qualificationTypeId = x.qualificationTypeId
            this.requiredToPreview = x.requiredToPreview
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.QualificationRequirement = QualificationRequirement(this)
    }
}
