// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The QualificationType data structure represents a Qualification type, a description of a property of a Worker that must match the requirements of a HIT for the Worker to be able to accept the HIT. The type also describes how a Worker can obtain a Qualification of that type, such as through a Qualification test.
 */
public class QualificationType private constructor(builder: Builder) {
    /**
     * The answers to the Qualification test specified in the Test parameter.
     */
    public val answerKey: kotlin.String? = builder.answerKey
    /**
     * Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Valid values are True | False.
     */
    public val autoGranted: kotlin.Boolean? = builder.autoGranted
    /**
     * The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This is 1 by default.
     */
    public val autoGrantedValue: kotlin.Int? = builder.autoGrantedValue
    /**
     * The date and time the Qualification type was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A long description for the Qualification type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned automatically by the system. Valid values are True | False.
     */
    public val isRequestable: kotlin.Boolean? = builder.isRequestable
    /**
     * One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the type easier to find using a search.
     */
    public val keywords: kotlin.String? = builder.keywords
    /**
     * The name of the Qualification type. The type name is used to identify the type, and to find the type using a Qualification type search.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when you call the CreateQualificationType operation.
     */
    public val qualificationTypeId: kotlin.String? = builder.qualificationTypeId
    /**
     * The status of the Qualification type. A Qualification type's status determines if users can apply to receive a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are Active | Inactive.
     */
    public val qualificationTypeStatus: aws.sdk.kotlin.services.mturk.model.QualificationTypeStatus? = builder.qualificationTypeStatus
    /**
     * The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a previous attempt, or if the test offers a gradient score and they want a better score. If not specified, retries are disabled and Workers can request a Qualification only once.
     */
    public val retryDelayInSeconds: kotlin.Long? = builder.retryDelayInSeconds
    /**
     * The questions for a Qualification test associated with this Qualification type that a user can take to obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type cannot have both a specified Test parameter and an AutoGranted value of true.
     */
    public val test: kotlin.String? = builder.test
    /**
     * The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time the Worker requests the Qualification.
     */
    public val testDurationInSeconds: kotlin.Long? = builder.testDurationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.QualificationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QualificationType(")
        append("answerKey=$answerKey,")
        append("autoGranted=$autoGranted,")
        append("autoGrantedValue=$autoGrantedValue,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("isRequestable=$isRequestable,")
        append("keywords=$keywords,")
        append("name=$name,")
        append("qualificationTypeId=$qualificationTypeId,")
        append("qualificationTypeStatus=$qualificationTypeStatus,")
        append("retryDelayInSeconds=$retryDelayInSeconds,")
        append("test=$test,")
        append("testDurationInSeconds=$testDurationInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = answerKey?.hashCode() ?: 0
        result = 31 * result + (autoGranted?.hashCode() ?: 0)
        result = 31 * result + (autoGrantedValue ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isRequestable?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeId?.hashCode() ?: 0)
        result = 31 * result + (qualificationTypeStatus?.hashCode() ?: 0)
        result = 31 * result + (retryDelayInSeconds?.hashCode() ?: 0)
        result = 31 * result + (test?.hashCode() ?: 0)
        result = 31 * result + (testDurationInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QualificationType

        if (answerKey != other.answerKey) return false
        if (autoGranted != other.autoGranted) return false
        if (autoGrantedValue != other.autoGrantedValue) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (isRequestable != other.isRequestable) return false
        if (keywords != other.keywords) return false
        if (name != other.name) return false
        if (qualificationTypeId != other.qualificationTypeId) return false
        if (qualificationTypeStatus != other.qualificationTypeStatus) return false
        if (retryDelayInSeconds != other.retryDelayInSeconds) return false
        if (test != other.test) return false
        if (testDurationInSeconds != other.testDurationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.QualificationType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The answers to the Qualification test specified in the Test parameter.
         */
        public var answerKey: kotlin.String? = null
        /**
         * Specifies that requests for the Qualification type are granted immediately, without prompting the Worker with a Qualification test. Valid values are True | False.
         */
        public var autoGranted: kotlin.Boolean? = null
        /**
         * The Qualification integer value to use for automatically granted Qualifications, if AutoGranted is true. This is 1 by default.
         */
        public var autoGrantedValue: kotlin.Int? = null
        /**
         * The date and time the Qualification type was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A long description for the Qualification type.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether the Qualification type is one that a user can request through the Amazon Mechanical Turk web site, such as by taking a Qualification test. This value is False for Qualifications assigned automatically by the system. Valid values are True | False.
         */
        public var isRequestable: kotlin.Boolean? = null
        /**
         * One or more words or phrases that describe theQualification type, separated by commas. The Keywords make the type easier to find using a search.
         */
        public var keywords: kotlin.String? = null
        /**
         * The name of the Qualification type. The type name is used to identify the type, and to find the type using a Qualification type search.
         */
        public var name: kotlin.String? = null
        /**
         * A unique identifier for the Qualification type. A Qualification type is given a Qualification type ID when you call the CreateQualificationType operation.
         */
        public var qualificationTypeId: kotlin.String? = null
        /**
         * The status of the Qualification type. A Qualification type's status determines if users can apply to receive a Qualification of this type, and if HITs can be created with requirements based on this type. Valid values are Active | Inactive.
         */
        public var qualificationTypeStatus: aws.sdk.kotlin.services.mturk.model.QualificationTypeStatus? = null
        /**
         * The amount of time, in seconds, Workers must wait after taking the Qualification test before they can take it again. Workers can take a Qualification test multiple times if they were not granted the Qualification from a previous attempt, or if the test offers a gradient score and they want a better score. If not specified, retries are disabled and Workers can request a Qualification only once.
         */
        public var retryDelayInSeconds: kotlin.Long? = null
        /**
         * The questions for a Qualification test associated with this Qualification type that a user can take to obtain a Qualification of this type. This parameter must be specified if AnswerKey is present. A Qualification type cannot have both a specified Test parameter and an AutoGranted value of true.
         */
        public var test: kotlin.String? = null
        /**
         * The amount of time, in seconds, given to a Worker to complete the Qualification test, beginning from the time the Worker requests the Qualification.
         */
        public var testDurationInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.QualificationType) : this() {
            this.answerKey = x.answerKey
            this.autoGranted = x.autoGranted
            this.autoGrantedValue = x.autoGrantedValue
            this.creationTime = x.creationTime
            this.description = x.description
            this.isRequestable = x.isRequestable
            this.keywords = x.keywords
            this.name = x.name
            this.qualificationTypeId = x.qualificationTypeId
            this.qualificationTypeStatus = x.qualificationTypeStatus
            this.retryDelayInSeconds = x.retryDelayInSeconds
            this.test = x.test
            this.testDurationInSeconds = x.testDurationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.QualificationType = QualificationType(this)
    }
}
