// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Both the AssignmentReviewReport and the HITReviewReport elements contains the ReviewActionDetail data structure. This structure is returned multiple times for each action specified in the Review Policy.
 */
public class ReviewActionDetail private constructor(builder: Builder) {
    /**
     * The unique identifier for the action.
     */
    public val actionId: kotlin.String? = builder.actionId
    /**
     * The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments, emitting results, and deciding which other actions will be necessary.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * The date when the action was completed.
     */
    public val completeTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completeTime
    /**
     * Present only when the Results have a FAILED Status.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * A description of the outcome of the review.
     */
    public val result: kotlin.String? = builder.result
    /**
     * The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
     */
    public val status: aws.sdk.kotlin.services.mturk.model.ReviewActionStatus? = builder.status
    /**
     * The specific HITId or AssignmentID targeted by the action.
     */
    public val targetId: kotlin.String? = builder.targetId
    /**
     * The type of object in TargetId.
     */
    public val targetType: kotlin.String? = builder.targetType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.ReviewActionDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReviewActionDetail(")
        append("actionId=$actionId,")
        append("actionName=$actionName,")
        append("completeTime=$completeTime,")
        append("errorCode=$errorCode,")
        append("result=$result,")
        append("status=$status,")
        append("targetId=$targetId,")
        append("targetType=$targetType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId?.hashCode() ?: 0
        result = 31 * result + (actionName?.hashCode() ?: 0)
        result = 31 * result + (completeTime?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReviewActionDetail

        if (actionId != other.actionId) return false
        if (actionName != other.actionName) return false
        if (completeTime != other.completeTime) return false
        if (errorCode != other.errorCode) return false
        if (result != other.result) return false
        if (status != other.status) return false
        if (targetId != other.targetId) return false
        if (targetType != other.targetType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.ReviewActionDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the action.
         */
        public var actionId: kotlin.String? = null
        /**
         * The nature of the action itself. The Review Policy is responsible for examining the HIT and Assignments, emitting results, and deciding which other actions will be necessary.
         */
        public var actionName: kotlin.String? = null
        /**
         * The date when the action was completed.
         */
        public var completeTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Present only when the Results have a FAILED Status.
         */
        public var errorCode: kotlin.String? = null
        /**
         * A description of the outcome of the review.
         */
        public var result: kotlin.String? = null
        /**
         * The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
         */
        public var status: aws.sdk.kotlin.services.mturk.model.ReviewActionStatus? = null
        /**
         * The specific HITId or AssignmentID targeted by the action.
         */
        public var targetId: kotlin.String? = null
        /**
         * The type of object in TargetId.
         */
        public var targetType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.ReviewActionDetail) : this() {
            this.actionId = x.actionId
            this.actionName = x.actionName
            this.completeTime = x.completeTime
            this.errorCode = x.errorCode
            this.result = x.result
            this.status = x.status
            this.targetId = x.targetId
            this.targetType = x.targetType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.ReviewActionDetail = ReviewActionDetail(this)
    }
}
