// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.model



/**
 * This data structure is returned multiple times for each result specified in the Review Policy.
 */
public class ReviewResultDetail private constructor(builder: Builder) {
    /**
     * A unique identifier of the Review action result.
     */
    public val actionId: kotlin.String? = builder.actionId
    /**
     * Key identifies the particular piece of reviewed information.
     */
    public val key: kotlin.String? = builder.key
    /**
     * Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT.
     */
    public val questionId: kotlin.String? = builder.questionId
    /**
     * The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit results about the Assignment itself.
     */
    public val subjectId: kotlin.String? = builder.subjectId
    /**
     * The type of the object from the SubjectId field.
     */
    public val subjectType: kotlin.String? = builder.subjectType
    /**
     * The values of Key provided by the review policies you have selected.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mturk.model.ReviewResultDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReviewResultDetail(")
        append("actionId=$actionId,")
        append("key=$key,")
        append("questionId=$questionId,")
        append("subjectId=$subjectId,")
        append("subjectType=$subjectType,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (questionId?.hashCode() ?: 0)
        result = 31 * result + (subjectId?.hashCode() ?: 0)
        result = 31 * result + (subjectType?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReviewResultDetail

        if (actionId != other.actionId) return false
        if (key != other.key) return false
        if (questionId != other.questionId) return false
        if (subjectId != other.subjectId) return false
        if (subjectType != other.subjectType) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mturk.model.ReviewResultDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier of the Review action result.
         */
        public var actionId: kotlin.String? = null
        /**
         * Key identifies the particular piece of reviewed information.
         */
        public var key: kotlin.String? = null
        /**
         * Specifies the QuestionId the result is describing. Depending on whether the TargetType is a HIT or Assignment this results could specify multiple values. If TargetType is HIT and QuestionId is absent, then the result describes results of the HIT, including the HIT agreement score. If ObjectType is Assignment and QuestionId is absent, then the result describes the Worker's performance on the HIT.
         */
        public var questionId: kotlin.String? = null
        /**
         * The HITID or AssignmentId about which this result was taken. Note that HIT-level Review Policies will often emit results about both the HIT itself and its Assignments, while Assignment-level review policies generally only emit results about the Assignment itself.
         */
        public var subjectId: kotlin.String? = null
        /**
         * The type of the object from the SubjectId field.
         */
        public var subjectType: kotlin.String? = null
        /**
         * The values of Key provided by the review policies you have selected.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mturk.model.ReviewResultDetail) : this() {
            this.actionId = x.actionId
            this.key = x.key
            this.questionId = x.questionId
            this.subjectId = x.subjectId
            this.subjectType = x.subjectType
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mturk.model.ReviewResultDetail = ReviewResultDetail(this)
    }
}
