// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mturk.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mturk.model.MTurkException
import aws.sdk.kotlin.services.mturk.model.NotifyWorkersFailureStatus
import aws.sdk.kotlin.services.mturk.model.NotifyWorkersResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class NotifyWorkersOperationDeserializer: HttpDeserialize<NotifyWorkersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): NotifyWorkersResponse {
        if (!response.status.isSuccess()) {
            throwNotifyWorkersError(context, response)
        }
        val builder = NotifyWorkersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeNotifyWorkersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwNotifyWorkersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MTurkException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "RequestError" -> RequestErrorDeserializer().deserialize(context, wrappedResponse)
        "ServiceFault" -> ServiceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> MTurkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeNotifyWorkersOperationBody(builder: NotifyWorkersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NOTIFYWORKERSFAILURESTATUSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NotifyWorkersFailureStatuses"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NOTIFYWORKERSFAILURESTATUSES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NOTIFYWORKERSFAILURESTATUSES_DESCRIPTOR.index -> builder.notifyWorkersFailureStatuses =
                    deserializer.deserializeList(NOTIFYWORKERSFAILURESTATUSES_DESCRIPTOR) {
                        val col0 = mutableListOf<NotifyWorkersFailureStatus>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNotifyWorkersFailureStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
