// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.networkfirewall.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.networkfirewall.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is the API Reference for Network Firewall. This guide is for developers who need detailed information about the Network Firewall API actions, data types, and errors.
 * + The REST API requires you to handle connection details, such as calculating signatures, handling request retries, and error handling. For general information about using the Amazon Web Services REST APIs, see [Amazon Web Services APIs](https://docs.aws.amazon.com/general/latest/gr/aws-apis.html). To access Network Firewall using the REST API endpoint: `https://network-firewall.<region>.amazonaws.com `
 * + Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](http://aws.amazon.com/tools/#SDKs).
 * + For descriptions of Network Firewall features, including and step-by-step instructions on how to use them through the Network Firewall console, see the [Network Firewall Developer Guide](https://docs.aws.amazon.com/network-firewall/latest/developerguide/).
 *
 * Network Firewall is a stateful, managed, network firewall and intrusion detection and prevention service for Amazon Virtual Private Cloud (Amazon VPC). With Network Firewall, you can filter traffic at the perimeter of your VPC. This includes filtering traffic going to and coming from an internet gateway, NAT gateway, or over VPN or Direct Connect. Network Firewall uses rules that are compatible with Suricata, a free, open source intrusion detection system (IDS) engine. Network Firewall supports Suricata version 5.0.2. For information about Suricata, see the [Suricata website](https://suricata-ids.org/).
 *
 * You can use Network Firewall to monitor and protect your VPC traffic in a number of ways. The following are just a few examples:
 * + Allow domains or IP addresses for known Amazon Web Services service endpoints, such as Amazon S3, and block all other forms of traffic.
 * + Use custom lists of known bad domains to limit the types of domain names that your applications can access.
 * + Perform deep packet inspection on traffic entering or leaving your VPC.
 * + Use stateful protocol detection to filter protocols like HTTPS, regardless of the port used.
 *
 * To enable Network Firewall for your VPCs, you perform steps in both Amazon VPC and in Network Firewall. For information about using Amazon VPC, see [Amazon VPC User Guide](https://docs.aws.amazon.com/vpc/latest/userguide/).
 *
 * To start using Network Firewall, do the following:
 * + (Optional) If you don't already have a VPC that you want to protect, create it in Amazon VPC.
 * + In Amazon VPC, in each Availability Zone where you want to have a firewall endpoint, create a subnet for the sole use of Network Firewall.
 * + In Network Firewall, create stateless and stateful rule groups, to define the components of the network traffic filtering behavior that you want your firewall to have.
 * + In Network Firewall, create a firewall policy that uses your rule groups and specifies additional default traffic filtering behavior.
 * + In Network Firewall, create a firewall and specify your new firewall policy and VPC subnets. Network Firewall creates a firewall endpoint in each subnet that you specify, with the behavior that's defined in the firewall policy.
 * + In Amazon VPC, use ingress routing enhancements to route traffic through the new firewall endpoints.
 */
interface NetworkFirewallClient : SdkClient {

    override val serviceName: String
        get() = "Network Firewall"
    /**
     * NetworkFirewallClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): NetworkFirewallClient {
            val config = Config.Builder().apply(block).build()
            return DefaultNetworkFirewallClient(config)
        }

        operator fun invoke(config: Config): NetworkFirewallClient = DefaultNetworkFirewallClient(config)

        /**
         * Construct a [NetworkFirewallClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): NetworkFirewallClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultNetworkFirewallClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a FirewallPolicy to a Firewall.
     *
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
     */
    suspend fun associateFirewallPolicy(input: AssociateFirewallPolicyRequest): AssociateFirewallPolicyResponse

    /**
     * Associates a FirewallPolicy to a Firewall.
     *
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
     */
    suspend fun associateFirewallPolicy(block: AssociateFirewallPolicyRequest.Builder.() -> Unit) = associateFirewallPolicy(AssociateFirewallPolicyRequest.Builder().apply(block).build())

    /**
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans.
     *
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the traffic that's coming into and going out of the zone through the firewall endpoint.
     */
    suspend fun associateSubnets(input: AssociateSubnetsRequest): AssociateSubnetsResponse

    /**
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans.
     *
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the traffic that's coming into and going out of the zone through the firewall endpoint.
     */
    suspend fun associateSubnets(block: AssociateSubnetsRequest.Builder.() -> Unit) = associateSubnets(AssociateSubnetsRequest.Builder().apply(block).build())

    /**
     * Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
     *
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource.
     *
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     *
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets, and UpdateFirewallDeleteProtection.
     *
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations, ListTagsForResource, TagResource, and UntagResource.
     *
     * To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
     */
    suspend fun createFirewall(input: CreateFirewallRequest): CreateFirewallResponse

    /**
     * Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
     *
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and any tags that are attached to the firewall Amazon Web Services resource.
     *
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     *
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets, and UpdateFirewallDeleteProtection.
     *
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations, ListTagsForResource, TagResource, and UntagResource.
     *
     * To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
     */
    suspend fun createFirewall(block: CreateFirewallRequest.Builder.() -> Unit) = createFirewall(CreateFirewallRequest.Builder().apply(block).build())

    /**
     * Creates the firewall policy for the firewall according to the specifications.
     *
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls.
     */
    suspend fun createFirewallPolicy(input: CreateFirewallPolicyRequest): CreateFirewallPolicyResponse

    /**
     * Creates the firewall policy for the firewall according to the specifications.
     *
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls.
     */
    suspend fun createFirewallPolicy(block: CreateFirewallPolicyRequest.Builder.() -> Unit) = createFirewallPolicy(CreateFirewallPolicyRequest.Builder().apply(block).build())

    /**
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.
     *
     * You provide your rule group specification in your request using either `RuleGroup` or `Rules`.
     */
    suspend fun createRuleGroup(input: CreateRuleGroupRequest): CreateRuleGroupResponse

    /**
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.
     *
     * You provide your rule group specification in your request using either `RuleGroup` or `Rules`.
     */
    suspend fun createRuleGroup(block: CreateRuleGroupRequest.Builder.() -> Unit) = createRuleGroup(CreateRuleGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified Firewall and its FirewallStatus. This operation requires the firewall's `DeleteProtection` flag to be `FALSE`. You can't revert this operation.
     *
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you have firewall subnet mappings. Retrieve the subnet mappings by calling DescribeFirewall. You define and update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall safely.
     *
     * To delete a firewall, remove the delete protection if you need to using UpdateFirewallDeleteProtection, then delete the firewall by calling DeleteFirewall.
     */
    suspend fun deleteFirewall(input: DeleteFirewallRequest = DeleteFirewallRequest {}): DeleteFirewallResponse

    /**
     * Deletes the specified Firewall and its FirewallStatus. This operation requires the firewall's `DeleteProtection` flag to be `FALSE`. You can't revert this operation.
     *
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you have firewall subnet mappings. Retrieve the subnet mappings by calling DescribeFirewall. You define and update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall safely.
     *
     * To delete a firewall, remove the delete protection if you need to using UpdateFirewallDeleteProtection, then delete the firewall by calling DeleteFirewall.
     */
    suspend fun deleteFirewall(block: DeleteFirewallRequest.Builder.() -> Unit) = deleteFirewall(DeleteFirewallRequest.Builder().apply(block).build())

    /**
     * Deletes the specified FirewallPolicy.
     */
    suspend fun deleteFirewallPolicy(input: DeleteFirewallPolicyRequest = DeleteFirewallPolicyRequest {}): DeleteFirewallPolicyResponse

    /**
     * Deletes the specified FirewallPolicy.
     */
    suspend fun deleteFirewallPolicy(block: DeleteFirewallPolicyRequest.Builder.() -> Unit) = deleteFirewallPolicy(DeleteFirewallPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes a resource policy that you created in a PutResourcePolicy request.
     */
    suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a resource policy that you created in a PutResourcePolicy request.
     */
    suspend fun deleteResourcePolicy(block: DeleteResourcePolicyRequest.Builder.() -> Unit) = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified RuleGroup.
     */
    suspend fun deleteRuleGroup(input: DeleteRuleGroupRequest = DeleteRuleGroupRequest {}): DeleteRuleGroupResponse

    /**
     * Deletes the specified RuleGroup.
     */
    suspend fun deleteRuleGroup(block: DeleteRuleGroupRequest.Builder.() -> Unit) = deleteRuleGroup(DeleteRuleGroupRequest.Builder().apply(block).build())

    /**
     * Returns the data objects for the specified firewall.
     */
    suspend fun describeFirewall(input: DescribeFirewallRequest = DescribeFirewallRequest {}): DescribeFirewallResponse

    /**
     * Returns the data objects for the specified firewall.
     */
    suspend fun describeFirewall(block: DescribeFirewallRequest.Builder.() -> Unit) = describeFirewall(DescribeFirewallRequest.Builder().apply(block).build())

    /**
     * Returns the data objects for the specified firewall policy.
     */
    suspend fun describeFirewallPolicy(input: DescribeFirewallPolicyRequest = DescribeFirewallPolicyRequest {}): DescribeFirewallPolicyResponse

    /**
     * Returns the data objects for the specified firewall policy.
     */
    suspend fun describeFirewallPolicy(block: DescribeFirewallPolicyRequest.Builder.() -> Unit) = describeFirewallPolicy(DescribeFirewallPolicyRequest.Builder().apply(block).build())

    /**
     * Returns the logging configuration for the specified firewall.
     */
    suspend fun describeLoggingConfiguration(input: DescribeLoggingConfigurationRequest = DescribeLoggingConfigurationRequest {}): DescribeLoggingConfigurationResponse

    /**
     * Returns the logging configuration for the specified firewall.
     */
    suspend fun describeLoggingConfiguration(block: DescribeLoggingConfigurationRequest.Builder.() -> Unit) = describeLoggingConfiguration(DescribeLoggingConfigurationRequest.Builder().apply(block).build())

    /**
     * Retrieves a resource policy that you created in a PutResourcePolicy request.
     */
    suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse

    /**
     * Retrieves a resource policy that you created in a PutResourcePolicy request.
     */
    suspend fun describeResourcePolicy(block: DescribeResourcePolicyRequest.Builder.() -> Unit) = describeResourcePolicy(DescribeResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Returns the data objects for the specified rule group.
     */
    suspend fun describeRuleGroup(input: DescribeRuleGroupRequest = DescribeRuleGroupRequest {}): DescribeRuleGroupResponse

    /**
     * Returns the data objects for the specified rule group.
     */
    suspend fun describeRuleGroup(block: DescribeRuleGroupRequest.Builder.() -> Unit) = describeRuleGroup(DescribeRuleGroupRequest.Builder().apply(block).build())

    /**
     * High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
     */
    suspend fun describeRuleGroupMetadata(input: DescribeRuleGroupMetadataRequest = DescribeRuleGroupMetadataRequest {}): DescribeRuleGroupMetadataResponse

    /**
     * High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
     */
    suspend fun describeRuleGroupMetadata(block: DescribeRuleGroupMetadataRequest.Builder.() -> Unit) = describeRuleGroupMetadata(DescribeRuleGroupMetadataRequest.Builder().apply(block).build())

    /**
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing.
     */
    suspend fun disassociateSubnets(input: DisassociateSubnetsRequest): DisassociateSubnetsResponse

    /**
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing.
     */
    suspend fun disassociateSubnets(block: DisassociateSubnetsRequest.Builder.() -> Unit) = disassociateSubnets(DisassociateSubnetsRequest.Builder().apply(block).build())

    /**
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list.
     */
    suspend fun listFirewallPolicies(input: ListFirewallPoliciesRequest = ListFirewallPoliciesRequest {}): ListFirewallPoliciesResponse

    /**
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list.
     */
    suspend fun listFirewallPolicies(block: ListFirewallPoliciesRequest.Builder.() -> Unit) = listFirewallPolicies(ListFirewallPoliciesRequest.Builder().apply(block).build())

    /**
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.
     *
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full list.
     */
    suspend fun listFirewalls(input: ListFirewallsRequest = ListFirewallsRequest {}): ListFirewallsResponse

    /**
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.
     *
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full list.
     */
    suspend fun listFirewalls(block: ListFirewallsRequest.Builder.() -> Unit) = listFirewalls(ListFirewallsRequest.Builder().apply(block).build())

    /**
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.
     */
    suspend fun listRuleGroups(input: ListRuleGroupsRequest = ListRuleGroupsRequest {}): ListRuleGroupsResponse

    /**
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.
     */
    suspend fun listRuleGroups(block: ListRuleGroupsRequest.Builder.() -> Unit) = listRuleGroups(ListRuleGroupsRequest.Builder().apply(block).build())

    /**
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.
     *
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform.
     *
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy.
     * + [GetResourceShareInvitations](https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html) - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * + [AcceptResourceShareInvitation](https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html) - Accepts the share invitation for a specified resource share.
     *
     * For additional information about resource sharing using RAM, see [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html).
     */
    suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.
     *
     * Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform.
     *
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy.
     * + [GetResourceShareInvitations](https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html) - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * + [AcceptResourceShareInvitation](https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html) - Accepts the share invitation for a specified resource share.
     *
     * For additional information about resource sharing using RAM, see [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html).
     */
    suspend fun putResourcePolicy(block: PutResourcePolicyRequest.Builder.() -> Unit) = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall policies, and rule groups.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Modifies the flag, `DeleteProtection`, which indicates whether it is possible to delete the firewall. If the flag is set to `TRUE`, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use.
     */
    suspend fun updateFirewallDeleteProtection(input: UpdateFirewallDeleteProtectionRequest): UpdateFirewallDeleteProtectionResponse

    /**
     * Modifies the flag, `DeleteProtection`, which indicates whether it is possible to delete the firewall. If the flag is set to `TRUE`, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use.
     */
    suspend fun updateFirewallDeleteProtection(block: UpdateFirewallDeleteProtectionRequest.Builder.() -> Unit) = updateFirewallDeleteProtection(UpdateFirewallDeleteProtectionRequest.Builder().apply(block).build())

    /**
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when you're working with it.
     */
    suspend fun updateFirewallDescription(input: UpdateFirewallDescriptionRequest = UpdateFirewallDescriptionRequest {}): UpdateFirewallDescriptionResponse

    /**
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when you're working with it.
     */
    suspend fun updateFirewallDescription(block: UpdateFirewallDescriptionRequest.Builder.() -> Unit) = updateFirewallDescription(UpdateFirewallDescriptionRequest.Builder().apply(block).build())

    /**
     * A complex type that contains settings for encryption of your firewall resources.
     */
    suspend fun updateFirewallEncryptionConfiguration(input: UpdateFirewallEncryptionConfigurationRequest = UpdateFirewallEncryptionConfigurationRequest {}): UpdateFirewallEncryptionConfigurationResponse

    /**
     * A complex type that contains settings for encryption of your firewall resources.
     */
    suspend fun updateFirewallEncryptionConfiguration(block: UpdateFirewallEncryptionConfigurationRequest.Builder.() -> Unit) = updateFirewallEncryptionConfiguration(UpdateFirewallEncryptionConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the properties of the specified firewall policy.
     */
    suspend fun updateFirewallPolicy(input: UpdateFirewallPolicyRequest): UpdateFirewallPolicyResponse

    /**
     * Updates the properties of the specified firewall policy.
     */
    suspend fun updateFirewallPolicy(block: UpdateFirewallPolicyRequest.Builder.() -> Unit) = updateFirewallPolicy(UpdateFirewallPolicyRequest.Builder().apply(block).build())

    /**
     * Modifies the flag, `ChangeProtection`, which indicates whether it is possible to change the firewall. If the flag is set to `TRUE`, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that's in use.
     */
    suspend fun updateFirewallPolicyChangeProtection(input: UpdateFirewallPolicyChangeProtectionRequest): UpdateFirewallPolicyChangeProtectionResponse

    /**
     * Modifies the flag, `ChangeProtection`, which indicates whether it is possible to change the firewall. If the flag is set to `TRUE`, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that's in use.
     */
    suspend fun updateFirewallPolicyChangeProtection(block: UpdateFirewallPolicyChangeProtectionRequest.Builder.() -> Unit) = updateFirewallPolicyChangeProtection(UpdateFirewallPolicyChangeProtectionRequest.Builder().apply(block).build())

    /**
     * Sets the logging configuration for the specified firewall.
     *
     * To change the logging configuration, retrieve the LoggingConfiguration by calling DescribeLoggingConfiguration, then change it and provide the modified object to this update call. You must change the logging configuration one LogDestinationConfig at a time inside the retrieved LoggingConfiguration object.
     *
     * You can perform only one of the following actions in any call to `UpdateLoggingConfiguration`:
     * + Create a new log destination object by adding a single `LogDestinationConfig` array element to `LogDestinationConfigs`.
     * + Delete a log destination object by removing a single `LogDestinationConfig` array element from `LogDestinationConfigs`.
     * + Change the `LogDestination` setting in a single `LogDestinationConfig` array element.
     *
     * You can't change the `LogDestinationType` or `LogType` in a `LogDestinationConfig`. To change these settings, delete the existing `LogDestinationConfig` object and create a new one, using two separate calls to this update operation.
     */
    suspend fun updateLoggingConfiguration(input: UpdateLoggingConfigurationRequest = UpdateLoggingConfigurationRequest {}): UpdateLoggingConfigurationResponse

    /**
     * Sets the logging configuration for the specified firewall.
     *
     * To change the logging configuration, retrieve the LoggingConfiguration by calling DescribeLoggingConfiguration, then change it and provide the modified object to this update call. You must change the logging configuration one LogDestinationConfig at a time inside the retrieved LoggingConfiguration object.
     *
     * You can perform only one of the following actions in any call to `UpdateLoggingConfiguration`:
     * + Create a new log destination object by adding a single `LogDestinationConfig` array element to `LogDestinationConfigs`.
     * + Delete a log destination object by removing a single `LogDestinationConfig` array element from `LogDestinationConfigs`.
     * + Change the `LogDestination` setting in a single `LogDestinationConfig` array element.
     *
     * You can't change the `LogDestinationType` or `LogType` in a `LogDestinationConfig`. To change these settings, delete the existing `LogDestinationConfig` object and create a new one, using two separate calls to this update operation.
     */
    suspend fun updateLoggingConfiguration(block: UpdateLoggingConfigurationRequest.Builder.() -> Unit) = updateLoggingConfiguration(UpdateLoggingConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     *
     * To update a rule group, first call DescribeRuleGroup to retrieve the current RuleGroup object, update the object as needed, and then provide the updated object to this call.
     */
    suspend fun updateRuleGroup(input: UpdateRuleGroupRequest): UpdateRuleGroupResponse

    /**
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     *
     * To update a rule group, first call DescribeRuleGroup to retrieve the current RuleGroup object, update the object as needed, and then provide the updated object to this call.
     */
    suspend fun updateRuleGroup(block: UpdateRuleGroupRequest.Builder.() -> Unit) = updateRuleGroup(UpdateRuleGroupRequest.Builder().apply(block).build())

    /**
     *
     */
    suspend fun updateSubnetChangeProtection(input: UpdateSubnetChangeProtectionRequest): UpdateSubnetChangeProtectionResponse

    /**
     *
     */
    suspend fun updateSubnetChangeProtection(block: UpdateSubnetChangeProtectionRequest.Builder.() -> Unit) = updateSubnetChangeProtection(UpdateSubnetChangeProtectionRequest.Builder().apply(block).build())
}
