// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Detailed information about the current status of a Firewall. You can retrieve this for a firewall by calling DescribeFirewall and providing the firewall name and ARN.
 */
class FirewallStatus private constructor(builder: Builder) {
    /**
     * The configuration sync state for the firewall. This summarizes the sync states reported in the `Config` settings for all of the Availability Zones where you have configured the firewall.
     *
     * When you create a firewall or update its configuration, for example by adding a rule group to its firewall policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use. This summary indicates whether the configuration changes have been applied everywhere.
     *
     * This status must be `IN_SYNC` for the firewall to be ready for use, but it doesn't indicate that the firewall is ready. The `Status` setting indicates firewall readiness.
     */
    val configurationSyncStateSummary: aws.sdk.kotlin.services.networkfirewall.model.ConfigurationSyncState? = builder.configurationSyncStateSummary
    /**
     * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where you've configured it. This setting is `READY` only when the `ConfigurationSyncStateSummary` value is `IN_SYNC` and the `Attachment``Status` values for all of the configured subnets are `READY`.
     */
    val status: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatusValue? = builder.status
    /**
     * The subnets that you've configured for use by the Network Firewall firewall. This contains one array element per Availability Zone where you've configured a subnet. These objects provide details of the information that is summarized in the `ConfigurationSyncStateSummary` and `Status`, broken down by zone and configuration object.
     */
    val syncStates: Map<String, SyncState>? = builder.syncStates

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallStatus(")
        append("configurationSyncStateSummary=$configurationSyncStateSummary,")
        append("status=$status,")
        append("syncStates=$syncStates)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationSyncStateSummary?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (syncStates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallStatus

        if (configurationSyncStateSummary != other.configurationSyncStateSummary) return false
        if (status != other.status) return false
        if (syncStates != other.syncStates) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * The configuration sync state for the firewall. This summarizes the sync states reported in the `Config` settings for all of the Availability Zones where you have configured the firewall.
         *
         * When you create a firewall or update its configuration, for example by adding a rule group to its firewall policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use. This summary indicates whether the configuration changes have been applied everywhere.
         *
         * This status must be `IN_SYNC` for the firewall to be ready for use, but it doesn't indicate that the firewall is ready. The `Status` setting indicates firewall readiness.
         */
        var configurationSyncStateSummary: aws.sdk.kotlin.services.networkfirewall.model.ConfigurationSyncState? = null
        /**
         * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where you've configured it. This setting is `READY` only when the `ConfigurationSyncStateSummary` value is `IN_SYNC` and the `Attachment``Status` values for all of the configured subnets are `READY`.
         */
        var status: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatusValue? = null
        /**
         * The subnets that you've configured for use by the Network Firewall firewall. This contains one array element per Availability Zone where you've configured a subnet. These objects provide details of the information that is summarized in the `ConfigurationSyncStateSummary` and `Status`, broken down by zone and configuration object.
         */
        var syncStates: Map<String, SyncState>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus) : this() {
            this.configurationSyncStateSummary = x.configurationSyncStateSummary
            this.status = x.status
            this.syncStates = x.syncStates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus = FirewallStatus(this)
    }
}
