// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



class ListTagsForResourceRequest private constructor(builder: Builder) {
    /**
     * The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTagsForResourceRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTagsForResourceRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
         */
        var maxResults: kotlin.Int? = null
        /**
         * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
         */
        var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest = ListTagsForResourceRequest(this)
    }
}
