// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
 */
class MatchAttributes private constructor(builder: Builder) {
    /**
     * The destination ports to inspect for. If not specified, this matches with any destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP).
     *
     * You can specify individual ports, for example `1994` and you can specify port ranges, for example `1990:1994`.
     */
    val destinationPorts: List<PortRange>? = builder.destinationPorts
    /**
     * The destination IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address.
     */
    val destinations: List<Address>? = builder.destinations
    /**
     * The protocols to inspect for, specified using each protocol's assigned internet protocol number (IANA). If not specified, this matches with any protocol.
     */
    val protocols: List<Int>? = builder.protocols
    /**
     * The source ports to inspect for. If not specified, this matches with any source port. This setting is only used for protocols 6 (TCP) and 17 (UDP).
     *
     * You can specify individual ports, for example `1994` and you can specify port ranges, for example `1990:1994`.
     */
    val sourcePorts: List<PortRange>? = builder.sourcePorts
    /**
     * The source IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address.
     */
    val sources: List<Address>? = builder.sources
    /**
     * The TCP flags and masks to inspect for. If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).
     */
    val tcpFlags: List<TcpFlagField>? = builder.tcpFlags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MatchAttributes(")
        append("destinationPorts=$destinationPorts,")
        append("destinations=$destinations,")
        append("protocols=$protocols,")
        append("sourcePorts=$sourcePorts,")
        append("sources=$sources,")
        append("tcpFlags=$tcpFlags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationPorts?.hashCode() ?: 0
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (sourcePorts?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (tcpFlags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MatchAttributes

        if (destinationPorts != other.destinationPorts) return false
        if (destinations != other.destinations) return false
        if (protocols != other.protocols) return false
        if (sourcePorts != other.sourcePorts) return false
        if (sources != other.sources) return false
        if (tcpFlags != other.tcpFlags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * The destination ports to inspect for. If not specified, this matches with any destination port. This setting is only used for protocols 6 (TCP) and 17 (UDP).
         *
         * You can specify individual ports, for example `1994` and you can specify port ranges, for example `1990:1994`.
         */
        var destinationPorts: List<PortRange>? = null
        /**
         * The destination IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address.
         */
        var destinations: List<Address>? = null
        /**
         * The protocols to inspect for, specified using each protocol's assigned internet protocol number (IANA). If not specified, this matches with any protocol.
         */
        var protocols: List<Int>? = null
        /**
         * The source ports to inspect for. If not specified, this matches with any source port. This setting is only used for protocols 6 (TCP) and 17 (UDP).
         *
         * You can specify individual ports, for example `1994` and you can specify port ranges, for example `1990:1994`.
         */
        var sourcePorts: List<PortRange>? = null
        /**
         * The source IP addresses and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address.
         */
        var sources: List<Address>? = null
        /**
         * The TCP flags and masks to inspect for. If not specified, this matches with any settings. This setting is only used for protocol 6 (TCP).
         */
        var tcpFlags: List<TcpFlagField>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes) : this() {
            this.destinationPorts = x.destinationPorts
            this.destinations = x.destinations
            this.protocols = x.protocols
            this.sourcePorts = x.sourcePorts
            this.sources = x.sources
            this.tcpFlags = x.tcpFlags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes = MatchAttributes(this)
    }
}
