// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * The object that defines the rules in a rule group. This, along with RuleGroupResponse, define the rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
 *
 * Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups to inspect individual packets and you define stateful rule groups to inspect packets in the context of their traffic flow.
 *
 * To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use a firewall policy in more than one firewall.
 */
class RuleGroup private constructor(builder: Builder) {
    /**
     * Settings that are available for use in the rules in the rule group. You can only use these for stateful rule groups.
     */
    val ruleVariables: aws.sdk.kotlin.services.networkfirewall.model.RuleVariables? = builder.ruleVariables
    /**
     * The stateful rules or stateless rules for the rule group.
     */
    val rulesSource: aws.sdk.kotlin.services.networkfirewall.model.RulesSource? = builder.rulesSource
    /**
     * Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings.
     */
    val statefulRuleOptions: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions? = builder.statefulRuleOptions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.RuleGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroup(")
        append("ruleVariables=$ruleVariables,")
        append("rulesSource=$rulesSource,")
        append("statefulRuleOptions=$statefulRuleOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ruleVariables?.hashCode() ?: 0
        result = 31 * result + (rulesSource?.hashCode() ?: 0)
        result = 31 * result + (statefulRuleOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroup

        if (ruleVariables != other.ruleVariables) return false
        if (rulesSource != other.rulesSource) return false
        if (statefulRuleOptions != other.statefulRuleOptions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.RuleGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * Settings that are available for use in the rules in the rule group. You can only use these for stateful rule groups.
         */
        var ruleVariables: aws.sdk.kotlin.services.networkfirewall.model.RuleVariables? = null
        /**
         * The stateful rules or stateless rules for the rule group.
         */
        var rulesSource: aws.sdk.kotlin.services.networkfirewall.model.RulesSource? = null
        /**
         * Additional options governing how Network Firewall handles stateful rules. The policies where you use your stateful rule group must have stateful rule options settings that are compatible with these settings.
         */
        var statefulRuleOptions: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.RuleGroup) : this() {
            this.ruleVariables = x.ruleVariables
            this.rulesSource = x.rulesSource
            this.statefulRuleOptions = x.statefulRuleOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.RuleGroup = RuleGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.RuleVariables] inside the given [block]
         */
        fun ruleVariables(block: aws.sdk.kotlin.services.networkfirewall.model.RuleVariables.Builder.() -> kotlin.Unit) {
            this.ruleVariables = aws.sdk.kotlin.services.networkfirewall.model.RuleVariables.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.RulesSource] inside the given [block]
         */
        fun rulesSource(block: aws.sdk.kotlin.services.networkfirewall.model.RulesSource.Builder.() -> kotlin.Unit) {
            this.rulesSource = aws.sdk.kotlin.services.networkfirewall.model.RulesSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions] inside the given [block]
         */
        fun statefulRuleOptions(block: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions.Builder.() -> kotlin.Unit) {
            this.statefulRuleOptions = aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions.invoke(block)
        }
    }
}
