// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Identifier for a single stateful rule group, used in a firewall policy to refer to a rule group.
 */
class StatefulRuleGroupReference private constructor(builder: Builder) {
    /**
     * The action that allows the policy owner to override the behavior of the rule group within a policy.
     */
    val override: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupOverride? = builder.override
    /**
     * An integer setting that indicates the order in which to run the stateful rule groups in a single FirewallPolicy. This setting only applies to firewall policies that specify the `STRICT_ORDER` rule order in the stateful engine options settings.
     *
     * Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
     *
     * You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the stateful rule group.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupReference = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatefulRuleGroupReference(")
        append("override=$override,")
        append("priority=$priority,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = override?.hashCode() ?: 0
        result = 31 * result + (priority)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatefulRuleGroupReference

        if (override != other.override) return false
        if (priority != other.priority) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupReference = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action that allows the policy owner to override the behavior of the rule group within a policy.
         */
        var override: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupOverride? = null
        /**
         * An integer setting that indicates the order in which to run the stateful rule groups in a single FirewallPolicy. This setting only applies to firewall policies that specify the `STRICT_ORDER` rule order in the stateful engine options settings.
         *
         * Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
         *
         * You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
         */
        var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the stateful rule group.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupReference) : this() {
            this.override = x.override
            this.priority = x.priority
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupReference = StatefulRuleGroupReference(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupOverride] inside the given [block]
         */
        fun override(block: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupOverride.Builder.() -> kotlin.Unit) {
            this.override = aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleGroupOverride.invoke(block)
        }
    }
}
