// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Identifier for a single stateless rule group, used in a firewall policy to refer to the rule group.
 */
class StatelessRuleGroupReference private constructor(builder: Builder) {
    /**
     * An integer setting that indicates the order in which to run the stateless rule groups in a single FirewallPolicy. Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the stateless rule group.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.StatelessRuleGroupReference = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatelessRuleGroupReference(")
        append("priority=$priority,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = priority
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatelessRuleGroupReference

        if (priority != other.priority) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.StatelessRuleGroupReference = Builder(this).apply(block).build()

    class Builder {
        /**
         * An integer setting that indicates the order in which to run the stateless rule groups in a single FirewallPolicy. Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
         */
        var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the stateless rule group.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.StatelessRuleGroupReference) : this() {
            this.priority = x.priority
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.StatelessRuleGroupReference = StatelessRuleGroupReference(this)
    }
}
