// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



class UpdateFirewallPolicyRequest private constructor(builder: Builder) {
    /**
     * A description of the firewall policy.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
     *
     * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
     *
     * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
     */
    val dryRun: kotlin.Boolean = builder.dryRun
    /**
     * A complex type that contains settings for encryption of your firewall policy resources.
     */
    val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The updated firewall policy to use for the firewall.
     */
    val firewallPolicy: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy? = builder.firewallPolicy
    /**
     * The Amazon Resource Name (ARN) of the firewall policy.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    val firewallPolicyArn: kotlin.String? = builder.firewallPolicyArn
    /**
     * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    val firewallPolicyName: kotlin.String? = builder.firewallPolicyName
    /**
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request.
     *
     * To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token.
     */
    val updateToken: kotlin.String? = builder.updateToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFirewallPolicyRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("firewallPolicy=$firewallPolicy,")
        append("firewallPolicyArn=$firewallPolicyArn,")
        append("firewallPolicyName=$firewallPolicyName,")
        append("updateToken=$updateToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun.hashCode())
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicy?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyName?.hashCode() ?: 0)
        result = 31 * result + (updateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFirewallPolicyRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (firewallPolicy != other.firewallPolicy) return false
        if (firewallPolicyArn != other.firewallPolicyArn) return false
        if (firewallPolicyName != other.firewallPolicyName) return false
        if (updateToken != other.updateToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description of the firewall policy.
         */
        var description: kotlin.String? = null
        /**
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
         *
         * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
         *
         * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
         */
        var dryRun: kotlin.Boolean = false
        /**
         * A complex type that contains settings for encryption of your firewall policy resources.
         */
        var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The updated firewall policy to use for the firewall.
         */
        var firewallPolicy: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy? = null
        /**
         * The Amazon Resource Name (ARN) of the firewall policy.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        var firewallPolicyArn: kotlin.String? = null
        /**
         * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        var firewallPolicyName: kotlin.String? = null
        /**
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request.
         *
         * To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token.
         */
        var updateToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.encryptionConfiguration = x.encryptionConfiguration
            this.firewallPolicy = x.firewallPolicy
            this.firewallPolicyArn = x.firewallPolicyArn
            this.firewallPolicyName = x.firewallPolicyName
            this.updateToken = x.updateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyRequest = UpdateFirewallPolicyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy] inside the given [block]
         */
        fun firewallPolicy(block: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy.Builder.() -> kotlin.Unit) {
            this.firewallPolicy = aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy.invoke(block)
        }
    }
}
