// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.paginators

import aws.sdk.kotlin.services.networkfirewall.NetworkFirewallClient
import aws.sdk.kotlin.services.networkfirewall.model.FirewallMetadata
import aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicyMetadata
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallPoliciesRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallPoliciesResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.networkfirewall.model.RuleGroupMetadata
import aws.sdk.kotlin.services.networkfirewall.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListFirewallPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallPoliciesResponse]
 */
fun NetworkFirewallClient.listFirewallPoliciesPaginated(initialRequest: ListFirewallPoliciesRequest): Flow<ListFirewallPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallPoliciesPaginated.listFirewallPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallPoliciesResponse]
 */
fun NetworkFirewallClient.listFirewallPoliciesPaginated(block: ListFirewallPoliciesRequest.Builder.() -> Unit): Flow<ListFirewallPoliciesResponse> =
    listFirewallPoliciesPaginated(ListFirewallPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallPoliciesPaginated]
 * to access the nested member [FirewallPolicyMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallPolicyMetadata]
 */
@JvmName("listFirewallPoliciesResponseFirewallPolicyMetadata")
fun Flow<ListFirewallPoliciesResponse>.firewallPolicies(): Flow<FirewallPolicyMetadata> =
    transform() { response ->
        response.firewallPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFirewallsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallsResponse]
 */
fun NetworkFirewallClient.listFirewallsPaginated(initialRequest: ListFirewallsRequest): Flow<ListFirewallsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallsPaginated.listFirewalls(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallsResponse]
 */
fun NetworkFirewallClient.listFirewallsPaginated(block: ListFirewallsRequest.Builder.() -> Unit): Flow<ListFirewallsResponse> =
    listFirewallsPaginated(ListFirewallsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallsPaginated]
 * to access the nested member [FirewallMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallMetadata]
 */
@JvmName("listFirewallsResponseFirewallMetadata")
fun Flow<ListFirewallsResponse>.firewalls(): Flow<FirewallMetadata> =
    transform() { response ->
        response.firewalls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRuleGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleGroupsResponse]
 */
fun NetworkFirewallClient.listRuleGroupsPaginated(initialRequest: ListRuleGroupsRequest): Flow<ListRuleGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRuleGroupsPaginated.listRuleGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleGroupsResponse]
 */
fun NetworkFirewallClient.listRuleGroupsPaginated(block: ListRuleGroupsRequest.Builder.() -> Unit): Flow<ListRuleGroupsResponse> =
    listRuleGroupsPaginated(ListRuleGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRuleGroupsPaginated]
 * to access the nested member [RuleGroupMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RuleGroupMetadata]
 */
@JvmName("listRuleGroupsResponseRuleGroupMetadata")
fun Flow<ListRuleGroupsResponse>.ruleGroups(): Flow<RuleGroupMetadata> =
    transform() { response ->
        response.ruleGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun NetworkFirewallClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun NetworkFirewallClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
