// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataResponse
import aws.sdk.kotlin.services.networkfirewall.model.NetworkFirewallException
import aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType
import aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeRuleGroupMetadataOperationDeserializer: HttpDeserialize<DescribeRuleGroupMetadataResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRuleGroupMetadataResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRuleGroupMetadataError(context, response)
        }
        val builder = DescribeRuleGroupMetadataResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRuleGroupMetadataOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeRuleGroupMetadataError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkFirewallException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> NetworkFirewallException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeRuleGroupMetadataOperationBody(builder: DescribeRuleGroupMetadataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Capacity"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val RULEGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuleGroupArn"))
    val RULEGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuleGroupName"))
    val STATEFULRULEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StatefulRuleOptions"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(RULEGROUPARN_DESCRIPTOR)
        field(RULEGROUPNAME_DESCRIPTOR)
        field(STATEFULRULEOPTIONS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPACITY_DESCRIPTOR.index -> builder.capacity = deserializeInt()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                RULEGROUPARN_DESCRIPTOR.index -> builder.ruleGroupArn = deserializeString()
                RULEGROUPNAME_DESCRIPTOR.index -> builder.ruleGroupName = deserializeString()
                STATEFULRULEOPTIONS_DESCRIPTOR.index -> builder.statefulRuleOptions = deserializeStatefulRuleOptionsDocument(deserializer)
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { RuleGroupType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
