// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.networkfirewall.model.LoggingConfiguration
import aws.sdk.kotlin.services.networkfirewall.model.NetworkFirewallException
import aws.sdk.kotlin.services.networkfirewall.model.UpdateLoggingConfigurationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateLoggingConfigurationOperationDeserializer: HttpDeserialize<UpdateLoggingConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateLoggingConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwUpdateLoggingConfigurationError(context, response)
        }
        val builder = UpdateLoggingConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateLoggingConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateLoggingConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkFirewallException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTokenException" -> InvalidTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "LogDestinationPermissionException" -> LogDestinationPermissionExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> NetworkFirewallException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateLoggingConfigurationOperationBody(builder: UpdateLoggingConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FIREWALLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirewallArn"))
    val FIREWALLNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirewallName"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FIREWALLARN_DESCRIPTOR)
        field(FIREWALLNAME_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FIREWALLARN_DESCRIPTOR.index -> builder.firewallArn = deserializeString()
                FIREWALLNAME_DESCRIPTOR.index -> builder.firewallName = deserializeString()
                LOGGINGCONFIGURATION_DESCRIPTOR.index -> builder.loggingConfiguration = deserializeLoggingConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
