// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.opensearch.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.opensearch.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon OpenSearch Configuration Service
 * Use the Amazon OpenSearch configuration API to create, configure, and manage Amazon OpenSearch Service domains.
 *
 * For sample code that uses the configuration API, see the [ Amazon OpenSearch Service Developer Guide](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-configuration-samples.html). The guide also contains [ sample code for sending signed HTTP requests to the OpenSearch APIs](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/request-signing.html).
 *
 * The endpoint for configuration service requests is region-specific: es.*region*.amazonaws.com. For example, es.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see [Regions and Endpoints](http://docs.aws.amazon.com/general/latest/gr/rande.html#service-regions).
 */
interface OpenSearchClient : SdkClient {

    override val serviceName: String
        get() = "OpenSearch"
    /**
     * OpenSearchClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): OpenSearchClient {
            val config = Config.Builder().apply(block).build()
            return DefaultOpenSearchClient(config)
        }

        operator fun invoke(config: Config): OpenSearchClient = DefaultOpenSearchClient(config)

        /**
         * Construct a [OpenSearchClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): OpenSearchClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultOpenSearchClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Allows the remote domain owner to accept an inbound cross-cluster connection request.
     */
    suspend fun acceptInboundConnection(input: AcceptInboundConnectionRequest): AcceptInboundConnectionResponse

    /**
     * Allows the remote domain owner to accept an inbound cross-cluster connection request.
     */
    suspend fun acceptInboundConnection(block: AcceptInboundConnectionRequest.Builder.() -> Unit) = acceptInboundConnection(AcceptInboundConnectionRequest.Builder().apply(block).build())

    /**
     * Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to 10 tags. See [ Tagging Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging) for more information.
     */
    suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to 10 tags. See [ Tagging Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging) for more information.
     */
    suspend fun addTags(block: AddTagsRequest.Builder.() -> Unit) = addTags(AddTagsRequest.Builder().apply(block).build())

    /**
     * Associates a package with an Amazon OpenSearch Service domain.
     */
    suspend fun associatePackage(input: AssociatePackageRequest): AssociatePackageResponse

    /**
     * Associates a package with an Amazon OpenSearch Service domain.
     */
    suspend fun associatePackage(block: AssociatePackageRequest.Builder.() -> Unit) = associatePackage(AssociatePackageRequest.Builder().apply(block).build())

    /**
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
     */
    suspend fun cancelServiceSoftwareUpdate(input: CancelServiceSoftwareUpdateRequest): CancelServiceSoftwareUpdateResponse

    /**
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
     */
    suspend fun cancelServiceSoftwareUpdate(block: CancelServiceSoftwareUpdateRequest.Builder.() -> Unit) = cancelServiceSoftwareUpdate(CancelServiceSoftwareUpdateRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon OpenSearch Service domain. For more information, see [Creating and managing Amazon OpenSearch Service domains ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html) in the *Amazon OpenSearch Service Developer Guide*.
     */
    suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates a new Amazon OpenSearch Service domain. For more information, see [Creating and managing Amazon OpenSearch Service domains ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html) in the *Amazon OpenSearch Service Developer Guide*.
     */
    suspend fun createDomain(block: CreateDomainRequest.Builder.() -> Unit) = createDomain(CreateDomainRequest.Builder().apply(block).build())

    /**
     * Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.
     */
    suspend fun createOutboundConnection(input: CreateOutboundConnectionRequest): CreateOutboundConnectionResponse

    /**
     * Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.
     */
    suspend fun createOutboundConnection(block: CreateOutboundConnectionRequest.Builder.() -> Unit) = createOutboundConnection(CreateOutboundConnectionRequest.Builder().apply(block).build())

    /**
     * Create a package for use with Amazon OpenSearch Service domains.
     */
    suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse

    /**
     * Create a package for use with Amazon OpenSearch Service domains.
     */
    suspend fun createPackage(block: CreatePackageRequest.Builder.() -> Unit) = createPackage(CreatePackageRequest.Builder().apply(block).build())

    /**
     * Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    suspend fun deleteDomain(block: DeleteDomainRequest.Builder.() -> Unit) = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

    /**
     * Allows the remote domain owner to delete an existing inbound cross-cluster connection.
     */
    suspend fun deleteInboundConnection(input: DeleteInboundConnectionRequest): DeleteInboundConnectionResponse

    /**
     * Allows the remote domain owner to delete an existing inbound cross-cluster connection.
     */
    suspend fun deleteInboundConnection(block: DeleteInboundConnectionRequest.Builder.() -> Unit) = deleteInboundConnection(DeleteInboundConnectionRequest.Builder().apply(block).build())

    /**
     * Allows the local domain owner to delete an existing outbound cross-cluster connection.
     */
    suspend fun deleteOutboundConnection(input: DeleteOutboundConnectionRequest): DeleteOutboundConnectionResponse

    /**
     * Allows the local domain owner to delete an existing outbound cross-cluster connection.
     */
    suspend fun deleteOutboundConnection(block: DeleteOutboundConnectionRequest.Builder.() -> Unit) = deleteOutboundConnection(DeleteOutboundConnectionRequest.Builder().apply(block).build())

    /**
     * Deletes the package.
     */
    suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse

    /**
     * Deletes the package.
     */
    suspend fun deletePackage(block: DeletePackageRequest.Builder.() -> Unit) = deletePackage(DeletePackageRequest.Builder().apply(block).build())

    /**
     * Returns domain configuration information about the specified domain, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Returns domain configuration information about the specified domain, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeDomain(block: DescribeDomainRequest.Builder.() -> Unit) = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

    /**
     * Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    suspend fun describeDomainAutoTunes(input: DescribeDomainAutoTunesRequest): DescribeDomainAutoTunesResponse

    /**
     * Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    suspend fun describeDomainAutoTunes(block: DescribeDomainAutoTunesRequest.Builder.() -> Unit) = describeDomainAutoTunes(DescribeDomainAutoTunesRequest.Builder().apply(block).build())

    /**
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
     */
    suspend fun describeDomainChangeProgress(input: DescribeDomainChangeProgressRequest): DescribeDomainChangeProgressResponse

    /**
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
     */
    suspend fun describeDomainChangeProgress(block: DescribeDomainChangeProgressRequest.Builder.() -> Unit) = describeDomainChangeProgress(DescribeDomainChangeProgressRequest.Builder().apply(block).build())

    /**
     * Provides cluster configuration information about the specified domain, such as the state, creation date, update version, and update date for cluster options.
     */
    suspend fun describeDomainConfig(input: DescribeDomainConfigRequest): DescribeDomainConfigResponse

    /**
     * Provides cluster configuration information about the specified domain, such as the state, creation date, update version, and update date for cluster options.
     */
    suspend fun describeDomainConfig(block: DescribeDomainConfigRequest.Builder.() -> Unit) = describeDomainConfig(DescribeDomainConfigRequest.Builder().apply(block).build())

    /**
     * Returns domain configuration information about the specified domains, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeDomains(input: DescribeDomainsRequest): DescribeDomainsResponse

    /**
     * Returns domain configuration information about the specified domains, including the domain ID, domain endpoint, and domain ARN.
     */
    suspend fun describeDomains(block: DescribeDomainsRequest.Builder.() -> Unit) = describeDomains(DescribeDomainsRequest.Builder().apply(block).build())

    /**
     * Lists all the inbound cross-cluster connections for a remote domain.
     */
    suspend fun describeInboundConnections(input: DescribeInboundConnectionsRequest = DescribeInboundConnectionsRequest {}): DescribeInboundConnectionsResponse

    /**
     * Lists all the inbound cross-cluster connections for a remote domain.
     */
    suspend fun describeInboundConnections(block: DescribeInboundConnectionsRequest.Builder.() -> Unit) = describeInboundConnections(DescribeInboundConnectionsRequest.Builder().apply(block).build())

    /**
     * Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing domain, specify the ` <a>DomainName</a> ` to see which limits you can modify.
     */
    suspend fun describeInstanceTypeLimits(input: DescribeInstanceTypeLimitsRequest): DescribeInstanceTypeLimitsResponse

    /**
     * Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing domain, specify the ` <a>DomainName</a> ` to see which limits you can modify.
     */
    suspend fun describeInstanceTypeLimits(block: DescribeInstanceTypeLimitsRequest.Builder.() -> Unit) = describeInstanceTypeLimits(DescribeInstanceTypeLimitsRequest.Builder().apply(block).build())

    /**
     * Lists all the outbound cross-cluster connections for a local domain.
     */
    suspend fun describeOutboundConnections(input: DescribeOutboundConnectionsRequest = DescribeOutboundConnectionsRequest {}): DescribeOutboundConnectionsResponse

    /**
     * Lists all the outbound cross-cluster connections for a local domain.
     */
    suspend fun describeOutboundConnections(block: DescribeOutboundConnectionsRequest.Builder.() -> Unit) = describeOutboundConnections(DescribeOutboundConnectionsRequest.Builder().apply(block).build())

    /**
     * Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting the number of results, and pagination.
     */
    suspend fun describePackages(input: DescribePackagesRequest = DescribePackagesRequest {}): DescribePackagesResponse

    /**
     * Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting the number of results, and pagination.
     */
    suspend fun describePackages(block: DescribePackagesRequest.Builder.() -> Unit) = describePackages(DescribePackagesRequest.Builder().apply(block).build())

    /**
     * Lists available reserved OpenSearch instance offerings.
     */
    suspend fun describeReservedInstanceOfferings(input: DescribeReservedInstanceOfferingsRequest = DescribeReservedInstanceOfferingsRequest {}): DescribeReservedInstanceOfferingsResponse

    /**
     * Lists available reserved OpenSearch instance offerings.
     */
    suspend fun describeReservedInstanceOfferings(block: DescribeReservedInstanceOfferingsRequest.Builder.() -> Unit) = describeReservedInstanceOfferings(DescribeReservedInstanceOfferingsRequest.Builder().apply(block).build())

    /**
     * Returns information about reserved OpenSearch instances for this account.
     */
    suspend fun describeReservedInstances(input: DescribeReservedInstancesRequest = DescribeReservedInstancesRequest {}): DescribeReservedInstancesResponse

    /**
     * Returns information about reserved OpenSearch instances for this account.
     */
    suspend fun describeReservedInstances(block: DescribeReservedInstancesRequest.Builder.() -> Unit) = describeReservedInstances(DescribeReservedInstancesRequest.Builder().apply(block).build())

    /**
     * Dissociates a package from the Amazon OpenSearch Service domain.
     */
    suspend fun dissociatePackage(input: DissociatePackageRequest): DissociatePackageResponse

    /**
     * Dissociates a package from the Amazon OpenSearch Service domain.
     */
    suspend fun dissociatePackage(block: DissociatePackageRequest.Builder.() -> Unit) = dissociatePackage(DissociatePackageRequest.Builder().apply(block).build())

    /**
     * Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a ` <a>DomainName</a> ` to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that specific domain.
     */
    suspend fun getCompatibleVersions(input: GetCompatibleVersionsRequest = GetCompatibleVersionsRequest {}): GetCompatibleVersionsResponse

    /**
     * Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a ` <a>DomainName</a> ` to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that specific domain.
     */
    suspend fun getCompatibleVersions(block: GetCompatibleVersionsRequest.Builder.() -> Unit) = getCompatibleVersions(GetCompatibleVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of package versions, along with their creation time and commit message.
     */
    suspend fun getPackageVersionHistory(input: GetPackageVersionHistoryRequest): GetPackageVersionHistoryResponse

    /**
     * Returns a list of package versions, along with their creation time and commit message.
     */
    suspend fun getPackageVersionHistory(block: GetPackageVersionHistoryRequest.Builder.() -> Unit) = getPackageVersionHistory(GetPackageVersionHistoryRequest.Builder().apply(block).build())

    /**
     * Retrieves the complete history of the last 10 upgrades performed on the domain.
     */
    suspend fun getUpgradeHistory(input: GetUpgradeHistoryRequest): GetUpgradeHistoryResponse

    /**
     * Retrieves the complete history of the last 10 upgrades performed on the domain.
     */
    suspend fun getUpgradeHistory(block: GetUpgradeHistoryRequest.Builder.() -> Unit) = getUpgradeHistory(GetUpgradeHistoryRequest.Builder().apply(block).build())

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain.
     */
    suspend fun getUpgradeStatus(input: GetUpgradeStatusRequest): GetUpgradeStatusResponse

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain.
     */
    suspend fun getUpgradeStatus(block: GetUpgradeStatusRequest.Builder.() -> Unit) = getUpgradeStatus(GetUpgradeStatusRequest.Builder().apply(block).build())

    /**
     * Returns the names of all domains owned by the current user's account.
     */
    suspend fun listDomainNames(input: ListDomainNamesRequest = ListDomainNamesRequest {}): ListDomainNamesResponse

    /**
     * Returns the names of all domains owned by the current user's account.
     */
    suspend fun listDomainNames(block: ListDomainNamesRequest.Builder.() -> Unit) = listDomainNames(ListDomainNamesRequest.Builder().apply(block).build())

    /**
     * Lists all Amazon OpenSearch Service domains associated with the package.
     */
    suspend fun listDomainsForPackage(input: ListDomainsForPackageRequest): ListDomainsForPackageResponse

    /**
     * Lists all Amazon OpenSearch Service domains associated with the package.
     */
    suspend fun listDomainsForPackage(block: ListDomainsForPackageRequest.Builder.() -> Unit) = listDomainsForPackage(ListDomainsForPackageRequest.Builder().apply(block).build())

    suspend fun listInstanceTypeDetails(input: ListInstanceTypeDetailsRequest): ListInstanceTypeDetailsResponse

    suspend fun listInstanceTypeDetails(block: ListInstanceTypeDetailsRequest.Builder.() -> Unit) = listInstanceTypeDetails(ListInstanceTypeDetailsRequest.Builder().apply(block).build())

    /**
     * Lists all packages associated with the Amazon OpenSearch Service domain.
     */
    suspend fun listPackagesForDomain(input: ListPackagesForDomainRequest): ListPackagesForDomainResponse

    /**
     * Lists all packages associated with the Amazon OpenSearch Service domain.
     */
    suspend fun listPackagesForDomain(block: ListPackagesForDomainRequest.Builder.() -> Unit) = listPackagesForDomain(ListPackagesForDomainRequest.Builder().apply(block).build())

    /**
     * Returns all tags for the given domain.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Returns all tags for the given domain.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * List all supported versions of OpenSearch and Elasticsearch.
     */
    suspend fun listVersions(input: ListVersionsRequest = ListVersionsRequest {}): ListVersionsResponse

    /**
     * List all supported versions of OpenSearch and Elasticsearch.
     */
    suspend fun listVersions(block: ListVersionsRequest.Builder.() -> Unit) = listVersions(ListVersionsRequest.Builder().apply(block).build())

    /**
     * Allows you to purchase reserved OpenSearch instances.
     */
    suspend fun purchaseReservedInstanceOffering(input: PurchaseReservedInstanceOfferingRequest): PurchaseReservedInstanceOfferingResponse

    /**
     * Allows you to purchase reserved OpenSearch instances.
     */
    suspend fun purchaseReservedInstanceOffering(block: PurchaseReservedInstanceOfferingRequest.Builder.() -> Unit) = purchaseReservedInstanceOffering(PurchaseReservedInstanceOfferingRequest.Builder().apply(block).build())

    /**
     * Allows the remote domain owner to reject an inbound cross-cluster connection request.
     */
    suspend fun rejectInboundConnection(input: RejectInboundConnectionRequest): RejectInboundConnectionResponse

    /**
     * Allows the remote domain owner to reject an inbound cross-cluster connection request.
     */
    suspend fun rejectInboundConnection(block: RejectInboundConnectionRequest.Builder.() -> Unit) = rejectInboundConnection(RejectInboundConnectionRequest.Builder().apply(block).build())

    /**
     * Removes the specified set of tags from the given domain.
     */
    suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Removes the specified set of tags from the given domain.
     */
    suspend fun removeTags(block: RemoveTagsRequest.Builder.() -> Unit) = removeTags(RemoveTagsRequest.Builder().apply(block).build())

    /**
     * Schedules a service software update for an Amazon OpenSearch Service domain.
     */
    suspend fun startServiceSoftwareUpdate(input: StartServiceSoftwareUpdateRequest): StartServiceSoftwareUpdateResponse

    /**
     * Schedules a service software update for an Amazon OpenSearch Service domain.
     */
    suspend fun startServiceSoftwareUpdate(block: StartServiceSoftwareUpdateRequest.Builder.() -> Unit) = startServiceSoftwareUpdate(StartServiceSoftwareUpdateRequest.Builder().apply(block).build())

    /**
     * Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of instances.
     */
    suspend fun updateDomainConfig(input: UpdateDomainConfigRequest): UpdateDomainConfigResponse

    /**
     * Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of instances.
     */
    suspend fun updateDomainConfig(block: UpdateDomainConfigRequest.Builder.() -> Unit) = updateDomainConfig(UpdateDomainConfigRequest.Builder().apply(block).build())

    /**
     * Updates a package for use with Amazon OpenSearch Service domains.
     */
    suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse

    /**
     * Updates a package for use with Amazon OpenSearch Service domains.
     */
    suspend fun updatePackage(block: UpdatePackageRequest.Builder.() -> Unit) = updatePackage(UpdatePackageRequest.Builder().apply(block).build())

    /**
     * Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
     */
    suspend fun upgradeDomain(input: UpgradeDomainRequest): UpgradeDomainResponse

    /**
     * Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
     */
    suspend fun upgradeDomain(block: UpgradeDomainRequest.Builder.() -> Unit) = upgradeDomain(UpgradeDomainRequest.Builder().apply(block).build())
}
