// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Options to enable, disable, and specify the properties of EBS storage volumes.
 */
class EbsOptions private constructor(builder: Builder) {
    /**
     * Whether EBS-based storage is enabled.
     */
    val ebsEnabled: kotlin.Boolean? = builder.ebsEnabled
    /**
     * The IOPD for a Provisioned IOPS EBS volume (SSD).
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * Integer to specify the size of an EBS volume.
     */
    val volumeSize: kotlin.Int? = builder.volumeSize
    /**
     * The volume type for EBS-based storage.
     */
    val volumeType: aws.sdk.kotlin.services.opensearch.model.VolumeType? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.EbsOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsOptions(")
        append("ebsEnabled=$ebsEnabled,")
        append("iops=$iops,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ebsEnabled?.hashCode() ?: 0
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsOptions

        if (ebsEnabled != other.ebsEnabled) return false
        if (iops != other.iops) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.EbsOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether EBS-based storage is enabled.
         */
        var ebsEnabled: kotlin.Boolean? = null
        /**
         * The IOPD for a Provisioned IOPS EBS volume (SSD).
         */
        var iops: kotlin.Int? = null
        /**
         * Integer to specify the size of an EBS volume.
         */
        var volumeSize: kotlin.Int? = null
        /**
         * The volume type for EBS-based storage.
         */
        var volumeType: aws.sdk.kotlin.services.opensearch.model.VolumeType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.EbsOptions) : this() {
            this.ebsEnabled = x.ebsEnabled
            this.iops = x.iops
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.EbsOptions = EbsOptions(this)
    }
}
