// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * The connection status of an inbound cross-cluster connection.
 */
class InboundConnectionStatus private constructor(builder: Builder) {
    /**
     * Verbose information for the inbound connection status.
     */
    val message: kotlin.String? = builder.message
    /**
     * The state code for the inbound connection. Can be one of the following:
     * + PENDING_ACCEPTANCE: Inbound connection is not yet accepted by the remote domain owner.
     * + APPROVED: Inbound connection is pending acceptance by the remote domain owner.
     * + PROVISIONING: Inbound connection provisioning is in progress.
     * + ACTIVE: Inbound connection is active and ready to use.
     * + REJECTING: Inbound connection rejection is in process.
     * + REJECTED: Inbound connection is rejected.
     * + DELETING: Inbound connection deletion is in progress.
     * + DELETED: Inbound connection is deleted and can no longer be used.
     */
    val statusCode: aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatusCode? = builder.statusCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InboundConnectionStatus(")
        append("message=$message,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InboundConnectionStatus

        if (message != other.message) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * Verbose information for the inbound connection status.
         */
        var message: kotlin.String? = null
        /**
         * The state code for the inbound connection. Can be one of the following:
         * + PENDING_ACCEPTANCE: Inbound connection is not yet accepted by the remote domain owner.
         * + APPROVED: Inbound connection is pending acceptance by the remote domain owner.
         * + PROVISIONING: Inbound connection provisioning is in progress.
         * + ACTIVE: Inbound connection is active and ready to use.
         * + REJECTING: Inbound connection rejection is in process.
         * + REJECTED: Inbound connection is rejected.
         * + DELETING: Inbound connection deletion is in progress.
         * + DELETED: Inbound connection is deleted and can no longer be used.
         */
        var statusCode: aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatusCode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus) : this() {
            this.message = x.message
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.InboundConnectionStatus = InboundConnectionStatus(this)
    }
}
