// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Container for the parameters to the ` <a>ListVersions</a> ` operation.
 *
 *  Use ` <a>MaxResults</a> ` to control the maximum number of results to retrieve in a single call.
 *
 *  Use ` <a>NextToken</a> ` in response to retrieve more results. If the received response does not contain a NextToken, there are no more results to retrieve.
 */
class ListVersionsRequest private constructor(builder: Builder) {
    /**
     * Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ListVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListVersionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListVersionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ListVersionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set this value to limit the number of results returned. Value must be greater than 10 or it won't be honored.
         */
        var maxResults: kotlin.Int = 0
        /**
         * Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ListVersionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ListVersionsRequest = ListVersionsRequest(this)
    }
}
