// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details of a reserved OpenSearch instance.
 */
class ReservedInstance private constructor(builder: Builder) {
    val billingSubscriptionId: kotlin.Long? = builder.billingSubscriptionId
    /**
     * The currency code for the reserved OpenSearch instance offering.
     */
    val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration, in seconds, for which the OpenSearch instance is reserved.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * The upfront fixed charge you will paid to purchase the specific reserved OpenSearch instance offering.
     */
    val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * The number of OpenSearch instances that have been reserved.
     */
    val instanceCount: kotlin.Int = builder.instanceCount
    /**
     * The OpenSearch instance type offered by the reserved instance offering.
     */
    val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.instanceType
    /**
     * The payment option as defined in the reserved OpenSearch instance offering.
     */
    val paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = builder.paymentOption
    /**
     * The charge to your account regardless of whether you are creating any domains using the instance offering.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The customer-specified identifier to track this reservation.
     */
    val reservationName: kotlin.String? = builder.reservationName
    /**
     * The unique identifier for the reservation.
     */
    val reservedInstanceId: kotlin.String? = builder.reservedInstanceId
    /**
     * The offering identifier.
     */
    val reservedInstanceOfferingId: kotlin.String? = builder.reservedInstanceOfferingId
    /**
     * The time the reservation started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the reserved OpenSearch instance.
     */
    val state: kotlin.String? = builder.state
    /**
     * The rate you are charged for each hour for the domain that is using this reserved instance.
     */
    val usagePrice: kotlin.Double? = builder.usagePrice

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ReservedInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstance(")
        append("billingSubscriptionId=$billingSubscriptionId,")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("paymentOption=$paymentOption,")
        append("recurringCharges=$recurringCharges,")
        append("reservationName=$reservationName,")
        append("reservedInstanceId=$reservedInstanceId,")
        append("reservedInstanceOfferingId=$reservedInstanceOfferingId,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceCount)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservationName?.hashCode() ?: 0)
        result = 31 * result + (reservedInstanceId?.hashCode() ?: 0)
        result = 31 * result + (reservedInstanceOfferingId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedInstance

        if (billingSubscriptionId != other.billingSubscriptionId) return false
        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (paymentOption != other.paymentOption) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservationName != other.reservationName) return false
        if (reservedInstanceId != other.reservedInstanceId) return false
        if (reservedInstanceOfferingId != other.reservedInstanceOfferingId) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ReservedInstance = Builder(this).apply(block).build()

    class Builder {
        var billingSubscriptionId: kotlin.Long? = null
        /**
         * The currency code for the reserved OpenSearch instance offering.
         */
        var currencyCode: kotlin.String? = null
        /**
         * The duration, in seconds, for which the OpenSearch instance is reserved.
         */
        var duration: kotlin.Int = 0
        /**
         * The upfront fixed charge you will paid to purchase the specific reserved OpenSearch instance offering.
         */
        var fixedPrice: kotlin.Double? = null
        /**
         * The number of OpenSearch instances that have been reserved.
         */
        var instanceCount: kotlin.Int = 0
        /**
         * The OpenSearch instance type offered by the reserved instance offering.
         */
        var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * The payment option as defined in the reserved OpenSearch instance offering.
         */
        var paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = null
        /**
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         */
        var recurringCharges: List<RecurringCharge>? = null
        /**
         * The customer-specified identifier to track this reservation.
         */
        var reservationName: kotlin.String? = null
        /**
         * The unique identifier for the reservation.
         */
        var reservedInstanceId: kotlin.String? = null
        /**
         * The offering identifier.
         */
        var reservedInstanceOfferingId: kotlin.String? = null
        /**
         * The time the reservation started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the reserved OpenSearch instance.
         */
        var state: kotlin.String? = null
        /**
         * The rate you are charged for each hour for the domain that is using this reserved instance.
         */
        var usagePrice: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ReservedInstance) : this() {
            this.billingSubscriptionId = x.billingSubscriptionId
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.paymentOption = x.paymentOption
            this.recurringCharges = x.recurringCharges
            this.reservationName = x.reservationName
            this.reservedInstanceId = x.reservedInstanceId
            this.reservedInstanceOfferingId = x.reservedInstanceOfferingId
            this.startTime = x.startTime
            this.state = x.state
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ReservedInstance = ReservedInstance(this)
    }
}
