// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Details of a reserved OpenSearch instance offering.
 */
class ReservedInstanceOffering private constructor(builder: Builder) {
    /**
     * The currency code for the reserved OpenSearch instance offering.
     */
    val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration, in seconds, for which the offering will reserve the OpenSearch instance.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * The upfront fixed charge you will pay to purchase the specific reserved OpenSearch instance offering.
     */
    val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * The OpenSearch instance type offered by the reserved instance offering.
     */
    val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.instanceType
    /**
     * Payment option for the reserved OpenSearch instance offering
     */
    val paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = builder.paymentOption
    /**
     * The charge to your account regardless of whether you are creating any domains using the instance offering.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The OpenSearch reserved instance offering identifier.
     */
    val reservedInstanceOfferingId: kotlin.String? = builder.reservedInstanceOfferingId
    /**
     * The rate you are charged for each hour the domain that is using the offering is running.
     */
    val usagePrice: kotlin.Double? = builder.usagePrice

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedInstanceOffering(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("instanceType=$instanceType,")
        append("paymentOption=$paymentOption,")
        append("recurringCharges=$recurringCharges,")
        append("reservedInstanceOfferingId=$reservedInstanceOfferingId,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (paymentOption?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedInstanceOfferingId?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedInstanceOffering

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (instanceType != other.instanceType) return false
        if (paymentOption != other.paymentOption) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedInstanceOfferingId != other.reservedInstanceOfferingId) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering = Builder(this).apply(block).build()

    class Builder {
        /**
         * The currency code for the reserved OpenSearch instance offering.
         */
        var currencyCode: kotlin.String? = null
        /**
         * The duration, in seconds, for which the offering will reserve the OpenSearch instance.
         */
        var duration: kotlin.Int = 0
        /**
         * The upfront fixed charge you will pay to purchase the specific reserved OpenSearch instance offering.
         */
        var fixedPrice: kotlin.Double? = null
        /**
         * The OpenSearch instance type offered by the reserved instance offering.
         */
        var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * Payment option for the reserved OpenSearch instance offering
         */
        var paymentOption: aws.sdk.kotlin.services.opensearch.model.ReservedInstancePaymentOption? = null
        /**
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         */
        var recurringCharges: List<RecurringCharge>? = null
        /**
         * The OpenSearch reserved instance offering identifier.
         */
        var reservedInstanceOfferingId: kotlin.String? = null
        /**
         * The rate you are charged for each hour the domain that is using the offering is running.
         */
        var usagePrice: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.instanceType = x.instanceType
            this.paymentOption = x.paymentOption
            this.recurringCharges = x.recurringCharges
            this.reservedInstanceOfferingId = x.reservedInstanceOfferingId
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ReservedInstanceOffering = ReservedInstanceOffering(this)
    }
}
