// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * StorageTypes represents the list of storage-related types and their attributes that are available for a given InstanceType.
 */
class StorageType private constructor(builder: Builder) {
    /**
     * Sub-type of the given storage type. List of available sub-storage options: "instance" storageType has no storageSubType. "ebs" storageType has the following valid storageSubTypes:
     * + standard
     * + gp2
     * + io1
     *
     *  See ` <a>VolumeType</a> ` for more information regarding each EBS storage option.
     */
    val storageSubTypeName: kotlin.String? = builder.storageSubTypeName
    /**
     * Limits that are applicable for the given storage type.
     */
    val storageTypeLimits: List<StorageTypeLimit>? = builder.storageTypeLimits
    /**
     * Type of storage. List of available storage options:
     * + instance
     *  Built-in storage available for the instance + ebs
     *  Elastic block storage attached to the instance
     */
    val storageTypeName: kotlin.String? = builder.storageTypeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.StorageType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageType(")
        append("storageSubTypeName=$storageSubTypeName,")
        append("storageTypeLimits=$storageTypeLimits,")
        append("storageTypeName=$storageTypeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = storageSubTypeName?.hashCode() ?: 0
        result = 31 * result + (storageTypeLimits?.hashCode() ?: 0)
        result = 31 * result + (storageTypeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageType

        if (storageSubTypeName != other.storageSubTypeName) return false
        if (storageTypeLimits != other.storageTypeLimits) return false
        if (storageTypeName != other.storageTypeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.StorageType = Builder(this).apply(block).build()

    class Builder {
        /**
         * Sub-type of the given storage type. List of available sub-storage options: "instance" storageType has no storageSubType. "ebs" storageType has the following valid storageSubTypes:
         * + standard
         * + gp2
         * + io1
         *
         *  See ` <a>VolumeType</a> ` for more information regarding each EBS storage option.
         */
        var storageSubTypeName: kotlin.String? = null
        /**
         * Limits that are applicable for the given storage type.
         */
        var storageTypeLimits: List<StorageTypeLimit>? = null
        /**
         * Type of storage. List of available storage options:
         * + instance
         *  Built-in storage available for the instance + ebs
         *  Elastic block storage attached to the instance
         */
        var storageTypeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.StorageType) : this() {
            this.storageSubTypeName = x.storageSubTypeName
            this.storageTypeLimits = x.storageTypeLimits
            this.storageTypeName = x.storageTypeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.StorageType = StorageType(this)
    }
}
