// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Container for response returned by ` <a>UpgradeDomain</a> ` operation.
 */
class UpgradeDomainResponse private constructor(builder: Builder) {
    /**
     * Exposes select native OpenSearch configuration values from `opensearch.yml`. Currently, the following advanced options are available:
     * + Option to allow references to indices in an HTTP request body. Must be `false` when configuring access to individual sub-resources. By default, the value is `true`. See [Advanced cluster parameters ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options) for more information.
     * + Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded.
     *
     * For more information, see [ Advanced cluster parameters](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
     */
    val advancedOptions: Map<String, String>? = builder.advancedOptions
    /**
     * Specifies change details of the domain configuration change.
     */
    val changeProgressDetails: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails? = builder.changeProgressDetails
    /**
     * The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade.
     */
    val performCheckOnly: kotlin.Boolean? = builder.performCheckOnly
    /**
     * The version of OpenSearch that you intend to upgrade the domain to.
     */
    val targetVersion: kotlin.String? = builder.targetVersion
    val upgradeId: kotlin.String? = builder.upgradeId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeDomainResponse(")
        append("advancedOptions=$advancedOptions,")
        append("changeProgressDetails=$changeProgressDetails,")
        append("domainName=$domainName,")
        append("performCheckOnly=$performCheckOnly,")
        append("targetVersion=$targetVersion,")
        append("upgradeId=$upgradeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedOptions?.hashCode() ?: 0
        result = 31 * result + (changeProgressDetails?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (performCheckOnly?.hashCode() ?: 0)
        result = 31 * result + (targetVersion?.hashCode() ?: 0)
        result = 31 * result + (upgradeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeDomainResponse

        if (advancedOptions != other.advancedOptions) return false
        if (changeProgressDetails != other.changeProgressDetails) return false
        if (domainName != other.domainName) return false
        if (performCheckOnly != other.performCheckOnly) return false
        if (targetVersion != other.targetVersion) return false
        if (upgradeId != other.upgradeId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Exposes select native OpenSearch configuration values from `opensearch.yml`. Currently, the following advanced options are available:
         * + Option to allow references to indices in an HTTP request body. Must be `false` when configuring access to individual sub-resources. By default, the value is `true`. See [Advanced cluster parameters ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options) for more information.
         * + Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded.
         *
         * For more information, see [ Advanced cluster parameters](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
         */
        var advancedOptions: Map<String, String>? = null
        /**
         * Specifies change details of the domain configuration change.
         */
        var changeProgressDetails: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails? = null
        /**
         * The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: kotlin.String? = null
        /**
         * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade.
         */
        var performCheckOnly: kotlin.Boolean? = null
        /**
         * The version of OpenSearch that you intend to upgrade the domain to.
         */
        var targetVersion: kotlin.String? = null
        var upgradeId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.UpgradeDomainResponse) : this() {
            this.advancedOptions = x.advancedOptions
            this.changeProgressDetails = x.changeProgressDetails
            this.domainName = x.domainName
            this.performCheckOnly = x.performCheckOnly
            this.targetVersion = x.targetVersion
            this.upgradeId = x.upgradeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainResponse = UpgradeDomainResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails] inside the given [block]
         */
        fun changeProgressDetails(block: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails.Builder.() -> kotlin.Unit) {
            this.changeProgressDetails = aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails.invoke(block)
        }
    }
}
