// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.paginators

import aws.sdk.kotlin.services.opensearch.OpenSearchClient
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeDomainAutoTunesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeInboundConnectionsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeInboundConnectionsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeOutboundConnectionsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeOutboundConnectionsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribePackagesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribePackagesResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstanceOfferingsRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstanceOfferingsResponse
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstancesRequest
import aws.sdk.kotlin.services.opensearch.model.DescribeReservedInstancesResponse
import aws.sdk.kotlin.services.opensearch.model.GetPackageVersionHistoryRequest
import aws.sdk.kotlin.services.opensearch.model.GetPackageVersionHistoryResponse
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryRequest
import aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryResponse
import aws.sdk.kotlin.services.opensearch.model.ListDomainsForPackageRequest
import aws.sdk.kotlin.services.opensearch.model.ListDomainsForPackageResponse
import aws.sdk.kotlin.services.opensearch.model.ListInstanceTypeDetailsRequest
import aws.sdk.kotlin.services.opensearch.model.ListInstanceTypeDetailsResponse
import aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainRequest
import aws.sdk.kotlin.services.opensearch.model.ListPackagesForDomainResponse
import aws.sdk.kotlin.services.opensearch.model.ListVersionsRequest
import aws.sdk.kotlin.services.opensearch.model.ListVersionsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeDomainAutoTunesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDomainAutoTunesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDomainAutoTunesResponse]
 */
fun OpenSearchClient.describeDomainAutoTunesPaginated(initialRequest: DescribeDomainAutoTunesRequest): Flow<DescribeDomainAutoTunesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDomainAutoTunesPaginated.describeDomainAutoTunes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDomainAutoTunesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDomainAutoTunesResponse]
 */
fun OpenSearchClient.describeDomainAutoTunesPaginated(block: DescribeDomainAutoTunesRequest.Builder.() -> Unit): Flow<DescribeDomainAutoTunesResponse> =
    describeDomainAutoTunesPaginated(DescribeDomainAutoTunesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeInboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeInboundConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInboundConnectionsResponse]
 */
fun OpenSearchClient.describeInboundConnectionsPaginated(initialRequest: DescribeInboundConnectionsRequest): Flow<DescribeInboundConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeInboundConnectionsPaginated.describeInboundConnections(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeInboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeInboundConnectionsResponse]
 */
fun OpenSearchClient.describeInboundConnectionsPaginated(block: DescribeInboundConnectionsRequest.Builder.() -> Unit): Flow<DescribeInboundConnectionsResponse> =
    describeInboundConnectionsPaginated(DescribeInboundConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeOutboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOutboundConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOutboundConnectionsResponse]
 */
fun OpenSearchClient.describeOutboundConnectionsPaginated(initialRequest: DescribeOutboundConnectionsRequest): Flow<DescribeOutboundConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeOutboundConnectionsPaginated.describeOutboundConnections(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOutboundConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOutboundConnectionsResponse]
 */
fun OpenSearchClient.describeOutboundConnectionsPaginated(block: DescribeOutboundConnectionsRequest.Builder.() -> Unit): Flow<DescribeOutboundConnectionsResponse> =
    describeOutboundConnectionsPaginated(DescribeOutboundConnectionsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePackagesResponse]
 */
fun OpenSearchClient.describePackagesPaginated(initialRequest: DescribePackagesRequest): Flow<DescribePackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePackagesPaginated.describePackages(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePackagesResponse]
 */
fun OpenSearchClient.describePackagesPaginated(block: DescribePackagesRequest.Builder.() -> Unit): Flow<DescribePackagesResponse> =
    describePackagesPaginated(DescribePackagesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeReservedInstanceOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedInstanceOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstanceOfferingsResponse]
 */
fun OpenSearchClient.describeReservedInstanceOfferingsPaginated(initialRequest: DescribeReservedInstanceOfferingsRequest): Flow<DescribeReservedInstanceOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedInstanceOfferingsPaginated.describeReservedInstanceOfferings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedInstanceOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstanceOfferingsResponse]
 */
fun OpenSearchClient.describeReservedInstanceOfferingsPaginated(block: DescribeReservedInstanceOfferingsRequest.Builder.() -> Unit): Flow<DescribeReservedInstanceOfferingsResponse> =
    describeReservedInstanceOfferingsPaginated(DescribeReservedInstanceOfferingsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeReservedInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstancesResponse]
 */
fun OpenSearchClient.describeReservedInstancesPaginated(initialRequest: DescribeReservedInstancesRequest): Flow<DescribeReservedInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedInstancesPaginated.describeReservedInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedInstancesResponse]
 */
fun OpenSearchClient.describeReservedInstancesPaginated(block: DescribeReservedInstancesRequest.Builder.() -> Unit): Flow<DescribeReservedInstancesResponse> =
    describeReservedInstancesPaginated(DescribeReservedInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetPackageVersionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetPackageVersionHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPackageVersionHistoryResponse]
 */
fun OpenSearchClient.getPackageVersionHistoryPaginated(initialRequest: GetPackageVersionHistoryRequest): Flow<GetPackageVersionHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getPackageVersionHistoryPaginated.getPackageVersionHistory(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetPackageVersionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPackageVersionHistoryResponse]
 */
fun OpenSearchClient.getPackageVersionHistoryPaginated(block: GetPackageVersionHistoryRequest.Builder.() -> Unit): Flow<GetPackageVersionHistoryResponse> =
    getPackageVersionHistoryPaginated(GetPackageVersionHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [GetUpgradeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetUpgradeHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUpgradeHistoryResponse]
 */
fun OpenSearchClient.getUpgradeHistoryPaginated(initialRequest: GetUpgradeHistoryRequest): Flow<GetUpgradeHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getUpgradeHistoryPaginated.getUpgradeHistory(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetUpgradeHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUpgradeHistoryResponse]
 */
fun OpenSearchClient.getUpgradeHistoryPaginated(block: GetUpgradeHistoryRequest.Builder.() -> Unit): Flow<GetUpgradeHistoryResponse> =
    getUpgradeHistoryPaginated(GetUpgradeHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDomainsForPackageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsForPackageRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsForPackageResponse]
 */
fun OpenSearchClient.listDomainsForPackagePaginated(initialRequest: ListDomainsForPackageRequest): Flow<ListDomainsForPackageResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainsForPackagePaginated.listDomainsForPackage(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsForPackageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsForPackageResponse]
 */
fun OpenSearchClient.listDomainsForPackagePaginated(block: ListDomainsForPackageRequest.Builder.() -> Unit): Flow<ListDomainsForPackageResponse> =
    listDomainsForPackagePaginated(ListDomainsForPackageRequest.Builder().apply(block).build())

/**
 * Paginate over [ListInstanceTypeDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceTypeDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceTypeDetailsResponse]
 */
fun OpenSearchClient.listInstanceTypeDetailsPaginated(initialRequest: ListInstanceTypeDetailsRequest): Flow<ListInstanceTypeDetailsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstanceTypeDetailsPaginated.listInstanceTypeDetails(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceTypeDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceTypeDetailsResponse]
 */
fun OpenSearchClient.listInstanceTypeDetailsPaginated(block: ListInstanceTypeDetailsRequest.Builder.() -> Unit): Flow<ListInstanceTypeDetailsResponse> =
    listInstanceTypeDetailsPaginated(ListInstanceTypeDetailsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPackagesForDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackagesForDomainRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesForDomainResponse]
 */
fun OpenSearchClient.listPackagesForDomainPaginated(initialRequest: ListPackagesForDomainRequest): Flow<ListPackagesForDomainResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackagesForDomainPaginated.listPackagesForDomain(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPackagesForDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesForDomainResponse]
 */
fun OpenSearchClient.listPackagesForDomainPaginated(block: ListPackagesForDomainRequest.Builder.() -> Unit): Flow<ListPackagesForDomainResponse> =
    listPackagesForDomainPaginated(ListPackagesForDomainRequest.Builder().apply(block).build())

/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
fun OpenSearchClient.listVersionsPaginated(initialRequest: ListVersionsRequest): Flow<ListVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVersionsPaginated.listVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
fun OpenSearchClient.listVersionsPaginated(block: ListVersionsRequest.Builder.() -> Unit): Flow<ListVersionsResponse> =
    listVersionsPaginated(ListVersionsRequest.Builder().apply(block).build())
