// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.sdk.kotlin.services.opensearch.model.UpgradeDomainResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpgradeDomainOperationDeserializer: HttpDeserialize<UpgradeDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpgradeDomainResponse {
        if (!response.status.isSuccess()) {
            throwUpgradeDomainError(context, response)
        }
        val builder = UpgradeDomainResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpgradeDomainOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpgradeDomainError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpgradeDomainOperationBody(builder: UpgradeDomainResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADVANCEDOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AdvancedOptions"))
    val CHANGEPROGRESSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ChangeProgressDetails"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val PERFORMCHECKONLY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PerformCheckOnly"))
    val TARGETVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetVersion"))
    val UPGRADEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpgradeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADVANCEDOPTIONS_DESCRIPTOR)
        field(CHANGEPROGRESSDETAILS_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(PERFORMCHECKONLY_DESCRIPTOR)
        field(TARGETVERSION_DESCRIPTOR)
        field(UPGRADEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADVANCEDOPTIONS_DESCRIPTOR.index -> builder.advancedOptions =
                    deserializer.deserializeMap(ADVANCEDOPTIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CHANGEPROGRESSDETAILS_DESCRIPTOR.index -> builder.changeProgressDetails = deserializeChangeProgressDetailsDocument(deserializer)
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                PERFORMCHECKONLY_DESCRIPTOR.index -> builder.performCheckOnly = deserializeBoolean()
                TARGETVERSION_DESCRIPTOR.index -> builder.targetVersion = deserializeString()
                UPGRADEID_DESCRIPTOR.index -> builder.upgradeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
