// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.opensearch.model.*
import aws.sdk.kotlin.services.opensearch.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "OpenSearch"
const val ServiceApiVersion: String = "2021-01-01"
const val SdkVersion: String = "0.16.7-beta"

internal class DefaultOpenSearchClient(override val config: OpenSearchClient.Config) : OpenSearchClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Allows the remote domain owner to accept an inbound cross-cluster connection request.
     */
    override suspend fun acceptInboundConnection(input: AcceptInboundConnectionRequest): AcceptInboundConnectionResponse {
        val op = SdkHttpOperation.build<AcceptInboundConnectionRequest, AcceptInboundConnectionResponse> {
            serializer = AcceptInboundConnectionOperationSerializer()
            deserializer = AcceptInboundConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptInboundConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to 10 tags. See [ Tagging Amazon OpenSearch Service domains](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging) for more information.
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializer = AddTagsOperationSerializer()
            deserializer = AddTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a package with an Amazon OpenSearch Service domain.
     */
    override suspend fun associatePackage(input: AssociatePackageRequest): AssociatePackageResponse {
        val op = SdkHttpOperation.build<AssociatePackageRequest, AssociatePackageResponse> {
            serializer = AssociatePackageOperationSerializer()
            deserializer = AssociatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
     */
    override suspend fun cancelServiceSoftwareUpdate(input: CancelServiceSoftwareUpdateRequest): CancelServiceSoftwareUpdateResponse {
        val op = SdkHttpOperation.build<CancelServiceSoftwareUpdateRequest, CancelServiceSoftwareUpdateResponse> {
            serializer = CancelServiceSoftwareUpdateOperationSerializer()
            deserializer = CancelServiceSoftwareUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelServiceSoftwareUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon OpenSearch Service domain. For more information, see [Creating and managing Amazon OpenSearch Service domains ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html) in the *Amazon OpenSearch Service Developer Guide*.
     */
    override suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse {
        val op = SdkHttpOperation.build<CreateDomainRequest, CreateDomainResponse> {
            serializer = CreateDomainOperationSerializer()
            deserializer = CreateDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.
     */
    override suspend fun createOutboundConnection(input: CreateOutboundConnectionRequest): CreateOutboundConnectionResponse {
        val op = SdkHttpOperation.build<CreateOutboundConnectionRequest, CreateOutboundConnectionResponse> {
            serializer = CreateOutboundConnectionOperationSerializer()
            deserializer = CreateOutboundConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateOutboundConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a package for use with Amazon OpenSearch Service domains.
     */
    override suspend fun createPackage(input: CreatePackageRequest): CreatePackageResponse {
        val op = SdkHttpOperation.build<CreatePackageRequest, CreatePackageResponse> {
            serializer = CreatePackageOperationSerializer()
            deserializer = CreatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered.
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializer = DeleteDomainOperationSerializer()
            deserializer = DeleteDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows the remote domain owner to delete an existing inbound cross-cluster connection.
     */
    override suspend fun deleteInboundConnection(input: DeleteInboundConnectionRequest): DeleteInboundConnectionResponse {
        val op = SdkHttpOperation.build<DeleteInboundConnectionRequest, DeleteInboundConnectionResponse> {
            serializer = DeleteInboundConnectionOperationSerializer()
            deserializer = DeleteInboundConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInboundConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows the local domain owner to delete an existing outbound cross-cluster connection.
     */
    override suspend fun deleteOutboundConnection(input: DeleteOutboundConnectionRequest): DeleteOutboundConnectionResponse {
        val op = SdkHttpOperation.build<DeleteOutboundConnectionRequest, DeleteOutboundConnectionResponse> {
            serializer = DeleteOutboundConnectionOperationSerializer()
            deserializer = DeleteOutboundConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteOutboundConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the package.
     */
    override suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse {
        val op = SdkHttpOperation.build<DeletePackageRequest, DeletePackageResponse> {
            serializer = DeletePackageOperationSerializer()
            deserializer = DeletePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns domain configuration information about the specified domain, including the domain ID, domain endpoint, and domain ARN.
     */
    override suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse {
        val op = SdkHttpOperation.build<DescribeDomainRequest, DescribeDomainResponse> {
            serializer = DescribeDomainOperationSerializer()
            deserializer = DescribeDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity, and scheduled date.
     */
    override suspend fun describeDomainAutoTunes(input: DescribeDomainAutoTunesRequest): DescribeDomainAutoTunesResponse {
        val op = SdkHttpOperation.build<DescribeDomainAutoTunesRequest, DescribeDomainAutoTunesResponse> {
            serializer = DescribeDomainAutoTunesOperationSerializer()
            deserializer = DescribeDomainAutoTunesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomainAutoTunes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
     */
    override suspend fun describeDomainChangeProgress(input: DescribeDomainChangeProgressRequest): DescribeDomainChangeProgressResponse {
        val op = SdkHttpOperation.build<DescribeDomainChangeProgressRequest, DescribeDomainChangeProgressResponse> {
            serializer = DescribeDomainChangeProgressOperationSerializer()
            deserializer = DescribeDomainChangeProgressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomainChangeProgress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides cluster configuration information about the specified domain, such as the state, creation date, update version, and update date for cluster options.
     */
    override suspend fun describeDomainConfig(input: DescribeDomainConfigRequest): DescribeDomainConfigResponse {
        val op = SdkHttpOperation.build<DescribeDomainConfigRequest, DescribeDomainConfigResponse> {
            serializer = DescribeDomainConfigOperationSerializer()
            deserializer = DescribeDomainConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomainConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns domain configuration information about the specified domains, including the domain ID, domain endpoint, and domain ARN.
     */
    override suspend fun describeDomains(input: DescribeDomainsRequest): DescribeDomainsResponse {
        val op = SdkHttpOperation.build<DescribeDomainsRequest, DescribeDomainsResponse> {
            serializer = DescribeDomainsOperationSerializer()
            deserializer = DescribeDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the inbound cross-cluster connections for a remote domain.
     */
    override suspend fun describeInboundConnections(input: DescribeInboundConnectionsRequest): DescribeInboundConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeInboundConnectionsRequest, DescribeInboundConnectionsResponse> {
            serializer = DescribeInboundConnectionsOperationSerializer()
            deserializer = DescribeInboundConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInboundConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing domain, specify the ` <a>DomainName</a> ` to see which limits you can modify.
     */
    override suspend fun describeInstanceTypeLimits(input: DescribeInstanceTypeLimitsRequest): DescribeInstanceTypeLimitsResponse {
        val op = SdkHttpOperation.build<DescribeInstanceTypeLimitsRequest, DescribeInstanceTypeLimitsResponse> {
            serializer = DescribeInstanceTypeLimitsOperationSerializer()
            deserializer = DescribeInstanceTypeLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceTypeLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the outbound cross-cluster connections for a local domain.
     */
    override suspend fun describeOutboundConnections(input: DescribeOutboundConnectionsRequest): DescribeOutboundConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeOutboundConnectionsRequest, DescribeOutboundConnectionsResponse> {
            serializer = DescribeOutboundConnectionsOperationSerializer()
            deserializer = DescribeOutboundConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOutboundConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting the number of results, and pagination.
     */
    override suspend fun describePackages(input: DescribePackagesRequest): DescribePackagesResponse {
        val op = SdkHttpOperation.build<DescribePackagesRequest, DescribePackagesResponse> {
            serializer = DescribePackagesOperationSerializer()
            deserializer = DescribePackagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePackages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists available reserved OpenSearch instance offerings.
     */
    override suspend fun describeReservedInstanceOfferings(input: DescribeReservedInstanceOfferingsRequest): DescribeReservedInstanceOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedInstanceOfferingsRequest, DescribeReservedInstanceOfferingsResponse> {
            serializer = DescribeReservedInstanceOfferingsOperationSerializer()
            deserializer = DescribeReservedInstanceOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedInstanceOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about reserved OpenSearch instances for this account.
     */
    override suspend fun describeReservedInstances(input: DescribeReservedInstancesRequest): DescribeReservedInstancesResponse {
        val op = SdkHttpOperation.build<DescribeReservedInstancesRequest, DescribeReservedInstancesResponse> {
            serializer = DescribeReservedInstancesOperationSerializer()
            deserializer = DescribeReservedInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Dissociates a package from the Amazon OpenSearch Service domain.
     */
    override suspend fun dissociatePackage(input: DissociatePackageRequest): DissociatePackageResponse {
        val op = SdkHttpOperation.build<DissociatePackageRequest, DissociatePackageResponse> {
            serializer = DissociatePackageOperationSerializer()
            deserializer = DissociatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DissociatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a ` <a>DomainName</a> ` to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that specific domain.
     */
    override suspend fun getCompatibleVersions(input: GetCompatibleVersionsRequest): GetCompatibleVersionsResponse {
        val op = SdkHttpOperation.build<GetCompatibleVersionsRequest, GetCompatibleVersionsResponse> {
            serializer = GetCompatibleVersionsOperationSerializer()
            deserializer = GetCompatibleVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCompatibleVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of package versions, along with their creation time and commit message.
     */
    override suspend fun getPackageVersionHistory(input: GetPackageVersionHistoryRequest): GetPackageVersionHistoryResponse {
        val op = SdkHttpOperation.build<GetPackageVersionHistoryRequest, GetPackageVersionHistoryResponse> {
            serializer = GetPackageVersionHistoryOperationSerializer()
            deserializer = GetPackageVersionHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPackageVersionHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the complete history of the last 10 upgrades performed on the domain.
     */
    override suspend fun getUpgradeHistory(input: GetUpgradeHistoryRequest): GetUpgradeHistoryResponse {
        val op = SdkHttpOperation.build<GetUpgradeHistoryRequest, GetUpgradeHistoryResponse> {
            serializer = GetUpgradeHistoryOperationSerializer()
            deserializer = GetUpgradeHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUpgradeHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain.
     */
    override suspend fun getUpgradeStatus(input: GetUpgradeStatusRequest): GetUpgradeStatusResponse {
        val op = SdkHttpOperation.build<GetUpgradeStatusRequest, GetUpgradeStatusResponse> {
            serializer = GetUpgradeStatusOperationSerializer()
            deserializer = GetUpgradeStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUpgradeStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the names of all domains owned by the current user's account.
     */
    override suspend fun listDomainNames(input: ListDomainNamesRequest): ListDomainNamesResponse {
        val op = SdkHttpOperation.build<ListDomainNamesRequest, ListDomainNamesResponse> {
            serializer = ListDomainNamesOperationSerializer()
            deserializer = ListDomainNamesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainNames"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Amazon OpenSearch Service domains associated with the package.
     */
    override suspend fun listDomainsForPackage(input: ListDomainsForPackageRequest): ListDomainsForPackageResponse {
        val op = SdkHttpOperation.build<ListDomainsForPackageRequest, ListDomainsForPackageResponse> {
            serializer = ListDomainsForPackageOperationSerializer()
            deserializer = ListDomainsForPackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainsForPackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    override suspend fun listInstanceTypeDetails(input: ListInstanceTypeDetailsRequest): ListInstanceTypeDetailsResponse {
        val op = SdkHttpOperation.build<ListInstanceTypeDetailsRequest, ListInstanceTypeDetailsResponse> {
            serializer = ListInstanceTypeDetailsOperationSerializer()
            deserializer = ListInstanceTypeDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstanceTypeDetails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all packages associated with the Amazon OpenSearch Service domain.
     */
    override suspend fun listPackagesForDomain(input: ListPackagesForDomainRequest): ListPackagesForDomainResponse {
        val op = SdkHttpOperation.build<ListPackagesForDomainRequest, ListPackagesForDomainResponse> {
            serializer = ListPackagesForDomainOperationSerializer()
            deserializer = ListPackagesForDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPackagesForDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all tags for the given domain.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all supported versions of OpenSearch and Elasticsearch.
     */
    override suspend fun listVersions(input: ListVersionsRequest): ListVersionsResponse {
        val op = SdkHttpOperation.build<ListVersionsRequest, ListVersionsResponse> {
            serializer = ListVersionsOperationSerializer()
            deserializer = ListVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to purchase reserved OpenSearch instances.
     */
    override suspend fun purchaseReservedInstanceOffering(input: PurchaseReservedInstanceOfferingRequest): PurchaseReservedInstanceOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseReservedInstanceOfferingRequest, PurchaseReservedInstanceOfferingResponse> {
            serializer = PurchaseReservedInstanceOfferingOperationSerializer()
            deserializer = PurchaseReservedInstanceOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PurchaseReservedInstanceOffering"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows the remote domain owner to reject an inbound cross-cluster connection request.
     */
    override suspend fun rejectInboundConnection(input: RejectInboundConnectionRequest): RejectInboundConnectionResponse {
        val op = SdkHttpOperation.build<RejectInboundConnectionRequest, RejectInboundConnectionResponse> {
            serializer = RejectInboundConnectionOperationSerializer()
            deserializer = RejectInboundConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectInboundConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified set of tags from the given domain.
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializer = RemoveTagsOperationSerializer()
            deserializer = RemoveTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Schedules a service software update for an Amazon OpenSearch Service domain.
     */
    override suspend fun startServiceSoftwareUpdate(input: StartServiceSoftwareUpdateRequest): StartServiceSoftwareUpdateResponse {
        val op = SdkHttpOperation.build<StartServiceSoftwareUpdateRequest, StartServiceSoftwareUpdateResponse> {
            serializer = StartServiceSoftwareUpdateOperationSerializer()
            deserializer = StartServiceSoftwareUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartServiceSoftwareUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of instances.
     */
    override suspend fun updateDomainConfig(input: UpdateDomainConfigRequest): UpdateDomainConfigResponse {
        val op = SdkHttpOperation.build<UpdateDomainConfigRequest, UpdateDomainConfigResponse> {
            serializer = UpdateDomainConfigOperationSerializer()
            deserializer = UpdateDomainConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a package for use with Amazon OpenSearch Service domains.
     */
    override suspend fun updatePackage(input: UpdatePackageRequest): UpdatePackageResponse {
        val op = SdkHttpOperation.build<UpdatePackageRequest, UpdatePackageResponse> {
            serializer = UpdatePackageOperationSerializer()
            deserializer = UpdatePackageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePackage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
     */
    override suspend fun upgradeDomain(input: UpgradeDomainRequest): UpgradeDomainResponse {
        val op = SdkHttpOperation.build<UpgradeDomainRequest, UpgradeDomainResponse> {
            serializer = UpgradeDomainOperationSerializer()
            deserializer = UpgradeDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpgradeDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "es"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "es")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
