// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The progress details of a specific domain configuration change.
 */
class ChangeProgressStatusDetails private constructor(builder: Builder) {
    /**
     * The unique change identifier associated with a specific domain configuration change.
     */
    val changeId: kotlin.String? = builder.changeId
    /**
     * The specific stages that the domain is going through to perform the configuration change.
     */
    val changeProgressStages: List<ChangeProgressStage>? = builder.changeProgressStages
    /**
     * The list of properties involved in the domain configuration change that are completed.
     */
    val completedProperties: List<String>? = builder.completedProperties
    /**
     * The list of properties involved in the domain configuration change that are still in pending.
     */
    val pendingProperties: List<String>? = builder.pendingProperties
    /**
     * The time at which the configuration change is made on the domain.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The overall status of the domain configuration change. This field can take the following values: `PENDING`, `PROCESSING`, `COMPLETED` and `FAILED`
     */
    val status: aws.sdk.kotlin.services.opensearch.model.OverallChangeStatus? = builder.status
    /**
     * The total number of stages required for the configuration change.
     */
    val totalNumberOfStages: kotlin.Int = builder.totalNumberOfStages

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeProgressStatusDetails(")
        append("changeId=$changeId,")
        append("changeProgressStages=$changeProgressStages,")
        append("completedProperties=$completedProperties,")
        append("pendingProperties=$pendingProperties,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("totalNumberOfStages=$totalNumberOfStages)")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeId?.hashCode() ?: 0
        result = 31 * result + (changeProgressStages?.hashCode() ?: 0)
        result = 31 * result + (completedProperties?.hashCode() ?: 0)
        result = 31 * result + (pendingProperties?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalNumberOfStages)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeProgressStatusDetails

        if (changeId != other.changeId) return false
        if (changeProgressStages != other.changeProgressStages) return false
        if (completedProperties != other.completedProperties) return false
        if (pendingProperties != other.pendingProperties) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (totalNumberOfStages != other.totalNumberOfStages) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique change identifier associated with a specific domain configuration change.
         */
        var changeId: kotlin.String? = null
        /**
         * The specific stages that the domain is going through to perform the configuration change.
         */
        var changeProgressStages: List<ChangeProgressStage>? = null
        /**
         * The list of properties involved in the domain configuration change that are completed.
         */
        var completedProperties: List<String>? = null
        /**
         * The list of properties involved in the domain configuration change that are still in pending.
         */
        var pendingProperties: List<String>? = null
        /**
         * The time at which the configuration change is made on the domain.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The overall status of the domain configuration change. This field can take the following values: `PENDING`, `PROCESSING`, `COMPLETED` and `FAILED`
         */
        var status: aws.sdk.kotlin.services.opensearch.model.OverallChangeStatus? = null
        /**
         * The total number of stages required for the configuration change.
         */
        var totalNumberOfStages: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails) : this() {
            this.changeId = x.changeId
            this.changeProgressStages = x.changeProgressStages
            this.completedProperties = x.completedProperties
            this.pendingProperties = x.pendingProperties
            this.startTime = x.startTime
            this.status = x.status
            this.totalNumberOfStages = x.totalNumberOfStages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ChangeProgressStatusDetails = ChangeProgressStatusDetails(this)
    }
}
