// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * The configuration for the domain cluster, such as the type and number of instances.
 */
class ClusterConfig private constructor(builder: Builder) {
    /**
     * Specifies the `ColdStorageOptions` config for a Domain
     */
    val coldStorageOptions: aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions? = builder.coldStorageOptions
    /**
     * Total number of dedicated master nodes, active and on standby, for the cluster.
     */
    val dedicatedMasterCount: kotlin.Int? = builder.dedicatedMasterCount
    /**
     * A boolean value to indicate whether a dedicated master node is enabled. See [Dedicated master nodes in Amazon OpenSearch Service ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-dedicatedmasternodes) for more information.
     */
    val dedicatedMasterEnabled: kotlin.Boolean? = builder.dedicatedMasterEnabled
    /**
     * The instance type for a dedicated master node.
     */
    val dedicatedMasterType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.dedicatedMasterType
    /**
     * The number of instances in the specified domain cluster.
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The instance type for an OpenSearch cluster. UltraWarm instance types are not supported for data instances.
     */
    val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = builder.instanceType
    /**
     * The number of UltraWarm nodes in the cluster.
     */
    val warmCount: kotlin.Int? = builder.warmCount
    /**
     * True to enable UltraWarm storage.
     */
    val warmEnabled: kotlin.Boolean? = builder.warmEnabled
    /**
     * The instance type for the OpenSearch cluster's warm nodes.
     */
    val warmType: aws.sdk.kotlin.services.opensearch.model.OpenSearchWarmPartitionInstanceType? = builder.warmType
    /**
     * The zone awareness configuration for a domain when zone awareness is enabled.
     */
    val zoneAwarenessConfig: aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig? = builder.zoneAwarenessConfig
    /**
     * A boolean value to indicate whether zone awareness is enabled. See [Configuring a multi-AZ domain in Amazon OpenSearch Service ](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html) for more information.
     */
    val zoneAwarenessEnabled: kotlin.Boolean? = builder.zoneAwarenessEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ClusterConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterConfig(")
        append("coldStorageOptions=$coldStorageOptions,")
        append("dedicatedMasterCount=$dedicatedMasterCount,")
        append("dedicatedMasterEnabled=$dedicatedMasterEnabled,")
        append("dedicatedMasterType=$dedicatedMasterType,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("warmCount=$warmCount,")
        append("warmEnabled=$warmEnabled,")
        append("warmType=$warmType,")
        append("zoneAwarenessConfig=$zoneAwarenessConfig,")
        append("zoneAwarenessEnabled=$zoneAwarenessEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = coldStorageOptions?.hashCode() ?: 0
        result = 31 * result + (dedicatedMasterCount ?: 0)
        result = 31 * result + (dedicatedMasterEnabled?.hashCode() ?: 0)
        result = 31 * result + (dedicatedMasterType?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (warmCount ?: 0)
        result = 31 * result + (warmEnabled?.hashCode() ?: 0)
        result = 31 * result + (warmType?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessConfig?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterConfig

        if (coldStorageOptions != other.coldStorageOptions) return false
        if (dedicatedMasterCount != other.dedicatedMasterCount) return false
        if (dedicatedMasterEnabled != other.dedicatedMasterEnabled) return false
        if (dedicatedMasterType != other.dedicatedMasterType) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (warmCount != other.warmCount) return false
        if (warmEnabled != other.warmEnabled) return false
        if (warmType != other.warmType) return false
        if (zoneAwarenessConfig != other.zoneAwarenessConfig) return false
        if (zoneAwarenessEnabled != other.zoneAwarenessEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ClusterConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the `ColdStorageOptions` config for a Domain
         */
        var coldStorageOptions: aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions? = null
        /**
         * Total number of dedicated master nodes, active and on standby, for the cluster.
         */
        var dedicatedMasterCount: kotlin.Int? = null
        /**
         * A boolean value to indicate whether a dedicated master node is enabled. See [Dedicated master nodes in Amazon OpenSearch Service ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-dedicatedmasternodes) for more information.
         */
        var dedicatedMasterEnabled: kotlin.Boolean? = null
        /**
         * The instance type for a dedicated master node.
         */
        var dedicatedMasterType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * The number of instances in the specified domain cluster.
         */
        var instanceCount: kotlin.Int? = null
        /**
         * The instance type for an OpenSearch cluster. UltraWarm instance types are not supported for data instances.
         */
        var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null
        /**
         * The number of UltraWarm nodes in the cluster.
         */
        var warmCount: kotlin.Int? = null
        /**
         * True to enable UltraWarm storage.
         */
        var warmEnabled: kotlin.Boolean? = null
        /**
         * The instance type for the OpenSearch cluster's warm nodes.
         */
        var warmType: aws.sdk.kotlin.services.opensearch.model.OpenSearchWarmPartitionInstanceType? = null
        /**
         * The zone awareness configuration for a domain when zone awareness is enabled.
         */
        var zoneAwarenessConfig: aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig? = null
        /**
         * A boolean value to indicate whether zone awareness is enabled. See [Configuring a multi-AZ domain in Amazon OpenSearch Service ](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html) for more information.
         */
        var zoneAwarenessEnabled: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ClusterConfig) : this() {
            this.coldStorageOptions = x.coldStorageOptions
            this.dedicatedMasterCount = x.dedicatedMasterCount
            this.dedicatedMasterEnabled = x.dedicatedMasterEnabled
            this.dedicatedMasterType = x.dedicatedMasterType
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.warmCount = x.warmCount
            this.warmEnabled = x.warmEnabled
            this.warmType = x.warmType
            this.zoneAwarenessConfig = x.zoneAwarenessConfig
            this.zoneAwarenessEnabled = x.zoneAwarenessEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ClusterConfig = ClusterConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions] inside the given [block]
         */
        fun coldStorageOptions(block: aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions.Builder.() -> kotlin.Unit) {
            this.coldStorageOptions = aws.sdk.kotlin.services.opensearch.model.ColdStorageOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig] inside the given [block]
         */
        fun zoneAwarenessConfig(block: aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig.Builder.() -> kotlin.Unit) {
            this.zoneAwarenessConfig = aws.sdk.kotlin.services.opensearch.model.ZoneAwarenessConfig.invoke(block)
        }
    }
}
