// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see [Configuring Amazon Cognito authentication for OpenSearch Dashboards](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
 */
class CognitoOptions private constructor(builder: Builder) {
    /**
     * The option to enable Cognito for OpenSearch Dashboards authentication.
     */
    val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The Cognito identity pool ID for OpenSearch Dashboards authentication.
     */
    val identityPoolId: kotlin.String? = builder.identityPoolId
    /**
     * The role ARN that provides OpenSearch permissions for accessing Cognito resources.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Cognito user pool ID for OpenSearch Dashboards authentication.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.CognitoOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoOptions(")
        append("enabled=$enabled,")
        append("identityPoolId=$identityPoolId,")
        append("roleArn=$roleArn,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (identityPoolId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoOptions

        if (enabled != other.enabled) return false
        if (identityPoolId != other.identityPoolId) return false
        if (roleArn != other.roleArn) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.CognitoOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * The option to enable Cognito for OpenSearch Dashboards authentication.
         */
        var enabled: kotlin.Boolean? = null
        /**
         * The Cognito identity pool ID for OpenSearch Dashboards authentication.
         */
        var identityPoolId: kotlin.String? = null
        /**
         * The role ARN that provides OpenSearch permissions for accessing Cognito resources.
         */
        var roleArn: kotlin.String? = null
        /**
         * The Cognito user pool ID for OpenSearch Dashboards authentication.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.CognitoOptions) : this() {
            this.enabled = x.enabled
            this.identityPoolId = x.identityPoolId
            this.roleArn = x.roleArn
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.CognitoOptions = CognitoOptions(this)
    }
}
